﻿// TcpDataReceivedEventArgs.cs
//
// Author:
// tsntsumi <tsntsumi at tsntsumi.com>
//
// Copyright (c) 2015 tsntsumi
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.

/// @file
/// <summary>
/// TCP データ受信イベント引数。
/// </summary>
/// @since 2015.8.12
using System;

namespace SocketNet
{
	/// <summary>
	/// Tcpデータ受信イベントのデータ。
	/// </summary>
	public class TcpDataReceivedEventArgs : EventArgs
	{
		/// <summary>
		/// 関連付けられた接続を返します。
		/// </summary>
		public TcpConnection Connection { get; private set; }

		/// <summary>
		/// 関連付けられたデータを取得します。
		/// </summary>
		public byte[] Data { get; private set; }

		/// <summary>
		/// コンストラクタ。
		/// </summary>
		/// <param name="connection">関連付けられた接続。</param>
		/// <param name="data">関連付けられたデータ。</param>
		public TcpDataReceivedEventArgs(TcpConnection connection, byte[] data)
		{
			Connection = connection;
			Data = data;
		}
	}
}

