/*
 * Copyright (C) 2001-2006 Jacek Sieka, arnetheduck on gmail point com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#if !defined(ABOUT_DLG_H)
#define ABOUT_DLG_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "../client/HttpConnection.h"
#include "../client/SimpleXML.h"
#include <atlctrlx.h>

static const TCHAR thanks[] = 
_T("Thanks so much to all devoted members from zK++ Official Forum and each loyal user from my hub - it is being a good and very nice experience to work with you all. Second, but never less important, my eternal thanks to Pothead and all users from Imperialnet.org Forum - my second school - for the tireless patience with me during the hard days working on C++ and doing stupid questions about it. Finally, thanks a lot to all people that supported and hosted this DC client. Due to DC Spirit, of course it always will be an open source software licenced under GPL. zK++ is a software made for enjoyment purposes only, totally dedicated to all DC lovers of the world. Thank you all very much!");

class AboutDlg : public CDialogImpl<AboutDlg>, private HttpConnectionListener, private TimerManagerListener
{
public:
	enum { IDD = IDD_ABOUTBOX };
	enum { WM_VERSIONDATA = WM_APP + 53 };

	AboutDlg() { }
	~AboutDlg() { }

	BEGIN_MSG_MAP(AboutDlg)
		MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
		MESSAGE_HANDLER(WM_VERSIONDATA, onVersionData)
		COMMAND_ID_HANDLER(IDOK, OnCloseCmd)
		COMMAND_ID_HANDLER(IDCANCEL, OnCloseCmd)
		COMMAND_ID_HANDLER(IDC_LINK, onLink)
	END_MSG_MAP()

	LRESULT OnInitDialog(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/) {
		SetDlgItemText(IDC_VERSION, _T("zK++ ") _T(VERSIONSTRING) _T(" \n(c) Copyright - Lord.Sabbath\nPublic Release - March 20, 2008\nzK++ is licenced under GNU GPL\nOfficial Support Hub:\nhubnroll.sytes.net:7007\n"));
		CEdit ctrlThanks(GetDlgItem(IDC_THANKS));
		ctrlThanks.FmtLines(TRUE);
		ctrlThanks.AppendText(thanks, TRUE);
		ctrlThanks.Detach();
		SetDlgItemText(IDC_TTH, WinUtil::tth.c_str());
		SetDlgItemText(IDC_LATEST, CTSTRING(DOWNLOADING));
		SetDlgItemText(IDC_TOTALS, (_T("Upload:   ") + Util::formatBytesW(SETTING(TOTAL_UPLOAD)) + _T("   -   Download:  ") + 
			Util::formatBytesW(SETTING(TOTAL_DOWNLOAD))).c_str());
		SetDlgItemText(IDC_LINK, Text::toT(HOMEPAGE).c_str());
		SetDlgItemText(IDC_COMPT, Text::toT("Compiled: " + WinUtil::getCompileDate()).c_str());
		
		url.SubclassWindow(GetDlgItem(IDC_LINK));
		url.SetHyperLinkExtendedStyle(HLINK_COMMANDBUTTON|HLINK_UNDERLINEHOVER);
		url.m_tip.AddTool(url, Text::toT(HOMEPAGE).c_str(), &url.m_rcLink, 1);

		TCHAR buf[128];
		if(SETTING(TOTAL_DOWNLOAD) > 0) {
			snwprintf(buf, sizeof(buf), _T("Ratio (up/down): %.2f"), ((double)SETTING(TOTAL_UPLOAD)) / ((double)SETTING(TOTAL_DOWNLOAD)));
			SetDlgItemText(IDC_RATIO, buf);
		}
		snwprintf(buf, sizeof(buf), _T("%s"), Text::toT(WinUtil::formatTime(Util::getUptime())).c_str());
		SetDlgItemText(IDC_UPTIME, buf);
		TimerManager::getInstance()->addListener(this);
		CenterWindow(GetParent());
		c.addListener(this);
		c.downloadFile(VERSIONFILE);
		return TRUE;
	}

	LRESULT onVersionData(UINT /*uMsg*/, WPARAM wParam, LPARAM /*lParam*/, BOOL& /*bHandled*/) {
		tstring* x = (tstring*) wParam;
		SetDlgItemText(IDC_LATEST, x->c_str());
		delete x;
		return 0;
	}

	LRESULT onLink (WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
		WinUtil::openLink(Text::toT(HOMEPAGE).c_str());
		return 0;
	}
		
	LRESULT OnCloseCmd(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
		TimerManager::getInstance()->removeListener(this);
		EndDialog(wID);
		return 0;
	}

private:
	HttpConnection c;
	CHyperLink url;

	AboutDlg(const AboutDlg&) { dcassert(0); }
	
	void on(HttpConnectionListener::Data, HttpConnection* /*conn*/, const uint8_t* buf, size_t len) throw() {
		downBuf.append((char*)buf, len);
	}

	void on(HttpConnectionListener::Complete, HttpConnection* conn, const string&) throw() {
		if(!downBuf.empty()) {
			SimpleXML xml;
			xml.fromXML(downBuf);
			if(xml.findChild("DCUpdate")) {
				xml.stepIn();
				if(xml.findChild("Version")) {
					tstring* x = new tstring(Text::toT(xml.getChildData()));
					PostMessage(WM_VERSIONDATA, (WPARAM) x);
				}
			}
		}
		conn->removeListener(this);
	}

	void on(HttpConnectionListener::Failed, HttpConnection* conn, const string& aLine) throw() {
		tstring* x = new tstring(Text::toT(aLine));
		PostMessage(WM_VERSIONDATA, (WPARAM) x);
		conn->removeListener(this);
	}

	void on(TimerManagerListener::Second /*type*/, uint64_t /*aTick*/) throw() {
		TCHAR buf[128];
		snwprintf(buf, sizeof(buf), _T("%s"), Text::toT(WinUtil::formatTime(Util::getUptime())).c_str());
		SetDlgItemText(IDC_UPTIME, buf);
	}

	string downBuf;
};

#endif // !defined(ABOUT_DLG_H)

/**
 * @file
 * $Id: AboutDlg.h 317 2007-08-04 14:52:24Z bigmuscle $
 */
