/* 
 * Copyright (C) 2001-2005 Jacek Sieka, arnetheduck on gmail point com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "stdafx.h"
#include "../client/DCPlusPlus.h"
#include "Resource.h"

#include "BadExePage.h"

#include "../client/SettingsManager.h"
#include "../client/FavoriteManager.h"

PropPage::TextItem BadExePage::texts[] = {
	{ IDC_BADEXE_CHECK, ResourceManager::BADEXE_CHECK },
	{ IDC_ADD_MENU, ResourceManager::ADD },
	{ IDC_CHANGE_MENU, ResourceManager::SETTINGS_CHANGE },
	{ IDC_MOVE_UP, ResourceManager::MOVE_UP },
	{ IDC_MOVE_DOWN, ResourceManager::MOVE_DOWN },	
	{ IDC_REMOVE_MENU, ResourceManager::REMOVE },
	{ IDC_GROUP_UPDATE, ResourceManager::BADEXE_UPDATE },
	{ IDC_RELOAD_BADEXES, ResourceManager::RELOAD },
	{ IDC_UPDATE_BADEXE, ResourceManager::SETTINGS_UPDATE },
	{ 0, ResourceManager::SETTINGS_AUTO_AWAY }
};

PropPage::Item BadExePage::items[] = {
	{ IDC_BADEXE_CHECK, SettingsManager::BADEXE_CHECK, PropPage::T_BOOL },
	{ 0, 0, PropPage::T_END }
};

LRESULT BadExePage::onInitDialog(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
{
	PropPage::translate((HWND)(*this), texts);
	PropPage::read((HWND)*this, items);

	CRect rc;

	ctrlExes.Attach(GetDlgItem(IDC_BADEXE_ITEMS));
	ctrlExes.GetClientRect(rc);

	ctrlExes.InsertColumn(0, CTSTRING(HUB_NAME), LVCFMT_LEFT, rc.Width()/4, 0);
	ctrlExes.InsertColumn(1, CTSTRING(HUB_ADDRESS), LVCFMT_LEFT, rc.Width()/4, 1);
	ctrlExes.InsertColumn(2, CTSTRING(DESCRIPTION), LVCFMT_LEFT, (rc.Width()*2 / 4) - 17, 2);

	if(BOOLSETTING(FULL_ROW_SELECT))
		ctrlExes.SetExtendedListViewStyle(LVS_EX_FULLROWSELECT);

	SetDlgItemText(IDC_UPDATE_URL_BADEXE, Text::toT(SETTING(UPDATE_URL_BADEXE)).c_str());

	c.addListener(this);

	// Do specialized reading here
	BadExe::List lst = FavoriteManager::getInstance()->getBadExes();
	for(BadExe::Iter i = lst.begin(); i != lst.end(); ++i) {
		BadExe& be = *i;	
		addEntry(be, ctrlExes.GetItemCount());
	}

	ctrlExes.setSort(1, ExListViewCtrl::SORT_STRING_NOCASE);
	fixControls();

	return TRUE;
}

void BadExePage::fixControls() {
	BOOL checked = IsDlgButtonChecked(IDC_BADEXE_CHECK);
	::EnableWindow(GetDlgItem(IDC_RELOAD_BADEXES), checked);
	::EnableWindow(GetDlgItem(IDC_UPDATE_BADEXE), checked);
	::EnableWindow(GetDlgItem(IDC_UPDATE_URL_BADEXE), checked);
	::EnableWindow(GetDlgItem(IDC_BADEXE_ITEMS), checked);
	::EnableWindow(GetDlgItem(IDC_ADD_MENU), checked);
	::EnableWindow(GetDlgItem(IDC_CHANGE_MENU), checked);
	::EnableWindow(GetDlgItem(IDC_MOVE_UP), checked);
	::EnableWindow(GetDlgItem(IDC_MOVE_DOWN), checked);
	::EnableWindow(GetDlgItem(IDC_REMOVE_MENU), checked);
}

LRESULT BadExePage::onClickedCheck(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	fixControls();
	return 0;
}

LRESULT BadExePage::onAddMenu(WORD , WORD , HWND , BOOL& ) {
	BadExeDlg dlg;

	if(dlg.DoModal() == IDOK) {
		addEntry(FavoriteManager::getInstance()->addBadExe(dlg.name, dlg.exe, 
			dlg.description), ctrlExes.GetItemCount());
	}
	return 0;
}

LRESULT BadExePage::onImportMenu(WORD , WORD , HWND , BOOL& ) {
	FavoriteManager::getInstance()->importBadExes();
	return 0;
}

LRESULT BadExePage::onChangeMenu(WORD , WORD , HWND , BOOL& ) {
	if(ctrlExes.GetSelectedCount() == 1) {
		int sel = ctrlExes.GetSelectedIndex();
		BadExe be;
		FavoriteManager::getInstance()->getBadExe(ctrlExes.GetItemData(sel), be);
		
		BadExeDlg dlg;
		dlg.name = be.getName();
		dlg.exe = be.getExe();		
		dlg.description = be.getDescription();

		if(dlg.DoModal() == IDOK) {
			ctrlExes.SetItemText(sel, 0, Text::toT(dlg.name).c_str());
			ctrlExes.SetItemText(sel, 1, Text::toT(dlg.exe).c_str());			
			ctrlExes.SetItemText(sel, 2, Text::toT(dlg.description).c_str());
			be.setName(dlg.name);
			be.setExe(dlg.exe);
			be.setDescription(dlg.description);
			FavoriteManager::getInstance()->updateBadExe(be);
		}
	}
	return 0;
}

LRESULT BadExePage::onRemoveMenu(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	if(ctrlExes.GetSelectedCount() == 1) {
		int i = ctrlExes.GetNextItem(-1, LVNI_SELECTED);
		FavoriteManager::getInstance()->removeBadExe(ctrlExes.GetItemData(i));
		ctrlExes.DeleteItem(i);
	}
	return 0;
}

LRESULT BadExePage::onMoveUp(WORD , WORD , HWND , BOOL& ) {
	int i = ctrlExes.GetSelectedIndex();
	if(i != -1 && i != 0) {
		int n = ctrlExes.GetItemData(i);
		FavoriteManager::getInstance()->moveBadExe(n, -1/*[iDC++], i*/);
		ctrlExes.SetRedraw(FALSE);
		ctrlExes.DeleteItem(i);
		BadExe be;
		FavoriteManager::getInstance()->getBadExe(n, be);
		addEntry(be, i-1);
		ctrlExes.SelectItem(i-1);
		ctrlExes.EnsureVisible(i-1, FALSE);
		ctrlExes.SetRedraw(TRUE);
	}
	return 0;
}

LRESULT BadExePage::onMoveDown(WORD , WORD , HWND , BOOL& ) {
	int i = ctrlExes.GetSelectedIndex();
	if(i != -1 && i != (ctrlExes.GetItemCount()-1) ) {
		int n = ctrlExes.GetItemData(i);
		FavoriteManager::getInstance()->moveBadExe(n, 1/*[iDC++], i*/);
		ctrlExes.SetRedraw(FALSE);
		ctrlExes.DeleteItem(i);
		BadExe be;
		FavoriteManager::getInstance()->getBadExe(n, be);
		addEntry(be, i+1);
		ctrlExes.SelectItem(i+1);
		ctrlExes.EnsureVisible(i+1, FALSE);
		ctrlExes.SetRedraw(TRUE);
	}
	return 0;
}

LRESULT BadExePage::onUpdate(WORD , WORD , HWND , BOOL& ) {
	c.downloadFile(SETTING(UPDATE_URL_BADEXE) + "BadExes.xml");
	return 0;
}

LRESULT BadExePage::onReload(WORD , WORD , HWND , BOOL& ) {
	reload();
	return 0;
}

void BadExePage::reload() {
	ctrlExes.SetRedraw(FALSE);
	int s = FavoriteManager::getInstance()->getBadExesListSize();
	for(int i = 0; i < s; i++) {
		ctrlExes.DeleteItem(0);
	}
	BadExe::List lst = FavoriteManager::getInstance()->reloadBadExes();
	for(BadExe::Iter j = lst.begin(); j != lst.end(); ++j) {
		BadExe& be = *j;	
		addEntry(be, ctrlExes.GetItemCount());
	}
	ctrlExes.SetRedraw(TRUE);
}

void BadExePage::addEntry(const BadExe& be, int pos) {
	TStringList lst;

	lst.push_back(Text::toT(be.getName()));
	lst.push_back(Text::toT(be.getExe()));
	lst.push_back(Text::toT(be.getDescription()));
	ctrlExes.insert(pos, lst, 0, (LPARAM)be.getId());
}

void BadExePage::write() {
	TCHAR buf[512];
	GetDlgItemText(IDC_UPDATE_URL_BADEXE, buf, 512);
	SettingsManager::getInstance()->set(SettingsManager::UPDATE_URL_BADEXE, Text::fromT(buf));
	FavoriteManager::getInstance()->save();
	PropPage::write((HWND)*this, items);
}

LRESULT BadExeDlg::OnInitDialog(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/) {
#define ATTACH(id, var) var.Attach(GetDlgItem(id))
	ATTACH(IDC_BE_NAME, ctrlName);
	ATTACH(IDC_BE_EXE, ctrlExe);
	ATTACH(IDC_BE_DESC, ctrlDescription);

	ctrlName.SetWindowText(Text::toT(name).c_str());
	ctrlExe.SetWindowText(Text::toT(exe).c_str());
	ctrlDescription.SetWindowText(Text::toT(description).c_str());

	SetDlgItemText(IDC_BE_NAME_LBL, CTSTRING(HUB_NAME));
	SetDlgItemText(IDC_BE_DESC_LBL, CTSTRING(DESCRIPTION));
	SetDlgItemText(IDCANCEL, CTSTRING(CANCEL));

	//SetWindowText(CSTRING(BAD_EXE_TITLE));

	CenterWindow(GetParent());
	return FALSE;
}

/**
 * @file
 * $Id: BadExePage.cpp,v 1.0 iDC++ code modified by Legolas $
 */