//////////////////////////////////////////////////////////////////////////////////////
//
// Written by Zoltan Csizmadia, zoltan_csizmadia@yahoo.com
// For companies(Austin,TX): If you would like to get my resume, send an email.
//
// The source is free, but if you want to use it, mention my name and e-mail address
//
// History:
//    1.0      Initial version                  Zoltan Csizmadia
//
//////////////////////////////////////////////////////////////////////////////////////
//
// ExtendedTrace.cpp
//

// Include StdAfx.h, if you're using precompiled 
// header through StdAfx.h
#include "stdafx.h"

#if defined(_WIN32)

#include "../client/DCPlusPlus.h"
#include "../client/File.h"
#include "WinUtil.h"

#include <tchar.h>
#include <DbgHelp.h>
#include "ExtendedTrace.h"

#define BUFFERSIZE   0x200

static void checkBuggyLibrary(PCSTR library) {
	vector<pair<tstring, tstring>> libraries;
	libraries.push_back(make_pair(L"Vlsp", L"V-One Smartpass"));
	libraries.push_back(make_pair(L"mclsp", L"McAfee AV"));
	libraries.push_back(make_pair(L"Niphk", L"Norman AV"));
	libraries.push_back(make_pair(L"aslsp", L"Aventail Corporation VPN"));
	libraries.push_back(make_pair(L"AXShlEx", L"Alcohol 120%"));
	libraries.push_back(make_pair(L"gdlsphlr", L"McAfee"));
	libraries.push_back(make_pair(L"mlang", L"IE"));
	libraries.push_back(make_pair(L"cslsp", L"McAfee"));
	libraries.push_back(make_pair(L"winsflt", L"PureSight Internet Content Filter"));
	libraries.push_back(make_pair(L"imslsp", L"ZoneLabs IM Secure"));
	libraries.push_back(make_pair(L"apitrap", L"Norton Cleansweep [?]"));
	libraries.push_back(make_pair(L"sockspy", L"BitDefender Antivirus"));
	libraries.push_back(make_pair(L"imon", L"Eset NOD32"));
	libraries.push_back(make_pair(L"KvWspXp(_1)", L"Kingsoft Antivirus"));
	libraries.push_back(make_pair(L"nl_lsp", L"NetLimiter"));
	libraries.push_back(make_pair(L"OSMIM", L"Marketscore Internet Accelerator"));
	libraries.push_back(make_pair(L"opls", L"Opinion Square [malware]"));
	libraries.push_back(make_pair(L"PavTrc", L"Panda Anti-Virus"));
	libraries.push_back(make_pair(L"pavlsp", L"Panda Anti-Virus"));
	libraries.push_back(make_pair(L"AppToPort", L"Wyvern Works  Firewall"));
	libraries.push_back(make_pair(L"SpyDll", L"Nice Spy [malware]"));
	libraries.push_back(make_pair(L"WBlind", L"Window Blinds"));
	libraries.push_back(make_pair(L"UPS10", L"Uniscribe Unicode Script Processor Library"));
	libraries.push_back(make_pair(L"SOCKS32", L"Sockscap [?]"));
	libraries.push_back(make_pair(L"___j", L"Worm: W32.Maslan.C@mm"));
	libraries.push_back(make_pair(L"nvappfilter", L"NVidia nForce Network Access Manager"));
	libraries.push_back(make_pair(L"mshp32", L"Worm: W32.Worm.Feebs"));
	libraries.push_back(make_pair(L"ProxyFilter", L"Hide My IP 2007"));
	libraries.push_back(make_pair(L"msui32", L"Malware MSUI32"));

	for(vector<pair<tstring, tstring>>::const_iterator i = libraries.begin(); i != libraries.end(); i++) {
		string lib = Text::fromT(i->first); tstring app = i->second;
		if(Util::stricmp(library, lib) == 0) {
			size_t BUF_SIZE = TSTRING(LIB_CRASH).size() + app.size() + 16;
			AutoArray<TCHAR> buf(BUF_SIZE);
			snwprintf(buf, BUF_SIZE - 1, CTSTRING(LIB_CRASH), app.c_str());
		
			MessageBox(0, buf, _T("Unhandled exception"), MB_OK);
			exit(1);
		}
	}
}

// Unicode safe char* -> TCHAR* conversion
void PCSTR2LPTSTR( PCSTR lpszIn, LPTSTR lpszOut )
{
#if defined(UNICODE)||defined(_UNICODE)
   ULONG index = 0; 
   PCSTR lpAct = lpszIn;
   
	for( ; ; lpAct++ )
	{
		lpszOut[index++] = (TCHAR)(*lpAct);
		if ( *lpAct == 0 )
			break;
	} 
#else
   // This is trivial :)
	strcpy( lpszOut, lpszIn );
#endif
}

// Let's figure out the path for the symbol files
// Search path= ".;%_NT_SYMBOL_PATH%;%_NT_ALTERNATE_SYMBOL_PATH%;%SYSTEMROOT%;%SYSTEMROOT%\System32;" + lpszIniPath
// Note: There is no size check for lpszSymbolPath!
static void InitSymbolPath( PSTR lpszSymbolPath, PCSTR lpszIniPath )
{
	CHAR lpszPath[BUFFERSIZE];

   // Creating the default path
   // ".;%_NT_SYMBOL_PATH%;%_NT_ALTERNATE_SYMBOL_PATH%;%SYSTEMROOT%;%SYSTEMROOT%\System32;"
	strcpy( lpszSymbolPath, "." );

	// environment variable _NT_SYMBOL_PATH
	if ( GetEnvironmentVariableA( "_NT_SYMBOL_PATH", lpszPath, BUFFERSIZE ) )
	{
	   strcat( lpszSymbolPath, ";" );
		strcat( lpszSymbolPath, lpszPath );
	}

	// environment variable _NT_ALTERNATE_SYMBOL_PATH
	if ( GetEnvironmentVariableA( "_NT_ALTERNATE_SYMBOL_PATH", lpszPath, BUFFERSIZE ) )
	{
	   strcat( lpszSymbolPath, ";" );
		strcat( lpszSymbolPath, lpszPath );
	}

	// environment variable SYSTEMROOT
	if ( GetEnvironmentVariableA( "SYSTEMROOT", lpszPath, BUFFERSIZE ) )
	{
	   strcat( lpszSymbolPath, ";" );
		strcat( lpszSymbolPath, lpszPath );
		strcat( lpszSymbolPath, ";" );

		// SYSTEMROOT\System32
		strcat( lpszSymbolPath, lpszPath );
		strcat( lpszSymbolPath, "\\System32" );
	}

   // Add user defined path
	if ( lpszIniPath != NULL )
		if ( lpszIniPath[0] != '\0' )
		{
		   strcat( lpszSymbolPath, ";" );
			strcat( lpszSymbolPath, lpszIniPath );
		}
}

// Uninitialize the loaded symbol files
BOOL UninitSymInfo() {
	return SymCleanup( GetCurrentProcess() );
}

// Initializes the symbol files
BOOL InitSymInfo( PCSTR lpszInitialSymbolPath )
{

	SymSetOptions(SYMOPT_DEFERRED_LOADS | SYMOPT_FAIL_CRITICAL_ERRORS | SYMOPT_LOAD_LINES );
	CHAR     lpszSymbolPath[BUFFERSIZE];
	InitSymbolPath( lpszSymbolPath, lpszInitialSymbolPath );

	return SymInitialize( GetCurrentProcess(), lpszSymbolPath, TRUE);
}

// Get the module name from a given address
static BOOL GetModuleNameFromAddress( UINT address, LPTSTR lpszModule )
{
	BOOL              ret = FALSE;
	IMAGEHLP_MODULE   moduleInfo;

	::ZeroMemory( &moduleInfo, sizeof(moduleInfo) );
	moduleInfo.SizeOfStruct = sizeof(moduleInfo);

	if ( SymGetModuleInfo( GetCurrentProcess(), (DWORD)address, &moduleInfo ) )
	{
	   // Got it!
		PCSTR2LPTSTR( moduleInfo.ModuleName, lpszModule );

		checkBuggyLibrary(moduleInfo.ModuleName);

		ret = TRUE;
	}
	else
	   // Not found :(
		_tcscpy( lpszModule, _T("?") );
	
	return ret;
}

// Get function prototype and parameter info from ip address and stack address
static BOOL GetFunctionInfoFromAddresses( ULONG fnAddress, ULONG stackAddress, LPTSTR lpszSymbol )
{
	BOOL              ret = FALSE;
	DWORD64             dwDisp = 0;
	DWORD             dwSymSize = 1024*16;
   TCHAR             lpszUnDSymbol[BUFFERSIZE]=_T("?");
	CHAR              lpszNonUnicodeUnDSymbol[BUFFERSIZE]="?";
	LPTSTR            lpszParamSep = NULL;
	LPCTSTR           lpszParsed = lpszUnDSymbol;
	PSYMBOL_INFO  pSym = (PSYMBOL_INFO)GlobalAlloc( GMEM_FIXED, dwSymSize );

	::ZeroMemory( pSym, dwSymSize );
	pSym->SizeOfStruct = dwSymSize;
	pSym->MaxNameLen = dwSymSize - sizeof(IMAGEHLP_SYMBOL);

   // Set the default to unknown
	_tcscpy( lpszSymbol, _T("?") );

	// Get symbol info for IP
	if ( SymFromAddr( GetCurrentProcess(), (ULONG)fnAddress, &dwDisp, pSym ) )
	{
	   // Make the symbol readable for humans
		UnDecorateSymbolName( pSym->Name, lpszNonUnicodeUnDSymbol, BUFFERSIZE, 
			UNDNAME_COMPLETE | 
			UNDNAME_NO_THISTYPE |
			UNDNAME_NO_SPECIAL_SYMS |
			UNDNAME_NO_MEMBER_TYPE |
			UNDNAME_NO_MS_KEYWORDS |
			UNDNAME_NO_ACCESS_SPECIFIERS );
		// Symbol information is ANSI string
		PCSTR2LPTSTR( lpszNonUnicodeUnDSymbol, lpszUnDSymbol );

      // I am just smarter than the symbol file :)
		if ( _tcscmp(lpszUnDSymbol, _T("_WinMain@16")) == 0 )
			_tcscpy(lpszUnDSymbol, _T("WinMain(HINSTANCE,HINSTANCE,LPCTSTR,int)"));
		else
		if ( _tcscmp(lpszUnDSymbol, _T("_main")) == 0 )
			_tcscpy(lpszUnDSymbol, _T("main(int,TCHAR * *)"));
		else
		if ( _tcscmp(lpszUnDSymbol, _T("_mainCRTStartup")) == 0 )
			_tcscpy(lpszUnDSymbol, _T("mainCRTStartup()"));
		else
		if ( _tcscmp(lpszUnDSymbol, _T("_wmain")) == 0 )
			_tcscpy(lpszUnDSymbol, _T("wmain(int,TCHAR * *,TCHAR * *)"));
		else
		if ( _tcscmp(lpszUnDSymbol, _T("_wmainCRTStartup")) == 0 )
			_tcscpy(lpszUnDSymbol, _T("wmainCRTStartup()"));

		lpszSymbol[0] = _T('\0');

      // Let's go through the stack, and modify the function prototype, and insert the actual
      // parameter values from the stack
		if ( _tcsstr( lpszUnDSymbol, _T("(void)") ) == NULL && _tcsstr( lpszUnDSymbol, _T("()") ) == NULL)
		{
			ULONG index = 0;
			for( ; ; index++ )
			{
				lpszParamSep = _tcschr( const_cast<wchar_t*>(lpszParsed), _T(',') );
				if ( lpszParamSep == NULL )
					break;

				*lpszParamSep = _T('\0');

				_tcscat( lpszSymbol, lpszParsed );
				_stprintf( lpszSymbol + _tcslen(lpszSymbol), _T("=0x%08lX,"), *((ULONG*)(stackAddress) + 2 + index) );

				lpszParsed = lpszParamSep + 1;
			}

			lpszParamSep = _tcschr( const_cast<wchar_t*>(lpszParsed), _T(')') );
			if ( lpszParamSep != NULL )
			{
				*lpszParamSep = _T('\0');

				_tcscat( lpszSymbol, lpszParsed );
				_stprintf( lpszSymbol + _tcslen(lpszSymbol), _T("=0x%08lX)"), *((ULONG*)(stackAddress) + 2 + index) );

				lpszParsed = lpszParamSep + 1;
			}
		}

		_tcscat( lpszSymbol, lpszParsed );
   
		ret = TRUE;
	} 
	GlobalFree( pSym );

	return ret;
}

// Get source file name and line number from IP address
// The output format is: "sourcefile(linenumber)" or
//                       "modulename!address" or
//                       "address"
static BOOL GetSourceInfoFromAddress( UINT address, LPTSTR lpszSourceInfo )
{
	BOOL           ret = FALSE;
	IMAGEHLP_LINE  lineInfo;
	DWORD          dwDisp;
	TCHAR          lpszFileName[BUFFERSIZE] = _T("");
	TCHAR          lpModuleInfo[BUFFERSIZE] = _T("");

	_tcscpy( lpszSourceInfo, _T("?(?)") );

	::ZeroMemory( &lineInfo, sizeof( lineInfo ) );
	lineInfo.SizeOfStruct = sizeof( lineInfo );

	if ( SymGetLineFromAddr( GetCurrentProcess(), address, &dwDisp, &lineInfo ) )
	{
	   // Got it. Let's use "sourcefile(linenumber)" format
		PCSTR2LPTSTR( lineInfo.FileName, lpszFileName );
		_stprintf( lpszSourceInfo, _T("%s(%d)"), lpszFileName, lineInfo.LineNumber );
		ret = TRUE;
	}
	else
	{
      // There is no source file information. :(
      // Let's use the "modulename!address" format
	  	GetModuleNameFromAddress( address, lpModuleInfo );

		if ( lpModuleInfo[0] == _T('?') || lpModuleInfo[0] == _T('\0'))
		   // There is no modulename information. :((
         // Let's use the "address" format
			_stprintf( lpszSourceInfo, _T("0x%08X"), address );
		else
			_stprintf( lpszSourceInfo, _T("%s!0x%08X"), lpModuleInfo, address );

		ret = FALSE;
	}
	
	return ret;
}

void StackTrace( HANDLE hThread, LPCTSTR lpszMessage, File& f, DWORD eip, DWORD esp, DWORD ebp )
{
	STACKFRAME     callStack;
	BOOL           bResult;
	TCHAR          symInfo[BUFFERSIZE] = _T("?");
	TCHAR          srcInfo[BUFFERSIZE] = _T("?");
	HANDLE         hProcess = GetCurrentProcess();

	// If it's not this thread, let's suspend it, and resume it at the end
	if ( hThread != GetCurrentThread() )
		if ( SuspendThread( hThread ) == -1 )
		{
			// whaaat ?!
			f.write(LIT("No call stack\r\n"));
			return;
		}

		::ZeroMemory( &callStack, sizeof(callStack) );
		callStack.AddrPC.Offset    = eip;
		callStack.AddrStack.Offset = esp;
		callStack.AddrFrame.Offset = ebp;
		callStack.AddrPC.Mode      = AddrModeFlat;
		callStack.AddrStack.Mode   = AddrModeFlat;
		callStack.AddrFrame.Mode   = AddrModeFlat;

		f.write(Text::fromT(lpszMessage));

		GetFunctionInfoFromAddresses( callStack.AddrPC.Offset, callStack.AddrFrame.Offset, symInfo );
		GetSourceInfoFromAddress( callStack.AddrPC.Offset, srcInfo );

		f.write(Text::fromT(srcInfo));
		f.write(LIT(": "));
		f.write(Text::fromT(symInfo));
		f.write(LIT("\r\n"));

		// Max 100 stack lines...
		for( ULONG index = 0; index < 100; index++ ) 
		{
			bResult = StackWalk(
				IMAGE_FILE_MACHINE_I386,
				hProcess,
				hThread,
				&callStack,
				NULL, 
				NULL,
				SymFunctionTableAccess,
				SymGetModuleBase,
				NULL);

			if ( index == 0 )
				continue;

			if( !bResult || callStack.AddrFrame.Offset == 0 ) 
				break;

			GetFunctionInfoFromAddresses( callStack.AddrPC.Offset, callStack.AddrFrame.Offset, symInfo );
			GetSourceInfoFromAddress( callStack.AddrPC.Offset, srcInfo );

			f.write(Text::fromT(srcInfo));
			f.write(LIT(": "));
			f.write(Text::fromT(symInfo));
			f.write(LIT("\r\n"));

		}
		if ( hThread != GetCurrentThread() )
			ResumeThread( hThread );
}

string StackTrace( HANDLE hThread, LPCTSTR lpszMessage, DWORD eip, DWORD esp, DWORD ebp )
{
	STACKFRAME     callStack;
	BOOL           bResult;
	TCHAR          symInfo[BUFFERSIZE] = _T("?");
	TCHAR          srcInfo[BUFFERSIZE] = _T("?");
	HANDLE         hProcess = GetCurrentProcess();

	tstring	vypis;

	// If it's not this thread, let's suspend it, and resume it at the end
	if ( hThread != GetCurrentThread() )
		if ( SuspendThread( hThread ) == -1 )
		{
			// whaaat ?!
			vypis = LIT(_T("No call stack\r\n"));
			return Text::fromT(vypis);
		}

		::ZeroMemory( &callStack, sizeof(callStack) );
		callStack.AddrPC.Offset    = eip;
		callStack.AddrStack.Offset = esp;
		callStack.AddrFrame.Offset = ebp;
		callStack.AddrPC.Mode      = AddrModeFlat;
		callStack.AddrStack.Mode   = AddrModeFlat;
		callStack.AddrFrame.Mode   = AddrModeFlat;

		vypis = lpszMessage;

		GetFunctionInfoFromAddresses( callStack.AddrPC.Offset, callStack.AddrFrame.Offset, symInfo );
		GetSourceInfoFromAddress( callStack.AddrPC.Offset, srcInfo );

		vypis += srcInfo;
		vypis += LIT(_T(": "));
		vypis += symInfo;
		vypis += LIT(_T("\r\n"));

		// Max 100 stack lines...
		for( ULONG index = 0; index < 100; index++ ) 
		{
			bResult = StackWalk(
				IMAGE_FILE_MACHINE_I386,
				hProcess,
				hThread,
				&callStack,
				NULL, 
				NULL,
				SymFunctionTableAccess,
				SymGetModuleBase,
				NULL);

			if ( index == 0 )
				continue;

			if( !bResult || callStack.AddrFrame.Offset == 0 ) 
				break;

			GetFunctionInfoFromAddresses( callStack.AddrPC.Offset, callStack.AddrFrame.Offset, symInfo );
			GetSourceInfoFromAddress( callStack.AddrPC.Offset, srcInfo );

			vypis += srcInfo;
			vypis += LIT(_T(": "));
			vypis += symInfo;
			vypis += LIT(_T("\r\n"));

		}
		if ( hThread != GetCurrentThread() )
			ResumeThread( hThread );
		return Text::fromT(vypis);
}

#endif //_DEBUG && _WIN32

/**
* @file
* $Id: ExtendedTrace.cpp 309 2007-07-22 13:21:55Z bigmuscle $
*/
