/*
 * Decompiled with CFR 0.152.
 */
package mirrg.applet.mathematics.zinc.gadgets;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import mirrg.applet.mathematics.zinc.core.IColorProvider;
import mirrg.applet.mathematics.zinc.core.IZincCanvas;
import mirrg.applet.mathematics.zinc.gadgets.ZincGadgetPainterBase;
import mirrg.applet.nitrogen.NitrogenEventApplet;
import mirrg.util.hydrogen.HAwt;

public class ZincGadgetPainterFast
extends ZincGadgetPainterBase {
    private int width;
    private int height;
    private int[] data;
    private BufferedImage image;
    private Graphics2D graphics;

    public ZincGadgetPainterFast(IZincCanvas zincCanvas) {
        super(zincCanvas);
        zincCanvas.getEventManager().register(NitrogenEventApplet.Rebuffer.class, event -> {
            this.width = event.width;
            this.height = event.height;
            if (this.width < 1) {
                this.width = 1;
            }
            if (this.height < 1) {
                this.height = 1;
            }
            this.data = new int[this.width * this.height];
            this.image = HAwt.createBufferedImageFromIntArray(this.data, this.width, this.height);
            this.graphics = this.image.createGraphics();
        });
    }

    @Override
    protected void paintLine(IColorProvider colorProvider) {
        if (this.y < this.height) {
            for (int x = 0; x < this.width; ++x) {
                this.data[x + this.width * this.y] = colorProvider.getColorFromComplex(this.zincCanvas.getTransform().getCoordX(x), this.zincCanvas.getTransform().getCoordY(this.y));
            }
        }
    }

    @Override
    public BufferedImage getBuffer() {
        return this.image;
    }

    @Override
    public Graphics2D getGraphics() {
        return this.graphics;
    }
}

