/*
 * Decompiled with CFR 0.152.
 */
package mirrg.applet.nitrogen.modules.input;

import mirrg.applet.nitrogen.AppletNitrogen;
import mirrg.applet.nitrogen.Module;
import mirrg.applet.nitrogen.modules.input.ModuleInputEvent;
import mirrg.applet.nitrogen.modules.input.NitrogenEventKey;
import mirrg.applet.nitrogen.modules.input.NitrogenEventMouse;
import mirrg.applet.nitrogen.modules.input.NitrogenEventMouseMotion;
import mirrg.applet.nitrogen.modules.input.NitrogenEventMouseWheel;

public class ModuleInputStatus
extends Module {
    private static final int MOUSE_BUTTONS_COUNT = 8;
    private static final int KEYS_COUNT = 1024;
    private int mouseX;
    private int mouseXPrevious;
    private int mouseY;
    private int mouseYPrevious;
    private int mouseW;
    private int mouseWPrevious;
    private Button mouseButtons = new Button(8);
    private Button keyBoard = new Button(1024);

    public ModuleInputStatus(AppletNitrogen applet, ModuleInputEvent moduleInputEvent) {
        super(applet);
        applet.getEventManager().register(NitrogenEventMouse.Pressed.class, event -> this.mousePressed(event.mouseEvent.getX(), event.mouseEvent.getY(), event.mouseEvent.getButton()));
        applet.getEventManager().register(NitrogenEventMouse.Released.class, event -> this.mouseReleased(event.mouseEvent.getX(), event.mouseEvent.getY(), event.mouseEvent.getButton()));
        applet.getEventManager().register(NitrogenEventMouseMotion.class, event -> this.mouseMotion(event.mouseEvent.getX(), event.mouseEvent.getY()));
        applet.getEventManager().register(NitrogenEventMouseWheel.Moved.class, event -> this.mouseWheelMoved(event.mouseWheelEvent.getWheelRotation()));
        applet.getEventManager().register(NitrogenEventKey.Pressed.class, event -> this.keyPressed(event.keyEvent.getKeyCode()));
        applet.getEventManager().register(NitrogenEventKey.Released.class, event -> this.keyReleased(event.keyEvent.getKeyCode()));
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseXPrevious() {
        return this.mouseXPrevious;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public int getMouseYPrevious() {
        return this.mouseYPrevious;
    }

    public int getMouseW() {
        return this.mouseW;
    }

    public int getMouseWPrevious() {
        return this.mouseWPrevious;
    }

    public Button getMouseButtons() {
        return this.mouseButtons;
    }

    public Button getKeyBoard() {
        return this.keyBoard;
    }

    public void spend() {
        this.mouseXPrevious = this.mouseX;
        this.mouseYPrevious = this.mouseY;
        this.mouseWPrevious = this.mouseW;
        this.mouseButtons.spend();
        this.keyBoard.spend();
    }

    public void mousePressed(int x, int y, int button) {
        this.mouseX = x;
        this.mouseY = y;
        this.mouseButtons.pressed(button);
    }

    public void mouseReleased(int x, int y, int button) {
        this.mouseX = x;
        this.mouseY = y;
        this.mouseButtons.released(button);
    }

    public void mouseMotion(int x, int y) {
        this.mouseX = x;
        this.mouseY = y;
    }

    public void mouseWheelMoved(int wheelRotation) {
        this.mouseW += wheelRotation;
    }

    public void keyPressed(int keyCode) {
        this.keyBoard.pressed(keyCode);
    }

    public void keyReleased(int keyCode) {
        this.keyBoard.released(keyCode);
    }

    public static class Button {
        private int[] buttons;

        public Button(int buttonsCount) {
            this.buttons = new int[buttonsCount];
        }

        public void pressed(int index) {
            if (this.buttons[index] <= 0) {
                this.buttons[index] = 1;
            }
        }

        public void released(int index) {
            if (this.buttons[index] >= 0) {
                this.buttons[index] = -1;
            }
        }

        public int getState(int index) {
            return this.buttons[index];
        }

        public int getCount() {
            return this.buttons.length;
        }

        public void spend() {
            for (int i = 0; i < this.buttons.length; ++i) {
                if (this.buttons[i] > 0) {
                    int n = i;
                    this.buttons[n] = this.buttons[n] + 1;
                    continue;
                }
                if (this.buttons[i] >= 0) continue;
                int n = i;
                this.buttons[n] = this.buttons[n] - 1;
            }
        }
    }
}

