/*
 * Decompiled with CFR 0.152.
 */
package mirrg.compile.iodine;

import java.util.function.Function;
import mirrg.compile.iodine.Node;
import mirrg.compile.iodine.NodeBase;

public interface INode<T> {
    public int getStart();

    public int getLength();

    public T getTag();

    public static <T> INode<T> create(int start, int length, T tag) {
        return new Node<T>(start, length, tag);
    }

    public static <IN extends OUT, OUT> INode<OUT> cast(final INode<IN> node) {
        if (node == null) {
            return null;
        }
        return new NodeBase<OUT>(){

            @Override
            public int getStart() {
                return node.getStart();
            }

            @Override
            public int getLength() {
                return node.getLength();
            }

            @Override
            public OUT getTag() {
                return node.getTag();
            }
        };
    }

    public static <IN, OUT> INode<OUT> map(final INode<? extends IN> node, final Function<IN, OUT> function) {
        if (node == null) {
            return null;
        }
        return new NodeBase<OUT>(){
            private OUT tag;
            {
                this.tag = function.apply(node.getTag());
            }

            @Override
            public int getStart() {
                return node.getStart();
            }

            @Override
            public int getLength() {
                return node.getLength();
            }

            @Override
            public OUT getTag() {
                return this.tag;
            }
        };
    }
}

