/*
 * Decompiled with CFR 0.152.
 */
package mirrg.compile.iodine.statements;

import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mirrg.compile.iodine.CompileArguments;
import mirrg.compile.iodine.INode;
import mirrg.compile.iodine.statements.ITagPattern;
import mirrg.compile.iodine.statements.StatementCreatorNode;

public class StatementPattern<T extends ITagPattern>
extends StatementCreatorNode<T> {
    public Pattern pattern;
    public String messageString;

    public StatementPattern(Supplier<T> creatorTag, Pattern pattern, String messageString) {
        super(creatorTag);
        this.pattern = pattern;
        this.messageString = messageString;
    }

    @Override
    public INode<? extends T> parse(CompileArguments compileArguments, int start, Predicate<INode<T>> predicateNode) {
        Matcher matcher = this.pattern.matcher(compileArguments.getSource());
        if (matcher.find(start) && matcher.start() == start) {
            String string = matcher.group();
            INode node = this.createNode(start, string.length());
            ((ITagPattern)node.getTag()).set(string, matcher);
            return predicateNode.test(node) ? node : null;
        }
        compileArguments.registerMessage(start, () -> "\u6b21\u306e\u30c8\u30fc\u30af\u30f3\u304c\u8003\u3048\u3089\u308c\u307e\u3059: " + this.messageString);
        return null;
    }
}

