/*
 * Decompiled with CFR 0.152.
 */
package mirrg.complex.hydrogen;

import org.apache.commons.math3.util.FastMath;

public final class StructureComplex {
    public double re = 0.0;
    public double im = 0.0;

    public StructureComplex() {
    }

    public StructureComplex(double re, double im) {
        this.re = re;
        this.im = im;
    }

    public static final StructureComplex createInstance(double re, double im) {
        return new StructureComplex(re, im);
    }

    public final StructureComplex copy() {
        return new StructureComplex(this.re, this.im);
    }

    public final double getRe() {
        return this.re;
    }

    public final void setRe(double re) {
        this.re = re;
    }

    public final double getIm() {
        return this.im;
    }

    public final void setIm(double im) {
        this.im = im;
    }

    public final void set(StructureComplex complex) {
        this.re = complex.re;
        this.im = complex.im;
    }

    public final void set(double re, double im) {
        this.re = re;
        this.im = im;
    }

    public final void setPolar(double abs, double arg) {
        this.re = abs * FastMath.cos(arg);
        this.im = abs * FastMath.sin(arg);
    }

    public final void setAbstract(double abs) {
        this.mul(abs / this.getAbstract());
    }

    public final void setArgument(double arg) {
        double arg2 = arg - this.getArgument();
        this.mul(FastMath.cos(arg2), FastMath.sin(arg2));
    }

    public final void add(StructureComplex a) {
        this.re += a.re;
        this.im += a.im;
    }

    public final void add(double re, double im) {
        this.re += re;
        this.im += im;
    }

    public final void add(double re) {
        this.re += re;
    }

    public final void sub(StructureComplex a) {
        this.re -= a.re;
        this.im -= a.im;
    }

    public final void sub(double re, double im) {
        this.re -= re;
        this.im -= im;
    }

    public final void sub(double re) {
        this.re -= re;
    }

    public final void mul(StructureComplex a) {
        this.mul(a.re, a.im);
    }

    public final void mul(double re, double im) {
        this.set(this.re * re - this.im * im, this.re * im + this.im * re);
    }

    public final void mul(double re) {
        this.re *= re;
        this.im *= re;
    }

    public final void div(StructureComplex a) {
        this.div(a.re, a.im);
    }

    public final void div(double re, double im) {
        double down = Math.pow(re, 2.0) + Math.pow(im, 2.0);
        this.set((this.re * re + this.im * im) / down, (this.im * re - this.re * im) / down);
    }

    public final void div(double re) {
        this.re /= re;
        this.im /= re;
    }

    public final void neg() {
        this.re = -this.re;
        this.im = -this.im;
    }

    public final void con() {
        this.im = -this.im;
    }

    public final void negcon() {
        this.re = -this.re;
    }

    public final void inv() {
        double down = Math.pow(this.re, 2.0) + Math.pow(this.im, 2.0);
        this.set(this.re / down, -this.im / down);
    }

    public final double getAbstract2() {
        return FastMath.pow(this.re, 2) + FastMath.pow(this.im, 2);
    }

    public final double getAbstract() {
        return FastMath.sqrt(this.getAbstract2());
    }

    public final double getLogAbstract() {
        return FastMath.log(this.getAbstract2()) / 2.0;
    }

    public final double getArgument() {
        return FastMath.atan2(this.im, this.re);
    }
}

