/*
 * Decompiled with CFR 0.152.
 */
package mirrg.complex.hydrogen.functions;

import mirrg.complex.hydrogen.StructureComplex;
import mirrg.complex.hydrogen.functions.Exponential;

public class Sigmoid {
    public static final void sigmoid(StructureComplex z, StructureComplex a) {
        z.mul(a);
        Sigmoid.sigmoid(z);
    }

    public static final void sigmoid(StructureComplex z, double r, double i) {
        z.mul(-r, -i);
        Exponential.exp(z);
        z.add(1.0);
        z.inv();
    }

    public static final void sigmoid(StructureComplex z, double r) {
        z.mul(-r);
        Exponential.exp(z);
        z.add(1.0);
        z.inv();
    }

    public static final void sigmoid(StructureComplex z) {
        z.neg();
        Exponential.exp(z);
        z.add(1.0);
        z.inv();
    }

    public static final void logit(StructureComplex z, StructureComplex a) {
        double ar = a.re;
        double ai = a.im;
        Sigmoid.logit(z);
        z.div(ar, ai);
    }

    public static final void logit(StructureComplex z, double r, double i) {
        Sigmoid.logit(z);
        z.div(r, i);
    }

    public static final void logit(StructureComplex z, double r) {
        Sigmoid.logit(z);
        z.div(r);
    }

    public static final void logit(StructureComplex z) {
        z.div(1.0 - z.re, -z.im);
        Exponential.ln(z);
    }
}

