/*
 * Decompiled with CFR 0.152.
 */
package mirrg.game.complexcanvas.wulfenite.script;

import mirrg.compile.iodine.CompileManager;
import mirrg.compile.iodine.INode;
import mirrg.compile.iodine.IStatement;
import mirrg.compile.iodine.comment.CommentManager;
import mirrg.compile.iodine.statements.StatementRoot;
import mirrg.compile.iodine.statements.wrapper.StatementOr;
import mirrg.compile.iodine.statements.wrapper.StatementSupplier;
import mirrg.compile.iodine.util.HStatements;
import mirrg.game.complexcanvas.wulfenite.script.IWulfeniteScript;
import mirrg.game.complexcanvas.wulfenite.script.TagsExpression;
import mirrg.game.complexcanvas.wulfenite.script.TagsRunnable;
import mirrg.game.complexcanvas.wulfenite.script.TagsTokenProvider;

public class CompilerWulfeniteScript {
    private final CompileManager<IWulfeniteScript> compileManager;
    private CommentManager<TagsTokenProvider.TagComments> commentManager = new CommentManager(HStatements.wrap(HStatements.loop(TagsTokenProvider.TagComments::new, HStatements.or().or(HStatements.pattern(TagsTokenProvider.TagPatternImpl::new, "/\\*.*?\\*/", "CommentBlock")).or(HStatements.pattern(TagsTokenProvider.TagPatternImpl::new, "[ \\t\\r\\n]+", "CommentSpaces")).or(HStatements.pattern(TagsTokenProvider.TagPatternImpl::new, "//.*?(?=[\\r\\n]|\\Z)", "CommentLine")))));

    public CompilerWulfeniteScript() {
        IStatement<TagsTokenProvider.TagPattern> statementIdentifier = this.pattern2("[a-zA-Z_][a-zA-Z0-9_]*", "Identifier");
        IStatement<TagsTokenProvider.TagPattern> statementTokenNumber = this.pattern2("([+\\-]?\\d+)(?:\\.(\\d+))?(?:[eE]([+\\-]?\\d+))?([iI])?", "Number");
        StatementSupplier statementExpression = new StatementSupplier();
        StatementSupplier statementLine = new StatementSupplier();
        StatementSupplier statementLines = new StatementSupplier();
        IStatement statementVariable = HStatements.wrap(HStatements.serial(TagsExpression.TagVariable::new).and(statementIdentifier, (built, node) -> {
            ((TagsExpression.TagVariable)built.getTag()).node = node;
        }));
        IStatement statementNumber = HStatements.wrap(HStatements.map(statementTokenNumber, tag -> new TagsExpression.TagNumber((TagsTokenProvider.TagPattern)tag)));
        IStatement statementBracket = HStatements.wrap(HStatements.map(HStatements.serial(TagWrapper::new).and(this.token2("(", false), (built, node) -> {}).and(statementExpression, (built, node) -> {
            ((TagWrapper)built.getTag()).node = node;
        }).and(this.token2(")", false), (built, node) -> {}), tag -> (TagsExpression.ITagExpression)tag.node.getTag()));
        IStatement statementDo = HStatements.wrap(HStatements.serial(TagsExpression.TagDo::new).and(this.token2("do", true), (built, node) -> {}).and(this.token2("{", false), (built, node) -> {}).and(statementLines, (built, node) -> {
            ((TagsExpression.TagDo)built.getTag()).nodeRunnable = node;
        }).and(statementExpression, (built, node) -> {
            ((TagsExpression.TagDo)built.getTag()).nodeLast = node;
        }).and(this.token2("}", false), (built, node) -> {}));
        IStatement statementFunction = HStatements.wrap(HStatements.serial(TagsExpression.TagFunction::new).and(statementIdentifier, (built, node) -> {
            ((TagsExpression.TagFunction)built.getTag()).nodeMethod = node;
        }).and(HStatements.or().or(HStatements.map(HStatements.serial(TagWrapper::new).and(this.token2("(", false), (built, node) -> {}).and(HStatements.operator(TagsExpression.TagFunction.TagArgumentList::new, statementExpression, this.token2(",", false)), (built, node) -> {
            ((TagWrapper)built.getTag()).node = node;
        }).and(this.token2(")", false), (built, node) -> {}), tag -> (TagsExpression.TagFunction.TagArgumentList)tag.node.getTag())).or(HStatements.serial(TagsExpression.TagFunction.TagArgumentList::new).and(this.token2("(", false), (built, node) -> {}).and(this.token2(")", false), (built, node) -> {})), (built, node) -> {
            ((TagsExpression.TagFunction)built.getTag()).nodeArguments = node;
        }));
        IStatement statementLiteral = HStatements.wrap(HStatements.or().or(statementVariable).or(statementNumber).or(statementBracket).or(statementFunction).or(statementDo));
        IStatement<TagsExpression.ITagExpression> statementPower = this.operatorOptimization(HStatements.operator(TagsExpression.TagOperatorRight::new, statementLiteral, HStatements.wrap(this.pattern2("[\\^]", "OperatorPower"))));
        IStatement statementNgationNumeric = HStatements.wrap(HStatements.or().or(statementPower).or(HStatements.serial(TagsExpression.TagNegation::new).and(this.token2("-", false), (built, node) -> {
            ((TagsExpression.TagNegation)built.getTag()).isBoolean = false;
        }).and(statementPower, (built, node) -> {
            ((TagsExpression.TagNegation)built.getTag()).node = node;
        })));
        IStatement<TagsExpression.ITagExpression> statementMultiplication = this.operatorOptimization(HStatements.operator(TagsExpression.TagOperatorLeft::new, statementNgationNumeric, HStatements.wrap(this.pattern2("[*/]", "OperatorMultiplication"))));
        IStatement<TagsExpression.ITagExpression> statementAddition = this.operatorOptimization(HStatements.operator(TagsExpression.TagOperatorLeft::new, statementMultiplication, HStatements.wrap(this.pattern2("[+\\-]", "OperatorAddition"))));
        IStatement<TagsExpression.ITagExpression> statementCompare = this.operatorOptimization(HStatements.operator(TagsExpression.TagOperatorLeft::new, statementAddition, HStatements.wrap(this.pattern2("(?:[<>]=?|[=!]=)", "OperatorCompare"))));
        IStatement statementNgation = HStatements.wrap(HStatements.or().or(statementCompare).or(HStatements.serial(TagsExpression.TagNegation::new).and(this.token2("!", false), (built, node) -> {
            ((TagsExpression.TagNegation)built.getTag()).isBoolean = true;
        }).and(statementCompare, (built, node) -> {
            ((TagsExpression.TagNegation)built.getTag()).node = node;
        })));
        IStatement<TagsExpression.ITagExpression> statementAnd = this.operatorOptimization(HStatements.operator(TagsExpression.TagOperatorLeft::new, statementNgation, HStatements.wrap(this.token2("&&", false))));
        IStatement<TagsExpression.ITagExpression> statementOr = this.operatorOptimization(HStatements.operator(TagsExpression.TagOperatorLeft::new, statementAnd, HStatements.wrap(this.token2("||", false))));
        IStatement statementIif = HStatements.wrap(HStatements.or().or(statementOr).or(HStatements.serial(TagsExpression.TagIif::new).and(statementOr, (built, node) -> {
            ((TagsExpression.TagIif)built.getTag()).nodeCondition = node;
        }).and(this.token2("?", false), (built, node) -> {}).and(statementOr, (built, node) -> {
            ((TagsExpression.TagIif)built.getTag()).nodeTrue = node;
        }).and(this.token2(":", false), (built, node) -> {}).and(statementOr, (built, node) -> {
            ((TagsExpression.TagIif)built.getTag()).nodeFalse = node;
        })));
        statementExpression.set(statementIif);
        IStatement statementEmptyStatement = HStatements.wrap(HStatements.map(this.token2(";", false), TagsRunnable.TagEmptyStatement::new));
        StatementOr<TagsRunnable.TagAssignment> statementAssignmentImpl = HStatements.or().or(HStatements.serial(TagsRunnable.TagAssignment::new).and(statementIdentifier, (built, node) -> {
            ((TagsRunnable.TagAssignment)built.getTag()).nodeVariable = node;
        }).and(this.token2("=", false), (built, node) -> {}).and(statementExpression, (built, node) -> {
            ((TagsRunnable.TagAssignment)built.getTag()).node = node;
        })).or(HStatements.serial(TagsRunnable.TagAssignment::new).and(statementExpression, (built, node) -> {
            ((TagsRunnable.TagAssignment)built.getTag()).node = node;
        }));
        IStatement statementAssignment = HStatements.wrap(HStatements.map(HStatements.serial(TagWrapper::new).and(statementAssignmentImpl, (built, node) -> {
            ((TagWrapper)built.getTag()).node = INode.cast(node);
        }).and(this.token2(";", false), (built, node) -> {}), tag -> (TagsRunnable.ITagRunnable)tag.node.getTag()));
        IStatement statementBlock = HStatements.wrap(HStatements.serial(TagsRunnable.TagStackFrame::new).and(this.token2("{", false), (built, node) -> {}).and(statementLines, (built, node) -> {
            ((TagsRunnable.TagStackFrame)built.getTag()).node = node;
        }).and(this.token2("}", false), (built, node) -> {}));
        IStatement statementDefineVariable = HStatements.wrap(HStatements.or().or(HStatements.serial(TagsRunnable.TagDefineVariable::new).and(this.token2("var", true), (built, node) -> {}).and(statementIdentifier, (built, node) -> {
            ((TagsRunnable.TagDefineVariable)built.getTag()).nodeVariable = node;
        }).and(this.token2("=", false), (built, node) -> {}).and(statementExpression, (built, node) -> {
            ((TagsRunnable.TagDefineVariable)built.getTag()).node = node;
        }).and(this.token2(";", false), (built, node) -> {})).or(HStatements.serial(TagsRunnable.TagDefineVariable::new).and(this.token2("var", true), (built, node) -> {}).and(statementIdentifier, (built, node) -> {
            ((TagsRunnable.TagDefineVariable)built.getTag()).nodeVariable = node;
        }).and(this.token2(";", false), (built, node) -> {})));
        IStatement statementWhile = HStatements.wrap(HStatements.serial(TagsRunnable.TagWhile::new).and(this.token2("while", true), (built, node) -> {}).and(this.token2("(", false), (built, node) -> {}).and(statementExpression, (built, node) -> {
            ((TagsRunnable.TagWhile)built.getTag()).nodeCondition = node;
        }).and(this.token2(")", false), (built, node) -> {}).and(statementLine, (built, node) -> {
            ((TagsRunnable.TagWhile)built.getTag()).nodeRunnable = node;
        }));
        IStatement statementFor = HStatements.wrap(HStatements.serial(TagsRunnable.TagFor::new).and(this.token2("for", true), (built, node) -> {}).and(this.token2("(", false), (built, node) -> {}).and(statementLine, (built, node) -> {
            ((TagsRunnable.TagFor)built.getTag()).nodeInitialize = node;
        }).and(statementExpression, (built, node) -> {
            ((TagsRunnable.TagFor)built.getTag()).nodeCondition = node;
        }).and(this.token2(";", false), (built, node) -> {}).and(statementAssignmentImpl, (built, node) -> {
            ((TagsRunnable.TagFor)built.getTag()).nodeIncrement = INode.cast(node);
        }).and(this.token2(")", false), (built, node) -> {}).and(statementLine, (built, node) -> {
            ((TagsRunnable.TagFor)built.getTag()).nodeRunnable = node;
        }));
        StatementOr statementStatement = HStatements.or().or(statementEmptyStatement).or(statementAssignment).or(statementBlock).or(statementDefineVariable).or(statementWhile).or(statementFor);
        IStatement statementStatements = HStatements.wrap(HStatements.loop(TagsRunnable.TagBlock::new, statementStatement));
        statementLine.set(statementStatement);
        statementLines.set(statementStatements);
        IStatement statementSource = HStatements.wrap(HStatements.map(HStatements.serial(TagWrapper::new).and(statementLines, (built, node) -> {
            ((TagWrapper)built.getTag()).node = node;
        }).and(this.pattern2("\\Z", "EndOfSource"), (built, node) -> {}), tag -> (TagsRunnable.ITagRunnable)tag.node.getTag()));
        this.compileManager = new CompileManager(new StatementRoot(statementSource));
    }

    private IStatement<TagsExpression.ITagExpression> operatorOptimization(IStatement<TagsExpression.TagOperator> operator) {
        return HStatements.wrap(HStatements.map(operator, tag -> tag.nodeExpressions.size() == 1 ? tag.nodeExpressions.get(0).getTag() : tag));
    }

    public CompileManager<IWulfeniteScript> getCompileManager() {
        return this.compileManager;
    }

    private IStatement<TagsTokenProvider.TagToken> token2(String token, boolean isIdentifier) {
        return this.commentManager.commented(TagsTokenProvider.TagToken::new, HStatements.token(TagsTokenProvider.TagTokenImpl::new, token, isIdentifier));
    }

    private IStatement<TagsTokenProvider.TagPattern> pattern2(String pattern, String messageString) {
        return this.commentManager.commented(TagsTokenProvider.TagPattern::new, HStatements.pattern(TagsTokenProvider.TagPatternImpl::new, pattern, messageString));
    }

    public static class TagWrapper<T> {
        public INode<T> node;
    }
}

