/*
 * Decompiled with CFR 0.152.
 */
package mirrg.game.complexcanvas.wulfenite.script;

import java.util.ArrayList;
import java.util.function.BiPredicate;
import mirrg.compile.iodine.INode;
import mirrg.compile.iodine.util.ITagOperator;
import mirrg.complex.hydrogen.StructureComplex;
import mirrg.complex.hydrogen.functions.Exponential;
import mirrg.complex.hydrogen.functions.Trigonometry;
import mirrg.game.complexcanvas.wulfenite.script.ArgumentWulfeniteScript;
import mirrg.game.complexcanvas.wulfenite.script.ArgumentWulfeniteScriptValidate;
import mirrg.game.complexcanvas.wulfenite.script.TagsRunnable;
import mirrg.game.complexcanvas.wulfenite.script.TagsTokenProvider;

public class TagsExpression {

    public static class TagDo
    implements ITagExpression {
        public INode<TagsRunnable.ITagRunnable> nodeRunnable;
        public INode<ITagExpression> nodeLast;
        public TagsRunnable.ITagRunnable tagRunnable;
        public ITagExpression tagLast;

        @Override
        public boolean validate(ArgumentWulfeniteScriptValidate argument) {
            boolean flag = true;
            argument.stackFrameRoot.pushStackFrame();
            argument.registerFrameRoot.pushRegisterFrame();
            this.tagRunnable = this.nodeRunnable.getTag();
            if (!this.tagRunnable.validate(argument)) {
                flag = false;
            }
            this.tagLast = this.nodeLast.getTag();
            if (!this.tagLast.validate(argument)) {
                flag = false;
            }
            argument.stackFrameRoot.popStackFrame();
            argument.registerFrameRoot.popRegisterFrame();
            return flag;
        }

        @Override
        public boolean calculate(ArgumentWulfeniteScript argument, StructureComplex out) {
            if (!this.tagRunnable.invoke(argument)) {
                return false;
            }
            return this.tagLast.calculate(argument, out);
        }
    }

    public static class TagIif
    implements ITagExpression {
        public INode<ITagExpression> nodeCondition;
        public INode<ITagExpression> nodeTrue;
        public INode<ITagExpression> nodeFalse;
        public int register1;

        @Override
        public boolean validate(ArgumentWulfeniteScriptValidate argument) {
            boolean flag = true;
            this.register1 = argument.registerFrameRoot.getRegisterFrame().defineRegister();
            if (!this.nodeCondition.getTag().validate(argument)) {
                flag = false;
            }
            if (!this.nodeTrue.getTag().validate(argument)) {
                flag = false;
            }
            if (!this.nodeFalse.getTag().validate(argument)) {
                flag = false;
            }
            return flag;
        }

        @Override
        public boolean calculate(ArgumentWulfeniteScript argument, StructureComplex out) {
            if (!this.nodeCondition.getTag().calculate(argument, argument.register.registers[this.register1])) {
                return false;
            }
            if (argument.register.registers[this.register1].re != 0.0) {
                return this.nodeTrue.getTag().calculate(argument, out);
            }
            return this.nodeFalse.getTag().calculate(argument, out);
        }
    }

    public static class TagNegation
    implements ITagExpression {
        public boolean isBoolean = false;
        public INode<ITagExpression> node;

        @Override
        public boolean validate(ArgumentWulfeniteScriptValidate argument) {
            return this.node.getTag().validate(argument);
        }

        @Override
        public boolean calculate(ArgumentWulfeniteScript argument, StructureComplex out) {
            if (this.isBoolean) {
                if (!this.node.getTag().calculate(argument, out)) {
                    return false;
                }
                out.set(out.re == 0.0 ? 1.0 : 0.0, 0.0);
                return true;
            }
            if (!this.node.getTag().calculate(argument, out)) {
                return false;
            }
            out.neg();
            return true;
        }
    }

    public static class TagOperatorLeft
    extends TagOperator {
        @Override
        public boolean calculate(ArgumentWulfeniteScript argument, StructureComplex out) {
            if (!this.expressions[0].calculate(argument, out)) {
                return false;
            }
            for (int i = 0; i < this.operators.length; ++i) {
                if (!this.expressions[i + 1].calculate(argument, argument.register.registers[this.register1])) {
                    return false;
                }
                this.calculate(this.operators[i], out, argument.register.registers[this.register1]);
            }
            return true;
        }
    }

    public static class TagOperatorRight
    extends TagOperator {
        @Override
        public boolean calculate(ArgumentWulfeniteScript argument, StructureComplex out) {
            if (!this.expressions[this.operators.length].calculate(argument, out)) {
                return false;
            }
            for (int i = this.operators.length - 1; i >= 0; --i) {
                if (!this.expressions[i].calculate(argument, argument.register.registers[this.register1])) {
                    return false;
                }
                this.calculate(this.operators[i], argument.register.registers[this.register1], out);
                out.set(argument.register.registers[this.register1]);
            }
            return true;
        }
    }

    public static abstract class TagOperator
    implements ITagExpression,
    ITagOperator<ITagExpression, TagsTokenProvider.ITagTokenProvider> {
        public ArrayList<INode<ITagExpression>> nodeExpressions = new ArrayList();
        public ArrayList<INode<TagsTokenProvider.ITagTokenProvider>> nodeOperators = new ArrayList();
        public ITagExpression[] expressions;
        public int[] operators;
        public int register1;

        @Override
        public void setExpression(int index, INode<ITagExpression> node) {
            while (this.nodeExpressions.size() <= index) {
                this.nodeExpressions.add(null);
            }
            this.nodeExpressions.set(index, node);
        }

        @Override
        public void setOperator(int index, INode<TagsTokenProvider.ITagTokenProvider> node) {
            while (this.nodeOperators.size() <= index) {
                this.nodeOperators.add(null);
            }
            this.nodeOperators.set(index, node);
        }

        public void calculate(int operator, StructureComplex left, StructureComplex right) {
            switch (operator) {
                case 0: {
                    Exponential.pow(left, right);
                    return;
                }
                case 1: {
                    left.add(right);
                    return;
                }
                case 2: {
                    left.sub(right);
                    return;
                }
                case 3: {
                    left.mul(right);
                    return;
                }
                case 4: {
                    left.div(right);
                    return;
                }
                case 5: {
                    left.re = left.re != 0.0 ? 1.0 : (right.re != 0.0 ? 1.0 : 0.0);
                    left.im = 0.0;
                    return;
                }
                case 6: {
                    left.re = left.re != 0.0 ? (right.re != 0.0 ? 1.0 : 0.0) : 0.0;
                    left.im = 0.0;
                    return;
                }
                case 7: {
                    left.re = left.re < right.re ? 1.0 : 0.0;
                    left.im = 0.0;
                    return;
                }
                case 8: {
                    left.re = left.re > right.re ? 1.0 : 0.0;
                    left.im = 0.0;
                    return;
                }
                case 9: {
                    left.re = left.re <= right.re ? 1.0 : 0.0;
                    left.im = 0.0;
                    return;
                }
                case 10: {
                    left.re = left.re >= right.re ? 1.0 : 0.0;
                    left.im = 0.0;
                    return;
                }
                case 11: {
                    left.re = left.re == right.re && left.im == right.im ? 1.0 : 0.0;
                    left.im = 0.0;
                    return;
                }
                case 12: {
                    left.re = left.re != right.re || left.im != right.im ? 1.0 : 0.0;
                    left.im = 0.0;
                    return;
                }
            }
        }

        @Override
        public boolean validate(ArgumentWulfeniteScriptValidate argument) {
            int i;
            boolean flag = true;
            this.register1 = argument.registerFrameRoot.getRegisterFrame().defineRegister();
            this.operators = new int[this.nodeOperators.size()];
            for (i = 0; i < this.nodeOperators.size(); ++i) {
                INode<TagsTokenProvider.ITagTokenProvider> operator = this.nodeOperators.get(i);
                String token = operator.getTag().getToken();
                int operatorCode = 0;
                this.operators[i] = operatorCode++;
                if (token.equals("^")) continue;
                this.operators[i] = operatorCode++;
                if (token.equals("+")) continue;
                this.operators[i] = operatorCode++;
                if (token.equals("-")) continue;
                this.operators[i] = operatorCode++;
                if (token.equals("*")) continue;
                this.operators[i] = operatorCode++;
                if (token.equals("/")) continue;
                this.operators[i] = operatorCode++;
                if (token.equals("||")) continue;
                this.operators[i] = operatorCode++;
                if (token.equals("&&")) continue;
                this.operators[i] = operatorCode++;
                if (token.equals("<")) continue;
                this.operators[i] = operatorCode++;
                if (token.equals(">")) continue;
                this.operators[i] = operatorCode++;
                if (token.equals("<=")) continue;
                this.operators[i] = operatorCode++;
                if (token.equals(">=")) continue;
                this.operators[i] = operatorCode++;
                if (token.equals("==")) continue;
                this.operators[i] = operatorCode++;
                if (token.equals("!=")) continue;
                flag = false;
            }
            this.expressions = new ITagExpression[this.nodeExpressions.size()];
            for (i = 0; i < this.nodeExpressions.size(); ++i) {
                INode<ITagExpression> expression = this.nodeExpressions.get(i);
                this.expressions[i] = expression.getTag();
                if (expression.getTag().validate(argument)) continue;
                flag = false;
            }
            return flag;
        }
    }

    public static class TagFunction
    implements ITagExpression {
        public INode<TagsTokenProvider.TagPattern> nodeMethod;
        public INode<TagArgumentList> nodeArguments;
        public BiPredicate<ArgumentWulfeniteScript, StructureComplex> method;
        public int[] registers;

        @Override
        public boolean validate(ArgumentWulfeniteScriptValidate argument) {
            if (this.nodeArguments.getTag().nodes == null) {
                argument.addMessage(this.nodeMethod, "\u5f15\u6570\u306e\u6570\u304c\u4e0d\u6b63\u3067\u3059: 0");
                return false;
            }
            if (this.nodeArguments.getTag().nodes.size() != 1) {
                argument.addMessage(this.nodeMethod, "\u5f15\u6570\u306e\u6570\u304c\u4e0d\u6b63\u3067\u3059: " + this.nodeArguments.getTag().nodes.size());
                return false;
            }
            this.registers = new int[this.nodeArguments.getTag().nodes.size()];
            for (int i = 0; i < this.nodeArguments.getTag().nodes.size(); ++i) {
                this.registers[i] = argument.registerFrameRoot.getRegisterFrame().defineRegister();
            }
            INode<ITagExpression> nodeArgument = this.nodeArguments.getTag().nodes.get(0);
            if (!nodeArgument.getTag().validate(argument)) {
                return false;
            }
            String string = ((TagsTokenProvider.TagPatternImpl)this.nodeMethod.getTag().child.getTag()).string;
            if (string.equals("pow")) {
                this.method = (argument2, out) -> {
                    ((ITagExpression)nodeArgument.getTag()).calculate((ArgumentWulfeniteScript)argument2, (StructureComplex)out);
                    Exponential.pow(out, 2.0);
                    return true;
                };
            } else if (string.equals("exp")) {
                this.method = (argument2, out) -> {
                    ((ITagExpression)nodeArgument.getTag()).calculate((ArgumentWulfeniteScript)argument2, (StructureComplex)out);
                    Exponential.exp(out);
                    return true;
                };
            } else if (string.equals("log")) {
                this.method = (argument2, out) -> {
                    ((ITagExpression)nodeArgument.getTag()).calculate((ArgumentWulfeniteScript)argument2, (StructureComplex)out);
                    Exponential.log(out);
                    return true;
                };
            } else if (string.equals("sin")) {
                this.method = (argument2, out) -> {
                    ((ITagExpression)nodeArgument.getTag()).calculate((ArgumentWulfeniteScript)argument2, (StructureComplex)out);
                    Trigonometry.sin(out);
                    return true;
                };
            } else if (string.equals("cos")) {
                this.method = (argument2, out) -> {
                    ((ITagExpression)nodeArgument.getTag()).calculate((ArgumentWulfeniteScript)argument2, (StructureComplex)out);
                    Trigonometry.cos(out);
                    return true;
                };
            } else if (string.equals("tan")) {
                this.method = (argument2, out) -> {
                    ((ITagExpression)nodeArgument.getTag()).calculate((ArgumentWulfeniteScript)argument2, (StructureComplex)out);
                    Trigonometry.tan(out);
                    return true;
                };
            } else if (string.equals("sinh")) {
                this.method = (argument2, out) -> {
                    ((ITagExpression)nodeArgument.getTag()).calculate((ArgumentWulfeniteScript)argument2, (StructureComplex)out);
                    Trigonometry.sinh(out);
                    return true;
                };
            } else if (string.equals("cosh")) {
                this.method = (argument2, out) -> {
                    ((ITagExpression)nodeArgument.getTag()).calculate((ArgumentWulfeniteScript)argument2, (StructureComplex)out);
                    Trigonometry.cosh(out);
                    return true;
                };
            } else if (string.equals("tanh")) {
                this.method = (argument2, out) -> {
                    ((ITagExpression)nodeArgument.getTag()).calculate((ArgumentWulfeniteScript)argument2, (StructureComplex)out);
                    Trigonometry.tanh(out);
                    return true;
                };
            } else if (string.equals("inv")) {
                this.method = (argument2, out) -> {
                    ((ITagExpression)nodeArgument.getTag()).calculate((ArgumentWulfeniteScript)argument2, (StructureComplex)out);
                    out.inv();
                    return true;
                };
            } else if (string.equals("neg")) {
                this.method = (argument2, out) -> {
                    ((ITagExpression)nodeArgument.getTag()).calculate((ArgumentWulfeniteScript)argument2, (StructureComplex)out);
                    out.neg();
                    return true;
                };
            } else if (string.equals("con")) {
                this.method = (argument2, out) -> {
                    ((ITagExpression)nodeArgument.getTag()).calculate((ArgumentWulfeniteScript)argument2, (StructureComplex)out);
                    out.con();
                    return true;
                };
            } else if (string.equals("abs")) {
                this.method = (argument2, out) -> {
                    ((ITagExpression)nodeArgument.getTag()).calculate((ArgumentWulfeniteScript)argument2, (StructureComplex)out);
                    out.set(out.getAbstract(), 0.0);
                    return true;
                };
            } else if (string.equals("abs2")) {
                this.method = (argument2, out) -> {
                    ((ITagExpression)nodeArgument.getTag()).calculate((ArgumentWulfeniteScript)argument2, (StructureComplex)out);
                    out.set(out.getAbstract2(), 0.0);
                    return true;
                };
            } else if (string.equals("arg")) {
                this.method = (argument2, out) -> {
                    ((ITagExpression)nodeArgument.getTag()).calculate((ArgumentWulfeniteScript)argument2, (StructureComplex)out);
                    out.set(out.getArgument(), 0.0);
                    return true;
                };
            } else if (string.equals("re")) {
                this.method = (argument2, out) -> {
                    ((ITagExpression)nodeArgument.getTag()).calculate((ArgumentWulfeniteScript)argument2, (StructureComplex)out);
                    out.set(out.re, 0.0);
                    return true;
                };
            } else if (string.equals("im")) {
                this.method = (argument2, out) -> {
                    ((ITagExpression)nodeArgument.getTag()).calculate((ArgumentWulfeniteScript)argument2, (StructureComplex)out);
                    out.set(out.im, 0.0);
                    return true;
                };
            } else {
                argument.addMessage(this.nodeMethod, "\u4e0d\u660e\u306a\u95a2\u6570\u3067\u3059: " + string);
                return false;
            }
            return true;
        }

        @Override
        public boolean calculate(ArgumentWulfeniteScript argument, StructureComplex out) {
            return this.method.test(argument, out);
        }

        public static class TagArgumentList
        implements ITagOperator<ITagExpression, TagsTokenProvider.TagToken> {
            public ArrayList<INode<ITagExpression>> nodes = new ArrayList();
            public ArrayList<INode<TagsTokenProvider.TagToken>> operators = new ArrayList();

            @Override
            public void setExpression(int index, INode<ITagExpression> node) {
                while (this.nodes.size() <= index) {
                    this.nodes.add(null);
                }
                this.nodes.set(index, node);
            }

            @Override
            public void setOperator(int index, INode<TagsTokenProvider.TagToken> node) {
                while (this.operators.size() <= index) {
                    this.operators.add(null);
                }
                this.operators.set(index, node);
            }
        }
    }

    public static class TagNumber
    implements ITagExpression {
        public TagsTokenProvider.TagPattern pattern;
        public StructureComplex value;

        public TagNumber(TagsTokenProvider.TagPattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean calculate(ArgumentWulfeniteScript argument, StructureComplex out) {
            out.set(this.value);
            return true;
        }

        @Override
        public boolean validate(ArgumentWulfeniteScriptValidate argument) {
            String a = ((TagsTokenProvider.TagPatternImpl)this.pattern.child.getTag()).matcher.group(1);
            String b = ((TagsTokenProvider.TagPatternImpl)this.pattern.child.getTag()).matcher.group(2);
            String c = ((TagsTokenProvider.TagPatternImpl)this.pattern.child.getTag()).matcher.group(3);
            String d = ((TagsTokenProvider.TagPatternImpl)this.pattern.child.getTag()).matcher.group(4);
            StringBuilder sb = new StringBuilder();
            sb.append(a);
            if (b != null) {
                sb.append(".");
                sb.append(b);
            }
            if (c != null) {
                sb.append("E");
                sb.append(c);
            }
            double value2 = Double.parseDouble(sb.toString());
            this.value = new StructureComplex();
            if (d != null) {
                this.value.set(0.0, value2);
            } else {
                this.value.set(value2, 0.0);
            }
            System.out.println("" + this + "     " + Thread.currentThread());
            return true;
        }
    }

    public static class TagVariable
    implements ITagExpression {
        public INode<TagsTokenProvider.TagPattern> node;
        public int index;

        @Override
        public boolean calculate(ArgumentWulfeniteScript argument, StructureComplex out) {
            out.set(argument.stack.variables[this.index]);
            return true;
        }

        @Override
        public boolean validate(ArgumentWulfeniteScriptValidate argument) {
            boolean flag = true;
            String name = ((TagsTokenProvider.TagPatternImpl)this.node.getTag().child.getTag()).string;
            Integer index2 = argument.stackFrameRoot.getStackFrame().getVariableIndex(name);
            if (index2 == null) {
                argument.addMessage(this.node, "\u672a\u5ba3\u8a00\u306e\u5909\u6570\u3067\u3059: " + name);
                flag = false;
            } else {
                this.index = index2;
            }
            return flag;
        }
    }

    public static interface ITagExpression {
        public boolean validate(ArgumentWulfeniteScriptValidate var1);

        public boolean calculate(ArgumentWulfeniteScript var1, StructureComplex var2);
    }
}

