/*
 * Decompiled with CFR 0.152.
 */
package mirrg.util.hydrogen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HLang {
    public static Hashtable<String, String> table = new Hashtable();
    public static Pattern pattern = Pattern.compile("\\s*([^=]+?)\\s*=\\s*(.*?)\\s*");

    public static void register(String key, String value) {
        table.put(key, value);
    }

    public static void register(Map<String, String> map) {
        map.entrySet().forEach(entry -> HLang.register((String)entry.getKey(), (String)entry.getValue()));
    }

    public static void register(String line) {
        Matcher matcher = pattern.matcher(line);
        if (!matcher.matches()) {
            throw new IllegalArgumentException();
        }
        HLang.register(matcher.group(1), matcher.group(2));
    }

    public static void register(InputStream in, Consumer<String> onIllegalLine) throws IOException {
        String line;
        BufferedReader in2 = new BufferedReader(new InputStreamReader(in));
        while ((line = in2.readLine()) != null) {
            try {
                HLang.register(line);
            }
            catch (IllegalArgumentException e) {
                onIllegalLine.accept(line);
            }
        }
    }

    public static void register(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            HLang.register(in, (String line) -> System.err.println("illegal lang entry: '" + line + "' at " + file.getName()));
        }
    }

    public static void registerFromFile(String filename) throws IOException {
        try (FileInputStream in = new FileInputStream(filename);){
            HLang.register(in, (String line) -> System.err.println("illegal lang entry: '" + line + "' at " + filename));
        }
    }

    public static boolean isLocalizable(String key) {
        return table.containsKey(key);
    }

    public static String localize(String key) {
        return table.containsKey(key) ? table.get(key) : key;
    }

    public static String localize(String pre, String key, String suf) {
        return HLang.localize(pre + "." + key + "." + suf);
    }

    public static String localize(String pre, String key) {
        return HLang.localize(pre, key, "name");
    }
}

