﻿Imports systembase.table

Public Class Sample5

    Private Sub Sample4_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim rp As New UTable.CRecordProvider
        With New CLayoutBuilder
            rp.AddField("button", New CButtonFieldProvider("ボタン", "+"), .Next)
            With rp.AddField("graph", New CGraphFieldProvider("グラフ"), .Next)
                .Setting.ForeColor = Color.Red
                .UserSortable = UTable.ESortable.ALLOW
            End With
            rp.AddField("date", New CDateFieldProvider("日付"), .Next)
        End With
        Me.Table.Content.SetRecordProvider(rp)
        Me.Table.CreateCaption()
        Using Me.Table.RenderBlock
            For i As Integer = 1 To 10
                Me.Table.Content.AddRecord()
            Next
        End Using
    End Sub

    Private Sub UTable_FieldButtonClick(ByVal field As systembase.table.UTable.CField) Handles Table.FieldButtonClick
        Select Case field.Key
            Case "button"
                field.Record.Fields("graph").Value += 1
        End Select
    End Sub

End Class

Class CGraphFieldProvider
    Inherits CFieldProvider

    Public Sub New(ByVal caption As String)
        MyBase.New(caption)
    End Sub

    Public Overrides Sub Render(ByVal g As System.Drawing.Graphics, ByVal field As UTable.CField, ByVal rect As Rectangle, ByVal alter As Boolean)
        Dim s As UTable.CDynamicSetting = field.DynamicSetting
        Me.RenderBackgroud(g, field, rect, s, alter)
        Me.RenderBorder(g, field, rect, s, alter)
        Dim l As Integer = field.Value * 10
        If l > rect.Width Then
            l = rect.Width
        End If
        Using b As New SolidBrush(s.ForeColor)
            g.FillRectangle(b, rect.X, rect.Y + 5, l, rect.Height - 10)
        End Using
    End Sub

End Class

Class CDateEditor
    Inherits DateTimePicker
    Implements IEditor

    Public Event _Leave(ByVal sender As Object, ByVal direction As String) Implements IEditor.Leave
    Public Event _ValueChanged(ByVal sender As Object) Implements IEditor.ValueChanged

    Public Sub New()
        Me.Format = DateTimePickerFormat.Custom
        Me.CustomFormat = "yyyy/MM/dd"
    End Sub

    Public Sub Initialize(ByVal field As systembase.table.UTable.CField) Implements IEditor.Initialize
        With field.DynamicSetting
            Me.Font = .Font
        End With
    End Sub

    Public Sub _Enter(ByVal key As Char, ByVal hIMC As Integer, ByVal clear As Boolean) Implements IEditor.Enter
        If clear Then
            Me.Text = Nothing
        End If
    End Sub

    Private Sub CDateEditor_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.ValueChanged
        RaiseEvent _ValueChanged(Me)
    End Sub

    Protected Overrides Function IsInputKey(ByVal keyData As System.Windows.Forms.Keys) As Boolean
        Select Case keyData
            Case Keys.Escape
                RaiseEvent _Leave(Me, "ESC")
                Return True
            Case Keys.Enter
                RaiseEvent _Leave(Me, "ENTER")
                Return True
            Case (Keys.Enter Or Keys.Shift)
                RaiseEvent _Leave(Me, "ENTER_PREV")
                Return True
            Case Keys.Tab
                RaiseEvent _Leave(Me, "TAB")
                Return True
            Case (Keys.Tab Or Keys.Shift)
                RaiseEvent _Leave(Me, "TAB_PREV")
                Return True
        End Select
        Return MyBase.IsInputKey(keyData)
    End Function

    Public Function RaiseValidate() As Boolean Implements IEditor.RaiseValidate
        Dim e As New System.ComponentModel.CancelEventArgs
        Me.OnValidating(e)
        If Not e.Cancel Then
            Me.OnValidated(System.EventArgs.Empty)
            Return True
        End If
        Return False
    End Function

    Public Property _Value() As Object Implements IEditor.Value
        Get
            Return Me.Value
        End Get
        Set(ByVal value As Object)
            If TypeOf value Is Date Then
                Me.Value = value
            End If
        End Set
    End Property

    Public Function Control() As Control Implements IEditor.Control
        Return Me
    End Function

End Class

Class CDateFieldProvider
    Inherits CFieldProvider

    Public Sub New(ByVal caption As String)
        MyBase.New(caption)
    End Sub

    Public Overrides Function Editor() As systembase.table.IEditor
        Return New CDateEditor
    End Function

    Public Overrides Function ValueFormat(ByVal v As Object) As String
        If TypeOf v Is Date Then
            Return CType(v, Date).ToString("yyyy/MM/dd")
        Else
            Return ""
        End If
    End Function

End Class