' table.Event.vb
'
' Copyright (c) 2008, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without 
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright 
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright 
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Partial Class UTable

    Private Sub UTable_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Click
        Me.Focus()
    End Sub

    Private Sub UTable_Enter(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Enter
        Me.Focus()
    End Sub

    Public MouseDownField As CField = Nothing
    Private Sub UTable_MouseDown(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Me.MouseDown
        If Me.Editor IsNot Nothing Then
            If Not Me.Editor.RaiseValidate Then
                Exit Sub
            End If
        End If
        If Me.cols_MouseDown(e) Then
            Exit Sub
        End If
        If Me.focus_MouseDown(e) Then
            Exit Sub
        End If
        If Me.Editor Is Nothing Then
            Dim field As CRenderCache.CField = Me.RenderCache.FindField(e.Location)
            If field IsNot Nothing Then
                Me.MouseDownField = field.Field
                Dim l As New Point(e.X - field.Rect.Left, e.Y - field.Rect.Top)
                RaiseEvent FieldMouseDown(field.Field, l, e)
                field.Field.RaiseMouseDown(l, e)
                Exit Sub
            End If
        End If
    End Sub

    Private Sub UTable_MouseUp(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Me.MouseUp
        If Me.cols_MouseUp(e) Then
            Exit Sub
        End If
        If Me.Editor Is Nothing Then
            If Me.MouseDownField IsNot Nothing Then                
                Dim field As CRenderCache.CField = Me.RenderCache.FindField(e.Location)
                Dim l As Point
                If field IsNot Nothing AndAlso Me.MouseDownField Is field.Field Then
                    l = New Point(e.X - field.Rect.Left, e.Y - field.Rect.Top)
                Else
                    l = New Point(-1, -1)
                End If
                Dim _f = Me.MouseDownField
                Me.MouseDownField = Nothing
                RaiseEvent FieldMouseUp(_f, l, e)
                _f.RaiseMouseUp(l, e)
                Exit Sub                
            End If
        End If
    End Sub

    Private Sub UTable_MouseMove(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Me.MouseMove
        If Me.cols_MouseMove(e) Then
            Exit Sub
        End If
        If Me.Editor Is Nothing Then
            Dim field As CRenderCache.CField = Me.RenderCache.FindField(e.Location)
            If field IsNot Nothing Then
                Dim l As New Point(e.X - field.Rect.Left, e.Y - field.Rect.Top)
                RaiseEvent FieldMouseMove(field.Field, l, e)
                field.Field.RaiseMouseMove(l, e)
                Exit Sub
            End If
        End If
    End Sub

    Private Sub UTable_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles Me.KeyPress
        If Me.edit_KeyPress(e) Then
            Exit Sub
        End If
    End Sub

    Private Sub UTable_MouseClick(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Me.MouseClick
        If Me.Editor Is Nothing Then
            Dim field As CRenderCache.CField = Me.RenderCache.FindField(e.Location)
            If field IsNot Nothing Then
                Dim l As New Point(e.X - field.Rect.Left, e.Y - field.Rect.Top)
                RaiseEvent FieldClick(field.Field, l, e)
                field.Field.RaiseClick(l, e)
                Exit Sub
            End If
        End If
    End Sub

    Private Sub UTable_MouseDoubleClick(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Me.MouseDoubleClick
        If Me.cols_MouseDoubleClick(e) Then
            Exit Sub
        End If
        If Me.edit_MouseDoubleClick(e) Then
            Exit Sub
        End If
        If Me.Editor Is Nothing Then
            Dim field As CRenderCache.CField = Me.RenderCache.FindField(e.Location)
            If field IsNot Nothing Then
                Dim l As New Point(e.X - field.Rect.Left, e.Y - field.Rect.Top)
                RaiseEvent FieldDoubleClick(field.Field, l, e)
                field.Field.RaiseDoubleClick(l, e)
                Exit Sub
            End If
        End If
    End Sub

    Private Sub UTable_KeyDown(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles Me.KeyDown
        If Me.edit_KeyDown(e) Then
            Exit Sub
        End If
        If Me.Editor Is Nothing Then
            If Me.FocusField IsNot Nothing Then
                RaiseEvent FieldKeyDown(Me.FocusField, e)
                Me.FocusField.RaiseKeyDown(e)
                Exit Sub
            End If
        End If
    End Sub

    Private Sub UTable_KeyUp(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles Me.KeyUp
        If Me.Editor Is Nothing Then
            If Me.FocusField IsNot Nothing Then
                RaiseEvent FieldKeyUp(Me.FocusField, e)
                Me.FocusField.RaiseKeyUp(e)
                Exit Sub
            End If
        End If
    End Sub

    Private Sub UTable_GotFocus(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.GotFocus
        Using Me.RenderBlock
            If Me.FocusField IsNot Nothing Then
                Me.ime_AssociateContext(Me.FocusField)
            End If
            If Me.Setting.AutoFocus AndAlso Me.FocusField Is Nothing Then
                Me.FocusField = Me.Content.DefaultField
            End If
        End Using
    End Sub

    Private Sub UTable_LostFocus(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.LostFocus
        If Me.AutoUpdate Then
            Me.Render()
        End If
    End Sub

End Class
