' table/Focus.vb
'
' Copyright (c) 2008, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without 
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright 
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright 
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Partial Class UTable
    Public FocusGrid As New CGrid.CPoint

    Private _FocusField As CField = Nothing
    Private _FocusRecord As CRecord = Nothing

    Public Property FocusField() As CField
        Get
            Return Me._FocusField
        End Get
        Set(ByVal value As CField)
            Using Me.RenderBlock
                Me.setFocusField(value)
                If Me.FocusField IsNot Nothing AndAlso Me.FocusField Is value Then
                    Me.FocusGrid.Row = Me.FocusField.Desc.Layout.Row
                    Me.FocusGrid.Col = Me.FocusField.Desc.Layout.Col
                End If
            End Using
        End Set
    End Property

    Public Sub MoveFocusField(ByVal field As CField)
        Using Me.RenderBlock
            Me.setFocusField(field)
            If Me.FocusField IsNot Nothing Then
                With Me.FocusField.Desc
                    If Me.FocusGrid.Row < .Layout.Row Then
                        Me.FocusGrid.Row = .Layout.Row
                    ElseIf Me.FocusGrid.Row >= .Layout.BottomRow Then
                        Me.FocusGrid.Row = .Layout.BottomRow
                    End If
                    If Me.FocusGrid.Col < .Layout.Col Then
                        Me.FocusGrid.Col = .Layout.Col
                    ElseIf Me.FocusGrid.Col >= .Layout.RightCol Then
                        Me.FocusGrid.Col = .Layout.RightCol
                    End If
                End With
            End If
        End Using
    End Sub

    Private Sub setFocusField(ByVal field As CField)        
        If Me.Editor IsNot Nothing Then
            If Not Me.LeaveEdit Then
                Exit Sub
            End If
        End If
        If field IsNot Nothing AndAlso Not field.Focusable Then
            Exit Sub
        End If
        Dim _focusField_bak As CField = Me.FocusField
        Dim cancel As Boolean = False
        RaiseEvent FieldEntering(field, cancel)
        If Not cancel Then
            Me.ime_AssociateContext(field)
            Me._FocusField = field
            If _focusField_bak IsNot Nothing AndAlso _focusField_bak IsNot field Then
                _focusField_bak.RaiseLeave()
                RaiseEvent FieldLeave(_focusField_bak)
            End If
            If Me.FocusField IsNot Nothing Then
                Me._FocusRecord = field.Record
                Me.ScrollTo(Me.FocusField)
                If field IsNot _focusField_bak Then
                    field.RaiseEnter()
                    RaiseEvent FieldEnter(field)
                End If
                If Not Me.Focused OrElse _focusField_bak Is Nothing OrElse _focusField_bak.Record IsNot field.Record Then
                    RaiseEvent RecordEnter(field.Record)
                End If
            Else
                Me._FocusRecord = Nothing
            End If
        End If
    End Sub

    Public Sub ScrollTo(ByVal field As CField)
        If field IsNot Nothing Then

            Dim rect As Rectangle = field.GetRectangle
            If Me.Setting.ScrollUnit = EScrollUnit.RECORD Then
                With field.Record.GetRectangle
                    rect.Y = .Y
                    rect.Height = .Height
                End With
            End If
            RaiseEvent DecideScrollRect(field, rect)

            If rect.Top < Me.VScrollBar.Value Then
                Me.SetScrollValue(Me.VScrollBar, rect.Top)
            ElseIf rect.Bottom - Me.VScrollBar.Value > Me.ContentRowSize Then
                If Me.ContentRowSize >= rect.Height Then
                    Me.SetScrollValue(Me.VScrollBar, rect.Bottom - Me.ContentRowSize + 1)
                Else
                    Me.SetScrollValue(Me.VScrollBar, rect.Top)
                End If
            End If

            If field.Desc.Layout.Col >= Me.FixedCols Then
                If (rect.Left - field.Table.LayoutCache.FixedColsSize) - Me.HScrollBar.Value < 0 Then
                    Me.SetScrollValue(Me.HScrollBar, (rect.Left - field.Table.LayoutCache.FixedColsSize))
                ElseIf rect.Right - Me.HScrollBar.Value > Me.ContentColSize Then
                    If Me.ContentColSize >= rect.Width Then
                        Me.SetScrollValue(Me.HScrollBar, rect.Right - Me.ContentColSize + 1)
                    Else
                        Me.SetScrollValue(Me.HScrollBar, rect.Left)
                    End If
                End If
            End If

        End If
    End Sub

    Public ReadOnly Property FocusRecord() As CRecord
        Get
            Return Me._FocusRecord
        End Get
    End Property

    Private Function focus_MouseDown(ByVal e As System.Windows.Forms.MouseEventArgs) As Boolean
        If e.Button = Windows.Forms.MouseButtons.Left And _
           e.Location.Y > Me.HeaderContent.LayoutCache.RowsSize And _
           e.Location.Y < Me.Height - Me.FooterContent.LayoutCache.RowsSize Then
            Dim field As UTable.CRenderCache.CField = Me.RenderCache.FindField(e.Location)
            If field IsNot Nothing Then
                Me.FocusField = field.Field
            End If
        End If
        Return False
    End Function

    Protected Overrides Function ProcessDialogKey(ByVal keyData As System.Windows.Forms.Keys) As Boolean
        If Me.Editor Is Nothing Then
            If keyData = Keys.Enter And Me.FocusField IsNot Nothing Then
                Dim handled As Boolean = False
                RaiseEvent FieldSelected(Me.FocusField, handled)
                If handled Then
                    Return True
                End If
            End If
            If Me.KeyboardOperation.ProcessDialogKey(keyData, Me) Then
                Return True
            End If
        End If
        Return MyBase.ProcessDialogKey(keyData)
    End Function

End Class