' table/Cols.vb
'
' Copyright (c) 2008, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without 
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Partial Class UTable

    Friend Sub prepareCols(ByVal cols_count As Integer)
        Do While Me.Cols.Count < cols_count
            Me.Cols.Add(New CGrid(Me))
            Me.UpdateCacheInvalid = True
        Loop
    End Sub

    Public Property FixedCols() As Integer
        Get
            Return Me._FixedCols
        End Get
        Set(ByVal value As Integer)
            Using Me.RenderBlock
                Me._FixedCols = value
                Me.UpdateCacheInvalid = True
            End Using
        End Set
    End Property

    Class CResizing
        Public Size As Integer
        Public Col As Integer
    End Class

    Private cursor_resizing As CResizing = Nothing
    Private resizing As CResizing = Nothing

    Private Function cols_MouseDown(ByVal e As System.Windows.Forms.MouseEventArgs) As Boolean
        If e.Button = Windows.Forms.MouseButtons.Left Then
            If Me.cursor_resizing IsNot Nothing Then
                Me.resizing = Me.cursor_resizing
                Me.resizing.Size = Me.Cols(Me.resizing.Col).Size
                Return True
            End If
        End If
        Return False
    End Function

    Private Function cols_MouseDoubleClick(ByVal e As System.Windows.Forms.MouseEventArgs) As Boolean
        Using Me.RenderBlock
            If Me.cursor_resizing IsNot Nothing Then
                Dim i As Integer = Me.cursor_resizing.Col                
                Dim allow As EAllow = Me.Setting.UserColAdjustable
                If Me.Cols(i).UserAdjustable <> EAllow.DEFAULT Then
                    allow = Me.Cols(i).UserAdjustable
                End If
                If allow = EAllow.ALLOW Then
                    Me.AdjustSize(i)
                    Me.resizing = Nothing
                    Me.cursor_resizing = Nothing
                    Return True
                End If            
            End If
        End Using
        Return False
    End Function

    Private Function cols_MouseMove(ByVal e As System.Windows.Forms.MouseEventArgs) As Boolean
        Return resize_col(e.Location.Y, e.Location.X, Cursors.VSplit)
        Return False
    End Function

    Private Function cols_MouseUp(ByVal e As System.Windows.Forms.MouseEventArgs) As Boolean
        If Me.resizing IsNot Nothing Then
            Using Me.RenderBlock
                Me.Cols(Me.resizing.Col).Size = Me.resizing.Size
                Me.resizing = Nothing
                Me.cursor_resizing = Nothing
                Me.UpdateCacheInvalid = True
            End Using
            Return True
        End If
        Return False
    End Function

    Private Function resize_col(ByVal row_pos As Integer, ByVal col_pos As Integer, ByVal resizableCorsor As Cursor) As Boolean
        Me.Cursor = Cursors.Default
        If Me.Editor IsNot Nothing Then
            Return False
        End If
        If Me.resizing Is Nothing Then
            Me.cursor_resizing = Nothing
            If row_pos <= Me.HeaderContent.LayoutCache.RowsSize Then
                For i As Integer = 0 To Me.RenderCache.Cols.Count - 1
                    If Me.RenderCache.Cols(i).Appeared AndAlso _
                       Math.Abs(col_pos - Me.RenderCache.Cols(i).To) <= 3 Then
                        Dim allow As EAllow = Me.Setting.UserColResizable
                        If Me.Cols(i).UserResizable <> EAllow.DEFAULT Then
                            allow = Me.Cols(i).UserResizable
                        End If
                        If allow = EAllow.ALLOW Then
                            Me.Cursor = resizableCorsor
                            Me.cursor_resizing = New CResizing
                            Me.cursor_resizing.Col = i
                        End If
                    End If
                Next
            End If
            Return False
        Else
            Me.Cursor = resizableCorsor
            Dim size As Integer = col_pos - Me.RenderCache.Cols(Me.resizing.Col).From
            With Me.Cols(Me.resizing.Col)
                If size > 1 And _
                   (.SizeMin = 0 Or size >= .SizeMin) And _
                   (.SizeMax = 0 Or size <= .SizeMax) And _
                   (isSizeValid(size)) Then
                    Using Me.RenderBlock
                        Me.resizing.Size = size
                    End Using
                End If
            End With
            Return True
        End If
    End Function

    Private Function isSizeValid(ByVal size As Integer) As Boolean
        If Me.resizing.Col < Me.FixedCols Then
            Dim fixedColsSize As Integer = Me.Cols.GetSize(0, Me.FixedCols)            
            If Me.Width - ScrollBarWidth < fixedColsSize - Me.Cols(Me.resizing.Col).Size + size Then
                Return False
            End If
        End If
        Return True
    End Function

End Class