﻿Imports systembase.table

Public Class Sample5

    Private Sub Sample4_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim rp As New UTable.CRecordProvider
        With New CLayoutBuilder
            rp.AddField("button", New CButtonFieldProvider("ボタン", "+"), .Next)
            rp.AddField("camma", New CCammaFieldProvider("カンマ編集"), .Next)
            With rp.AddField("graph", New CGraphFieldProvider("グラフ"), .Next)
                .Setting.ForeColor = Color.Red
                .UserSortable = UTable.EAllow.ALLOW
            End With
            rp.AddField("date", New CDateFieldProvider("日付"), .Next)
        End With
        Me.Table.Content.SetRecordProvider(rp)
        Me.Table.CreateCaption()
        Using Me.Table.RenderBlock
            For i As Integer = 1 To 10
                Me.Table.Content.AddRecord()
            Next
        End Using
    End Sub

    Private Sub UTable_FieldButtonClick(ByVal field As UTableEx.CField) Handles Table.FieldButtonClick
        Select Case field.Key
            Case "button"
                field.Record.Fields("camma").Value += 100000
                field.Record.Fields("graph").Value += 1
        End Select
    End Sub

End Class

Class CCammaFieldProvider
    Inherits CFieldProvider

    Public Sub New(ByVal caption As String)
        MyBase.New(caption)
    End Sub

    Protected Overrides Function formatValue(ByVal v As Object) As String
        Return Format(v, "#,###")
    End Function

    Public Overrides Function Setting() As systembase.table.UTable.CSetting
        Dim s As New UTable.CSetting
        s.HorizontalAlignment = UTable.EHAlign.RIGHT
        Return s
    End Function

End Class

Class CGraphFieldProvider
    Inherits CFieldProvider

    Public Sub New(ByVal caption As String)
        MyBase.New(caption)
    End Sub

    Protected Overrides Sub renderForeGround(ByVal g As System.Drawing.Graphics, ByVal field As systembase.table.UTable.CField, ByVal s As systembase.table.UTable.CDynamicSetting, ByVal rect As System.Drawing.Rectangle, ByVal alter As Boolean)
        g.SetClip(rect)
        Dim l As Integer = field.Value * 10
        If l > 0 Then
            Using b As New SolidBrush(Color.SteelBlue)
                g.FillRectangle(b, New Rectangle(rect.X, rect.Y + 5, l, rect.Height - 10))
            End Using
        End If
        g.ResetClip()
    End Sub

    Public Overrides Function GetAdjustSize(ByVal g As System.Drawing.Graphics, ByVal field As systembase.table.UTable.CField) As System.Drawing.Size
        Return New Size(field.Value * 10, field.Table.DefaultGridSize.Row)
    End Function

End Class

Class CDateEditor
    Inherits DateTimePicker
    Implements IEditor

    Public Event _Leave(ByVal sender As Object, ByVal direction As String) Implements IEditor.Leave
    Public Event _ValueChanged(ByVal sender As Object) Implements IEditor.ValueChanged

    Public Sub New()
        Me.Format = DateTimePickerFormat.Custom
        Me.CustomFormat = "yyyy/MM/dd"
    End Sub

    Public Sub Initialize(ByVal field As UTableEx.CField) Implements IEditor.Initialize
        With field.DynamicSetting
            Me.Font = .Font
        End With
    End Sub

    Public Sub EditEnter(ByVal key As Char, ByVal hIMC As Integer) Implements IEditor.EditEnter
    End Sub

    Private Sub CDateEditor_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.ValueChanged
        RaiseEvent _ValueChanged(Me)
    End Sub

    Protected Overrides Function IsInputKey(ByVal keyData As System.Windows.Forms.Keys) As Boolean
        Select Case keyData
            Case Keys.Escape
                RaiseEvent _Leave(Me, "ESC")
                Return True
            Case Keys.Enter
                RaiseEvent _Leave(Me, "ENTER")
                Return True
            Case (Keys.Enter Or Keys.Shift)
                RaiseEvent _Leave(Me, "ENTER_PREV")
                Return True
            Case Keys.Tab
                RaiseEvent _Leave(Me, "TAB")
                Return True
            Case (Keys.Tab Or Keys.Shift)
                RaiseEvent _Leave(Me, "TAB_PREV")
                Return True
        End Select
        Return MyBase.IsInputKey(keyData)
    End Function

    Public Property _Value() As Object Implements IEditor.Value
        Get
            Return Me.Value
        End Get
        Set(ByVal value As Object)
            If TypeOf value Is Date Then
                Me.Value = value
            End If
        End Set
    End Property

    Public Function Control() As Control Implements IEditor.Control
        Return Me
    End Function

End Class

Class CDateFieldProvider
    Inherits CFieldProvider

    Public Sub New(ByVal caption As String)
        MyBase.New(caption)
    End Sub

    Public Overrides Function CreateEditor() As systembase.table.IEditor
        Return New CDateEditor
    End Function

    Protected Overrides Function formatValue(ByVal v As Object) As String
        If TypeOf v Is Date Then
            Return CType(v, Date).ToString("yyyy/MM/dd")
        Else
            Return ""
        End If
    End Function

End Class