﻿' table/TextBoxEditor.vb
'
' Copyright (c) 2009, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Public Class CTextBoxEditor
    Inherits TextBox
    Implements IEditor

    Public Event _Leave(ByVal sender As Object, ByVal direction As String) Implements IEditor.Leave
    Public Event _ValueChanged(ByVal sender As Object) Implements IEditor.ValueChanged

    Public Sub Initialize(ByVal field As UTable.CField) Implements IEditor.Initialize
        With field.DynamicSetting
            Me.Font = .Font
            Select Case .HorizontalAlignment
                Case UTable.EHAlign.LEFT
                    Me.TextAlign = HorizontalAlignment.Left
                Case UTable.EHAlign.MIDDLE
                    Me.TextAlign = HorizontalAlignment.Center
                Case UTable.EHAlign.RIGHT
                    Me.TextAlign = HorizontalAlignment.Right
            End Select
        End With
    End Sub

    Public Property Value() As Object Implements IEditor.Value
        Get
            Return Me.Text
        End Get
        Set(ByVal value As Object)
            Me.Text = value
        End Set
    End Property

    Protected Overrides Function IsInputKey(ByVal keyData As System.Windows.Forms.Keys) As Boolean
        Select Case keyData
            Case Keys.Escape
                RaiseEvent _Leave(Me, "ESC")
                Return True
            Case Keys.Up
                If Not Me.Multiline OrElse Me.SelectionStart <= (Me.Text & vbCr).IndexOf(vbCr) Then
                    RaiseEvent _Leave(Me, "UP")
                    Return True
                End If
            Case Keys.Down
                If Not Me.Multiline OrElse Me.SelectionStart >= (vbCr & Me.Text).LastIndexOf(vbCr) Then
                    RaiseEvent _Leave(Me, "DOWN")
                    Return True
                End If
            Case Keys.Left
                If Me.SelectionLength = 0 And Me.SelectionStart = 0 Then
                    RaiseEvent _Leave(Me, "LEFT")
                    Return True
                End If
            Case Keys.Right
                If Me.SelectionLength = 0 And Me.SelectionStart = Me.Text.Length Then
                    RaiseEvent _Leave(Me, "RIGHT")
                    Return True
                End If
            Case Keys.Enter
                If Not Me.Multiline Then
                    RaiseEvent _Leave(Me, "ENTER")
                    Return True
                End If
            Case (Keys.Enter Or Keys.Shift)
                If Not Me.Multiline Then
                    RaiseEvent _Leave(Me, "ENTER_PREV")
                    Return True
                End If
            Case Keys.Tab
                RaiseEvent _Leave(Me, "TAB")
                Return True
            Case (Keys.Tab Or Keys.Shift)
                RaiseEvent _Leave(Me, "TAB_PREV")
                Return True
        End Select
        Return MyBase.IsInputKey(keyData)
    End Function

    Private Sub CTextBoxEditor_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.TextChanged
        RaiseEvent _ValueChanged(Me)
    End Sub

    Public Sub EditEnter(ByVal key As Char, ByVal hIMC As Integer) Implements IEditor.EditEnter
        UTable.ImmAssociateContext(Me, hIMC)
        If key <> Nothing Then
            Me.Text = key
            Me.SelectionStart = 1
        End If
    End Sub

    Public Function Control() As System.Windows.Forms.Control Implements IEditor.Control
        Return Me
    End Function

End Class
