﻿' table/FrameDecorator.vb
'
' Copyright (c) 2009, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Public Class CFrameDecorator
    Implements IFieldDecorator
    Public Color As Color
    Public Sub New(ByVal color As Color)
        Me.Color = color
    End Sub
    Public Sub RenderBackground(ByVal g As Graphics, ByVal field As UTable.CField, ByVal rect As Rectangle) Implements IFieldDecorator.RenderBackground
        Using p As New Pen(Me.Color, 2)
            g.DrawRectangle(p, New Rectangle(rect.Left + 2, rect.Top + 2, rect.Width - 3, rect.Height - 3))
        End Using
    End Sub
    Public Sub RenderForeground(ByVal g As Graphics, ByVal field As UTable.CField, ByVal rect As Rectangle) Implements IFieldDecorator.RenderForeground
    End Sub
End Class