﻿' table/NarrowChildFieldProvider.vb
'
' Copyright (c) 2009, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Public Class CNarrowChildFieldProvider
    Inherits CFieldProvider

    Public Sub New()
        Me.New(Nothing)
    End Sub

    Public Sub New(ByVal caption As String)
        MyBase.New(caption)
    End Sub

    Public Overrides Function CreateField() As UTable.CField
        Return New CNarrowChildField()
    End Function

    Public Overrides Sub FieldInitialize(ByVal field As UTable.CField)
        CFieldProvider.SetToggleHandler(field)
    End Sub

    Protected Overrides Sub renderForeGround(ByVal g As System.Drawing.Graphics, ByVal field As UTable.CField, ByVal s As UTable.CDynamicSetting, ByVal rect As System.Drawing.Rectangle, ByVal alter As Boolean)
        RenderNarrowChild(g, rect, field.Value)
    End Sub

    Public Overrides Function GetAdjustSize(ByVal g As Graphics, ByVal field As UTable.CField) As Size
        Return CFieldProvider.ADJUSTSIZE_TOGGLE
    End Function

    Public Class CNarrowChildField
        Inherits UTable.CField

        Public Overrides Property Value() As Object
            Get
                If Me.Record.Child IsNot Nothing AndAlso Me.Record.Child.Records.Count > 0 Then
                    Return Me.Record.Child.Visible
                Else
                    Return True
                End If
            End Get
            Set(ByVal value As Object)
                MyBase.Value = value
            End Set
        End Property

        Public Overrides Sub ValueCommit(ByVal v As Object)
            If Me.Record.Child IsNot Nothing Then
                Me.Record.Child.Visible = v
            End If
        End Sub

        Public Overrides Sub Clear()
        End Sub

    End Class

End Class