' table/Setting.vb
'
' Copyright (c) 2009, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Partial Class UTable

    Public Enum EVAlign
        [DEFAULT]
        TOP
        MIDDLE
        BOTTOM
    End Enum

    Public Enum EHAlign
        [DEFAULT]
        LEFT
        MIDDLE
        RIGHT
    End Enum

    Public Enum EAllow
        [DEFAULT]
        ALLOW
        DISABLE
    End Enum

    Public Enum ETabStop
        [DEFAULT]
        [STOP]
        NOTSTOP
    End Enum

    Public Enum ETextWrap
        [DEFAULT]
        WRAP
        NOWRAP
    End Enum

    Public Enum EScrollUnit
        FIELD
        RECORD
    End Enum

    Public Enum ECaptionStyle
        [DEFAULT]
        METALISH
        FLAT
    End Enum

    Public Class CSetting
        Implements ICloneable

        Public Font As Font = Nothing
        Public CaptionFont As Font = Nothing
        Public ForeColor As Color = Color.Empty
        Public FocusForeColor As Color = Color.Empty
        Public FocusRecordForeColor As Color = Color.Empty
        Public CaptionForeColor As Color = Color.Empty
        Public FocusCaptionForeColor As Color = Color.Empty
        Public BackColor As Color = Color.Empty
        Public AlterBackColor As Color = Color.Empty
        Public ButtonBackColor As Color = Color.Empty
        Public CaptionBackColor As Color = Color.Empty
        Public FocusCaptionBackColor As Color = Color.Empty
        Public DraggingBackColor As Color = Color.Empty
        Public DraggingForeColor As Color = Color.Empty
        Public FocusBackColor As Color = Color.Empty
        Public FocusRecordBackColor As Color = Color.Empty
        Public HorizontalAlignment As EHAlign = EHAlign.DEFAULT
        Public VerticalAlignment As EVAlign = EVAlign.DEFAULT
        Public Editable As EAllow = EAllow.DEFAULT
        Public TabStop As ETabStop = ETabStop.DEFAULT
        Public TextWrap As ETextWrap = ETextWrap.DEFAULT
        Public CaptionStyle As ECaptionStyle = ECaptionStyle.DEFAULT

        Public WriteOnly Property BackColorBoth() As Color
            Set(ByVal value As Color)
                Me.BackColor = value
                Me.AlterBackColor = value
            End Set
        End Property

        Public Function Clone() As Object Implements System.ICloneable.Clone
            Dim s As New CSetting
            s.Font = Me.Font
            s.CaptionFont = Me.CaptionFont
            s.ForeColor = Me.ForeColor
            s.FocusForeColor = Me.FocusForeColor
            s.FocusRecordForeColor = Me.FocusRecordForeColor
            s.CaptionForeColor = Me.CaptionForeColor
            s.FocusCaptionForeColor = Me.FocusCaptionForeColor
            s.BackColor = Me.BackColor
            s.AlterBackColor = Me.AlterBackColor
            s.ButtonBackColor = Me.ButtonBackColor
            s.CaptionBackColor = Me.CaptionBackColor
            s.FocusCaptionBackColor = Me.FocusCaptionBackColor
            s.DraggingBackColor = Me.DraggingBackColor
            s.DraggingForeColor = Me.DraggingBackColor
            s.FocusBackColor = Me.FocusBackColor
            s.FocusRecordBackColor = Me.FocusRecordBackColor
            s.HorizontalAlignment = Me.HorizontalAlignment
            s.VerticalAlignment = Me.VerticalAlignment
            s.Editable = Me.Editable
            s.TabStop = Me.TabStop
            s.TextWrap = Me.TextWrap
            s.CaptionStyle = Me.CaptionStyle
            Return s
        End Function

    End Class

    Public Class CGlobalSetting
        Public HeaderContentBackColor As Color = Color.DarkGray
        Public FooterContentBackColor As Color = Color.DarkGray
        Public ContentBackColor As Color = Color.DimGray
        Public ResizingLineColor As Color = Color.DarkGreen
        Public Font As Font = SystemFonts.DefaultFont
        Public CaptionFont As Font = SystemFonts.DefaultFont
        Public ForeColor As Color = Color.Black
        Public BackColor As Color = Color.White
        Public AlterBackColor As Color = Color.Beige
        Public ButtonBackColor As Color = Color.LightGray
        Public FocusForeColor As Color = Color.Transparent
        Public FocusBackColor As Color = Color.LightCyan
        Public FocusRecordForeColor As Color = Color.Transparent
        Public FocusRecordBackColor As Color = Color.PeachPuff
        Public CaptionForeColor As Color = Color.Black
        Public CaptionBackColor As Color = Color.Silver
        Public FocusCaptionForeColor As Color = Color.Transparent
        Public FocusCaptionBackColor As Color = Color.CornflowerBlue
        Public DraggingForeColor As Color = Color.Transparent
        Public DraggingBackColor As Color = Color.CornflowerBlue
        Public BorderColor As Color = Color.Gray
        Public BorderStyle As Drawing2D.DashStyle = Drawing2D.DashStyle.Dot
        Public RecordBorderColor As Color = Color.Gray
        Public RecordBorderStyle As Drawing2D.DashStyle = Drawing2D.DashStyle.Solid
        Public FixedColBorderColor As Color = Color.DimGray
        Public FixedColBorderStyle As Drawing2D.DashStyle = Drawing2D.DashStyle.Solid
        Public CaptionBorderColor As Color = Color.Gray
        Public HorizontalAlignment As EHAlign = EHAlign.LEFT
        Public VerticalAlignment As EVAlign = EVAlign.MIDDLE
        Public Editable As EAllow = EAllow.ALLOW
        Public UserColAdjustable As EAllow = EAllow.ALLOW
        Public UserColResizable As EAllow = EAllow.ALLOW
        Public UserSortable As EAllow = EAllow.DISABLE
        Public TextWrap As ETextWrap = ETextWrap.NOWRAP
        Public CaptionStyle As ECaptionStyle = ECaptionStyle.METALISH
        Public ScrollUnit As EScrollUnit = EScrollUnit.FIELD
        Public AutoFocus As Boolean = True        
        Public FocusColorAlways As Boolean = True
    End Class

    Public Class CDynamicSetting
        Public GlobalSetting As CGlobalSetting
        Public Settings As New List(Of UTable.CSetting)

        Public Sub New(ByVal field As CField)
            If field.HasSetting Then
                Settings.Add(field.Setting)
            End If
            If field.Record.HasSetting Then
                Settings.Add(field.Record.Setting)
            End If
            If field.Desc.HasSetting Then
                Settings.Add(field.Desc.Setting)
            End If
            If field.Content.HasSetting Then
                Settings.Add(field.Content.Setting)
            End If
            If field.Content.RecordProvider IsNot Nothing AndAlso _
               field.Content.RecordProvider.HasSetting Then
                Settings.Add(field.Content.RecordProvider.Setting)
            End If
            Me.GlobalSetting = field.Table.Setting
        End Sub

        Public Function Font() As Font
            For Each s As CSetting In Me.Settings
                If s.Font IsNot Nothing Then
                    Return s.Font
                End If
            Next
            Return Me.GlobalSetting.Font
        End Function

        Public Function CaptionFont() As Font
            For Each s As CSetting In Me.Settings
                If s.CaptionFont IsNot Nothing Then
                    Return s.CaptionFont
                End If
            Next
            Return Me.GlobalSetting.CaptionFont
        End Function

        Public Function ForeColor() As Color
            For Each s As CSetting In Me.Settings
                If s.ForeColor <> Color.Empty Then
                    Return s.ForeColor
                End If
            Next
            Return Me.GlobalSetting.ForeColor
        End Function

        Public Function FocusForeColor() As Color
            For Each s As CSetting In Me.Settings
                If s.FocusForeColor <> Color.Empty Then
                    Return s.FocusForeColor
                End If
            Next
            Return Me.GlobalSetting.FocusForeColor
        End Function

        Public Function FocusRecordForeColor() As Color
            For Each s As CSetting In Me.Settings
                If s.FocusRecordForeColor <> Color.Empty Then
                    Return s.FocusRecordForeColor
                End If
            Next
            Return Me.GlobalSetting.FocusRecordForeColor
        End Function

        Public Function CaptionForeColor() As Color
            For Each s As CSetting In Me.Settings
                If s.CaptionForeColor <> Color.Empty Then
                    Return s.CaptionForeColor
                End If
            Next
            Return Me.GlobalSetting.CaptionForeColor
        End Function

        Public Function FocusCaptionForeColor() As Color
            For Each s As CSetting In Me.Settings
                If s.FocusCaptionForeColor <> Color.Empty Then
                    Return s.FocusCaptionForeColor
                End If
            Next
            Return Me.GlobalSetting.FocusCaptionForeColor
        End Function

        Public Function BackColor() As Color
            For Each s As CSetting In Me.Settings
                If s.BackColor <> Color.Empty Then
                    Return s.BackColor
                End If
            Next
            Return Me.GlobalSetting.BackColor
        End Function

        Public Function AlterBackColor() As Color
            For Each s As CSetting In Me.Settings
                If s.AlterBackColor <> Color.Empty Then
                    Return s.AlterBackColor
                End If
            Next
            Return Me.GlobalSetting.AlterBackColor
        End Function

        Public Function ButtonBackColor() As Color
            For Each s As CSetting In Me.Settings
                If s.ButtonBackColor <> Color.Empty Then
                    Return s.ButtonBackColor
                End If
            Next
            Return Me.GlobalSetting.ButtonBackColor
        End Function

        Public Function CaptionBackColor() As Color
            For Each s As CSetting In Me.Settings
                If s.CaptionBackColor <> Color.Empty Then
                    Return s.CaptionBackColor
                End If
            Next
            Return Me.GlobalSetting.CaptionBackColor
        End Function

        Public Function FocusCaptionBackColor() As Color
            For Each s As CSetting In Me.Settings
                If s.FocusCaptionBackColor <> Color.Empty Then
                    Return s.FocusCaptionBackColor
                End If
            Next
            Return Me.GlobalSetting.FocusCaptionBackColor
        End Function

        Public Function DraggingBackColor() As Color
            For Each s As CSetting In Me.Settings
                If s.DraggingBackColor <> Color.Empty Then
                    Return s.DraggingBackColor
                End If
            Next
            Return Me.GlobalSetting.DraggingBackColor
        End Function

        Public Function DraggingForeColor() As Color
            For Each s As CSetting In Me.Settings
                If s.DraggingBackColor <> Color.Empty Then
                    Return s.DraggingForeColor
                End If
            Next
            Return Me.GlobalSetting.DraggingForeColor
        End Function

        Public Function FocusBackColor() As Color
            For Each s As CSetting In Me.Settings
                If s.FocusBackColor <> Color.Empty Then
                    Return s.FocusBackColor
                End If
            Next
            Return Me.GlobalSetting.FocusBackColor
        End Function

        Public Function FocusRecordBackColor() As Color
            For Each s As CSetting In Me.Settings
                If s.FocusRecordBackColor <> Color.Empty Then
                    Return s.FocusRecordBackColor
                End If
            Next
            Return Me.GlobalSetting.FocusRecordBackColor
        End Function

        Public Function HorizontalAlignment() As EHAlign
            For Each s As CSetting In Me.Settings
                If s.HorizontalAlignment <> EHAlign.DEFAULT Then
                    Return s.HorizontalAlignment
                End If
            Next
            Return Me.GlobalSetting.HorizontalAlignment
        End Function

        Public Function VerticalAlignment() As EVAlign
            For Each s As CSetting In Me.Settings
                If s.VerticalAlignment <> EVAlign.DEFAULT Then
                    Return s.VerticalAlignment
                End If
            Next
            Return Me.GlobalSetting.VerticalAlignment
        End Function

        Public Function Editable() As EAllow
            For Each s As CSetting In Me.Settings
                If s.Editable <> EAllow.DEFAULT Then
                    Return s.Editable
                End If
            Next
            Return Me.GlobalSetting.Editable
        End Function

        Public Function TabStop() As ETabStop
            For Each s As CSetting In Me.Settings
                If s.TabStop <> ETabStop.DEFAULT Then
                    Return s.TabStop
                End If
            Next
            Return ETabStop.STOP
        End Function

        Public Function TextWrap() As ETextWrap
            For Each s As CSetting In Me.Settings
                If s.TextWrap <> ETextWrap.DEFAULT Then
                    Return s.TextWrap
                End If
            Next
            Return Me.GlobalSetting.TextWrap
        End Function

        Public Function CaptionStyle() As ECaptionStyle
            For Each s As CSetting In Me.Settings
                If s.CaptionStyle <> ECaptionStyle.DEFAULT Then
                    Return s.CaptionStyle
                End If
            Next
            Return Me.GlobalSetting.CaptionStyle
        End Function

        Public Function GetStringFormat() As StringFormat
            Dim format As New StringFormat
            If Me.TextWrap = ETextWrap.NOWRAP Then
                format.FormatFlags = StringFormatFlags.NoWrap
            End If
            Select Case Me.HorizontalAlignment
                Case EHAlign.LEFT
                    format.Alignment = StringAlignment.Near
                Case EHAlign.MIDDLE
                    format.Alignment = StringAlignment.Center
                Case EHAlign.RIGHT
                    format.Alignment = StringAlignment.Far
            End Select
            Select Case Me.VerticalAlignment
                Case EVAlign.TOP
                    format.LineAlignment = StringAlignment.Near
                Case EVAlign.MIDDLE
                    format.LineAlignment = StringAlignment.Center
                Case EVAlign.BOTTOM
                    format.LineAlignment = StringAlignment.Far
            End Select
            Return format
        End Function

    End Class

End Class