' table/Adjust.vb
'
' Copyright (c) 2008-2009, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Partial Class UTable

    Partial Class CField

        Public Function GetAdjustSize() As CGrid.CSize
            With Me.Desc.Layout
                Return Me.getAdjustSize(New CGrid.CPoint(.Row + .Rows - 1, .Col + .Cols - 1))
            End With
        End Function

        Public Function GetAdjustSize(ByVal point As CGrid.CPoint) As CGrid.CSize
            If Me.Table.BackBuffer Is Nothing Then
                Return New CGrid.CSize
            End If
            With Me.Desc
                Dim entireSize As Size = .Provider.GetAdjustSize(Me.Table.BackBuffer.Graphics, Me)
                Return New CGrid.CSize(Me.Record.Rows.GetSizeByEntireSize(.Layout.Row, .Layout.Rows, point.Row, entireSize.Height), _
                                       Me.Table.Cols.GetSizeByEntireSize(.Layout.Col, .Layout.Cols, point.Col, entireSize.Width))
            End With
        End Function

        Private Sub extend_on_setValue()
            If Me.Desc.Layout IsNot Nothing And _
               (Me.Table.AutoExtend.Col Or Me.Table.AutoExtend.Row) Then
                With Me.getAdjustSize
                    If Me.Table.AutoExtend.Row Then
                        Dim r As CGrid = Me.BottomRow
                        If r IsNot Nothing Then
                            If r.Size < .Row Then
                                r.Size = .Row
                                Me.TopLevelContent.LayoutCacheInvalid = True
                            End If
                        End If
                    End If
                    If Me.Table.AutoExtend.Col Then
                        Dim c As CGrid = Me.RightCol
                        If c IsNot Nothing Then
                            If c.Size < .Col Then
                                c.Size = .Col
                                Me.Table.LayoutCacheInvalid = True
                            End If
                        End If
                    End If
                End With
            End If
        End Sub

    End Class

    Public Sub AdjustSize()
        Using Me.RenderBlock
            For i As Integer = 0 To Me.Cols.Count - 1
                Me.AdjustSize(i)
            Next
        End Using
    End Sub

    Public Sub AdjustSize(ByVal col As Integer)
        Using Me.RenderBlock
            Dim size As Integer = 1
            Dim t As Integer
            t = Me.getAdjustColSize(col, Me.HeaderContent)
            If t > size Then
                size = t
            End If
            t = Me.getAdjustColSize(col, Me.Content)
            If t > size Then
                size = t
            End If
            t = Me.getAdjustColSize(col, Me.FooterContent)
            If t > size Then
                size = t
            End If
            Me.Cols(col).Size = size
        End Using
    End Sub

    Private Function getAdjustColSize(ByVal col As Integer, ByVal content As CContent) As Integer
        Dim ret As Integer = 0
        Me.UpdateLayout()
        For Each record As CRecord In content.Records
            If record.LayoutCache.Visible Then
                For row As Integer = 0 To record.Rows.Count - 1
                    Dim f As CField = record.FindField(row, col)
                    If f IsNot Nothing Then
                        Dim t As Integer = f.GetAdjustSize(New CGrid.CPoint(row, col)).Col
                        If t > ret Then
                            ret = t
                        End If
                    End If
                Next
                If record.Child IsNot Nothing Then
                    Dim t As Integer = Me.getAdjustColSize(col, record.Child)
                    If t > ret Then
                        ret = t
                    End If
                End If
            End If
        Next
        Return ret
    End Function

End Class
