' table/Content.vb
'
' Copyright (c) 2008-2009, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Partial Class UTable

    Public Class CContent

        Public Class CLayoutCache
            Public RowsSize As Integer
            Public TopRecord As CRecord
            Public LastRecord As CRecord
            Public VisibleRows As List(Of CGrid)
            Public VisibleRowsPos As List(Of Integer)
        End Class

        Public RecordProvider As CRecordProvider
        Public Records As New List(Of CRecord)
        Public ParentRecord As CRecord = Nothing
        Public Table As UTable
        Public LayoutCacheInvalid As Boolean = False
        Public LayoutCache As New CLayoutCache
        Public LastAddedRecord As CRecord = Nothing
        Public Enabled As Boolean = True
        Public MaxRecordCount As Integer = 0

        Private _Setting As UTable.CSetting = Nothing
        Private _Visible As Boolean = True

        Public Function TopLevelContent() As CContent
            Dim c As CContent = Me
            Do While c.ParentRecord IsNot Nothing
                c = c.ParentRecord.Content
            Loop
            Return c
        End Function

        Public Function TopLevelRecord() As CRecord
            If Me.ParentRecord IsNot Nothing Then
                Dim r As CRecord = Me.ParentRecord
                Do While r.Content.ParentRecord IsNot Nothing
                    r = r.Content.ParentRecord
                Loop
                Return r
            Else
                Return Nothing
            End If
        End Function

        Public Function Level() As Integer
            Dim c As CContent = Me
            Dim i As Integer = 0
            Do While c.ParentRecord IsNot Nothing
                c = c.ParentRecord.Content
                i += 1
            Loop
            Return i
        End Function

        Public Function HasSetting() As Boolean
            Return Me._Setting IsNot Nothing
        End Function

        Public Sub ClearSetting()
            Me.Setting = Nothing
        End Sub

        Public Property Setting() As UTable.CSetting
            Get
                If Me._Setting Is Nothing Then
                    Me._Setting = New UTable.CSetting
                End If
                Return Me._Setting
            End Get
            Set(ByVal value As UTable.CSetting)
                Me._Setting = value
            End Set
        End Property

        Public Property Visible() As Boolean
            Get
                Return Me._Visible
            End Get
            Set(ByVal value As Boolean)
                Using Me.Table.RenderBlock
                    Me.focusEscape()
                    Me._Visible = value
                    Me.TopLevelContent.LayoutCacheInvalid = True
                End Using
            End Set
        End Property

        Public Sub SetRecordProvider(ByVal recordProvider As CRecordProvider)
            Me.RecordProvider = recordProvider
            Me.MaxRecordCount = recordProvider.MaxRecordCount
            Me.Table.prepareCols(Me.RecordProvider.ColsCount)
        End Sub

        Public Function CreateRecord() As CRecord
            Return Me.CreateRecord(Me.RecordProvider)
        End Function

        Public Function CreateRecord(ByVal recordProvider As CRecordProvider) As CRecord
            Return New CRecord(Me, recordProvider)
        End Function

        Public Function AddRecord() As CRecord
            Return Me.AddRecord(Me.RecordProvider)
        End Function

        Public Function AddRecord(ByVal recordProvider As CRecordProvider) As CRecord
            Return Me.AddRecord(Me.CreateRecord(recordProvider))
        End Function

        Public Function AddRecord(ByVal record As CRecord) As CRecord
            If Me.MaxRecordCount = 0 OrElse _
               Me.Records.Count < Me.MaxRecordCount Then
                Using Me.Table.RenderBlock
                    Me.Records.Add(record)
                    Me._afterAddRecord(record)
                    Return record
                End Using
                Return record
            End If
            Return Nothing
        End Function

        Public Function InsertRecord(ByVal i As Integer) As CRecord
            Return Me.InsertRecord(i, Me.RecordProvider)
        End Function

        Public Function InsertRecord(ByVal i As Integer, ByVal recordProvider As CRecordProvider) As CRecord
            Return Me.InsertRecord(i, Me.CreateRecord(recordProvider))
        End Function

        Public Function InsertRecord(ByVal i As Integer, ByVal record As CRecord) As CRecord
            Using Me.Table.RenderBlock                
                Me.Records.Insert(i, record)
                Me._afterAddRecord(record)
                Return record
            End Using
        End Function

        Private Sub _afterAddRecord(ByVal record As CRecord)
            Me.TopLevelContent.LayoutCacheInvalid = True
            Me.Table.raiseRecordAdded(record)
            Me.LastAddedRecord = record
        End Sub

        Public Sub RemoveRecord(ByVal record As CRecord)
            Using Me.Table.RenderBlock
                Me._beforeRemoveRecord(record)
                Me.Records.Remove(record)
                Me._afterRemoveRecord(record)
            End Using
        End Sub

        Public Sub RemoveRecord(ByVal i As Integer)
            Using Me.Table.RenderBlock
                Dim r As CRecord = Me.Records(i)
                Me._beforeRemoveRecord(r)
                Me.Records.RemoveAt(i)
                Me._afterRemoveRecord(r)
            End Using
        End Sub

        Private Sub _beforeRemoveRecord(ByVal record As CRecord)
            If Me.Table.Editor IsNot Nothing Then
                Me.Table.FinishEdit()
            End If
            record.focusEscape()
        End Sub

        Private Sub _afterRemoveRecord(ByVal record As CRecord)
            Me.TopLevelContent.LayoutCacheInvalid = True
            Me.Table.raiseRecordRemoved(record)
        End Sub

        Friend Sub render(ByVal g As Graphics, _
                          ByVal top_row As Integer, _
                          ByVal top_col As Integer, _
                          ByVal max_row As Integer, _
                          ByVal fixed As Boolean)
            Dim alter As Boolean = False
            Dim r As CRecord = Me.LayoutCache.TopRecord
            Dim lastContent As CContent = Nothing
            Dim verticalMerge As CVerticalMerge = Nothing
            Dim border As CBorder = Nothing
            Do While r IsNot Nothing
                If r.Content IsNot lastContent Then
                    alter = False
                    verticalMerge = New CVerticalMerge(r.Content)
                End If
                verticalMerge.Update(r, alter)
                Dim _top_row As Integer = r.LayoutCache.Top + top_row
                If _top_row > max_row Then
                    Exit Do
                End If
                lastContent = r.Content
                If _top_row + r.LayoutCache.RowsSize > 0 Then
                    border = New CBorder(r, border)
                    r.render(g, top_row, top_col, alter, fixed, border, verticalMerge)
                    border.Render(r, g, top_row, top_col, fixed)
                End If
                alter = Not alter
                r = r.LayoutCache.NextRecord
            Loop
        End Sub

        Friend Function updateLayoutCache() As CRecord
            Return Me.updateLayoutCache(0, Nothing, True, 0)
        End Function

        Friend Function updateLayoutCache(ByRef top As Integer, ByRef prevRecord As CRecord, ByVal visible As Boolean, ByRef height As Integer) As CRecord
            Me.LayoutCache.RowsSize = 0
            Me.LayoutCache.TopRecord = Nothing
            Me.LayoutCache.LastRecord = Nothing
            Me.LayoutCache.VisibleRows = New List(Of CGrid)
            Me.LayoutCache.VisibleRowsPos = New List(Of Integer)
            Dim v As Boolean = visible AndAlso Me.Visible
            Dim i As Integer = 0
            For Each record As CRecord In Me.Records
                record.updateCache(top, prevRecord, v, i, height)
                Me.LayoutCache.RowsSize += record.LayoutCache.EntireRowsSize
                i += 1
            Next
            Return prevRecord
        End Function

        Public Function Col(ByVal key As Object) As CGrid
            Return Me.Table.Cols(Me.RecordProvider.FieldDescs(key).Layout.RightCol)
        End Function

        Public Function ParentContent() As CContent
            If Me.ParentRecord IsNot Nothing Then
                Return Me.ParentRecord.Content
            Else
                Return Nothing
            End If
        End Function

        Public Sub ClearRecord()
            Using Me.Table.RenderBlock
                If Me.Table.Editor IsNot Nothing Then
                    Me.Table.FinishEdit()
                End If
                If Me.Table.FocusField IsNot Nothing AndAlso Me.IsChild(Me.Table.FocusField) Then
                    Me.Table.FocusField = Nothing
                End If
                Me.LastAddedRecord = Nothing
                Me.Records.Clear()
                If Me.Table.Content Is Me Then
                    Me.Table.SortState.Field = Nothing
                End If
                Me.TopLevelContent.LayoutCacheInvalid = True
            End Using
        End Sub

        Public Sub MoveRecord(ByVal i1 As Integer, ByVal i2 As Integer)
            Me.MoveRecord(Me.Records(i1), i2)
        End Sub

        Public Sub MoveRecord(ByVal r As CRecord, ByVal i As Integer)
            Using Me.Table.RenderBlock
                If i < Me.Records.Count Then
                    Me.Records.Remove(r)
                    Me.Records.Insert(i, r)
                Else
                    Me.Records.Remove(r)
                    Me.Records.Add(r)
                End If
                Me.TopLevelContent.LayoutCacheInvalid = True
                Me.Table.raiseRecordMoved(r)
            End Using
        End Sub

        Public Function IsChild(ByVal field As CField) As Boolean
            If field.Content Is Me Then
                Return True
            Else
                Return Me.IsChild(field.Record)
            End If
        End Function

        Public Function IsChild(ByVal record As CRecord) As Boolean
            If record.Content Is Me Then
                Return True
            Else
                Return Me.IsChild(record.Content)
            End If
        End Function

        Public Function IsChild(ByVal content As CContent) As Boolean
            Dim parent As CContent = content.ParentContent
            Do While parent IsNot Nothing
                If parent Is Me Then
                    Return True
                End If
                parent = parent.ParentContent
            Loop
            Return False
        End Function

        Public Sub Sort(ByVal key As Object)
            Me.Sort(key, CSortState.EOrder.ASCEND)
        End Sub

        Public Sub Sort(ByVal key As Object, ByVal Order As CSortState.EOrder)
            Dim comparer As CComparer = Me.Table.Comparer
            If Me.RecordProvider IsNot Nothing AndAlso _
               Me.RecordProvider.FieldDescs.ContainsKey(key) AndAlso _
               Me.RecordProvider.FieldDescs(key).Comparer IsNot Nothing Then
                comparer = Me.RecordProvider.FieldDescs(key).Comparer
            End If
            Me.Sort(key, Order, comparer)
        End Sub

        Public Sub Sort(ByVal key As Object, ByVal Order As CSortState.EOrder, ByVal comparer As CComparer)
            Dim _l As New List(Of Integer)(Me.Records.Count)
            For i As Integer = 0 To Me.Records.Count - 1
                _l.Add(i)
            Next
            comparer.Init(Me.Records, key, Order)
            _l.Sort(comparer)
            Using Me.Table.RenderBlock
                Dim records_bak As List(Of CRecord) = Me.Records
                Me.Records = New List(Of CRecord)
                For i As Integer = 0 To _l.Count - 1
                    Me.Records.Add(records_bak(_l(i)))
                Next
                Me.LayoutCacheInvalid = True
                Me.Table.raiseSorted(Me, key)
                Me.TopLevelContent.LayoutCacheInvalid = True
            End Using
        End Sub

        Public Function DefaultField() As CField
            Dim r As CRecord = Me.LayoutCache.TopRecord
            Do While r IsNot Nothing
                Dim f As CField = r.DefaultField
                If f IsNot Nothing Then
                    Return f
                End If
                r = r.LayoutCache.NextRecord
            Loop
            Return Nothing
        End Function

        Public Function LastField() As CField
            Dim r As CRecord = Me.LayoutCache.LastRecord
            If r IsNot Nothing Then
                Do While r.Child IsNot Nothing AndAlso r.Child.LayoutCache.LastRecord IsNot Nothing
                    r = r.Child.LayoutCache.LastRecord
                Loop
                Do While r IsNot Nothing
                    Dim f As CField = r.LastField
                    If f IsNot Nothing Then
                        Return f
                    End If
                    r = r.LayoutCache.PrevRecord
                Loop
            End If
            Return Nothing
        End Function

        Friend Sub focusEscape()
            If Me.Table.FocusField IsNot Nothing AndAlso Me.IsChild(Me.Table.FocusField) Then
                If Me.ParentRecord IsNot Nothing Then
                    Dim f As CField = Me.ParentRecord.DefaultField
                    If f IsNot Nothing Then
                        Me.Table.FocusField = f
                        Exit Sub
                    End If
                End If
                Me.Table.FocusField = Nothing
            End If
        End Sub

        Public Sub Clear()
            Me.Clear(True)
        End Sub

        Public Sub Clear(ByVal recursive As Boolean)
            Using Me.Table.RenderBlock
                For Each r As CRecord In Me.Records
                    r.Clear(recursive)
                Next
            End Using
        End Sub

    End Class

    Public Enum ECompareNullRule
        ASCEND
        DESCEND
        ASCEND_ALWAYS
        DESCEND_ALWAYS
    End Enum

    Public Class CComparer
        Implements IComparer(Of Integer)
        Public NullRule As ECompareNullRule = ECompareNullRule.ASCEND
        Protected records As List(Of CRecord)
        Protected key As Object
        Protected order As CSortState.EOrder
        Public Sub Init(ByVal records As System.Collections.Generic.List(Of CRecord), ByVal key As Object, ByVal order As CSortState.EOrder)
            Me.records = records
            Me.key = key
            Me.order = order
        End Sub
        Public Overridable Function Compare(ByVal x As Integer, ByVal y As Integer) As Integer Implements System.Collections.Generic.IComparer(Of Integer).Compare
            Dim valX As Object = records(x).Fields(key).Value
            Dim valY As Object = records(y).Fields(key).Value
            If TypeOf valX Is String AndAlso String.IsNullOrEmpty(valX) Then
                valX = Nothing
            End If
            If TypeOf valY Is String AndAlso String.IsNullOrEmpty(valY) Then
                valY = Nothing
            End If
            If valX = valY Then
                Return x < y
            ElseIf valX Is Nothing And valY IsNot Nothing Then
                Return Me.nullResult
            ElseIf valX IsNot Nothing And valY Is Nothing Then
                Return Not Me.nullResult
            ElseIf TypeOf valX Is String Then
                Select Case order
                    Case CSortState.EOrder.ASCEND
                        Return CType(valX, String).CompareTo(valY)
                    Case CSortState.EOrder.DESCEND
                        Return -CType(valX, String).CompareTo(valY)
                End Select
            Else
                Select Case order
                    Case CSortState.EOrder.ASCEND
                        Return valX < valY
                    Case CSortState.EOrder.DESCEND
                        Return valX > valY
                End Select
            End If
        End Function
        Private Function nullResult() As Boolean
            Select Case Me.NullRule
                Case ECompareNullRule.ASCEND
                    Select Case order
                        Case CSortState.EOrder.ASCEND
                            Return True
                        Case CSortState.EOrder.DESCEND
                            Return False
                    End Select
                Case ECompareNullRule.DESCEND
                    Select Case order
                        Case CSortState.EOrder.ASCEND
                            Return False
                        Case CSortState.EOrder.DESCEND
                            Return True
                    End Select
                Case ECompareNullRule.ASCEND_ALWAYS
                    Return True
                Case ECompareNullRule.DESCEND_ALWAYS
                    Return False
            End Select
        End Function
    End Class

    Class CVerticalMerge
        Class CVerticalMergeEntry
            Public TopField As CField = Nothing
            Public TopAlter As Boolean
            Public BottomField As CField = Nothing
            Public DispField As CField = Nothing
            Public Rendered As Boolean = False
            Public Sub init(ByVal field As CField, ByVal alter As Boolean)
                Me.TopField = field
                Me.TopAlter = alter
                Me.BottomField = field
                Me.DispField = field
                Me.Rendered = False
            End Sub
        End Class
        Class CTranslateResult
            Public Field As CField
            Public Rect As Rectangle
            Public Alter As Boolean
            Public Merged As Boolean
            Public Sub New(ByVal field As CField, ByVal rect As Rectangle, ByVal alter As Boolean, ByVal merged As Boolean)
                Me.Field = field
                Me.Rect = rect
                Me.Alter = alter
                Me.Merged = merged
            End Sub
        End Class
        Public Content As CContent
        Public Fields As New Dictionary(Of Object, CVerticalMergeEntry)
        Public Sub New(ByVal content As CContent)
            Me.Content = content
            If Me.Content.RecordProvider IsNot Nothing Then
                For Each k As Object In Me.Content.RecordProvider.FieldDescs.Keys
                    If Me.Content.RecordProvider.FieldDescs(k).VerticalMerge Then
                        Me.Fields.Add(k, New CVerticalMergeEntry)
                    End If
                Next
            End If
        End Sub
        Public Sub Update(ByVal record As CRecord, ByVal alter As Boolean)
            For Each k As Object In Me.Fields.Keys
                Dim field As CField = record.Fields(k)
                With Me.Fields(k)
                    If .TopField Is Nothing OrElse _
                       field.Value Is Nothing OrElse _
                       Not field.Value.Equals(.TopField.Value) Then
                        .init(field, alter)
                        If field.Value IsNot Nothing Then
                            Dim f As CField = field
                            Do While f IsNot Nothing AndAlso field.Value.Equals(f.Value)
                                If f.Table.FocusRecord Is f.Record Then
                                    .DispField = f
                                End If
                                .BottomField = f
                                f = nextField(f)
                            Loop
                        End If
                    End If
                End With
            Next
        End Sub
        Public Function Translate(ByVal field As CField, _
                                  ByVal rect As Rectangle, _
                                  ByVal alter As Boolean, _
                                  ByVal top_row As Integer, _
                                  ByVal top_col As Integer) As CTranslateResult
            If Me.Fields.ContainsKey(field.Key) Then
                With Me.Fields(field.Key)
                    If Not .Rendered Then
                        .Rendered = True
                        Return New CTranslateResult(.DispField, _
                                                    Rectangle.Union(.TopField.GetRectangle(top_row + .TopField.Record.LayoutCache.Top, top_col), _
                                                                    .BottomField.GetRectangle(top_row + .BottomField.Record.LayoutCache.Top, top_col)), _
                                                    .TopAlter, _
                                                    field IsNot .BottomField)
                    Else
                        Return New CTranslateResult(field, New Rectangle(0, 0, 0, 0), alter, field IsNot .BottomField)
                    End If
                End With
            Else
                Return New CTranslateResult(field, rect, alter, False)
            End If
        End Function
        Private Function nextField(ByVal field As CField) As CField
            If field.Record.LayoutCache.NextRecord Is Nothing Then
                Return Nothing
            End If
            Dim nextRecord As CRecord = field.Record.LayoutCache.NextRecord
            If field.Content IsNot nextRecord.Content OrElse _
               Not nextRecord.Fields.ContainsKey(field.Key) Then
                Return Nothing
            End If
            Return nextRecord.Fields(field.Key)
        End Function
    End Class

End Class
