﻿' table/FieldProvider/CaptionFieldProvider.vb
'
' Copyright (c) 2008-2009, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Public Class CCaptionFieldProvider
    Inherits CFieldProvider

    Private _Setting As UTable.CSetting = Nothing
    Private draggingRecord As UTable.CRecord = Nothing
    Private WithEvents table As UTable

    Public UserSortable As UTable.EAllow = UTable.EAllow.DEFAULT
    Public Draggable As Boolean

    Public Class CCaptionField
        Inherits UTable.CField
        Public Overrides Sub Clear()
        End Sub
    End Class

    Public Sub New()
        Me.New(Nothing, False)
    End Sub

    Public Sub New(ByVal caption As String)
        Me.New(caption, False)
    End Sub

    Public Sub New(ByVal caption As String, ByVal draggable As Boolean)
        MyBase.New(caption)
        Me.Draggable = draggable
    End Sub

    Friend Sub New(ByVal fieldDesc As UTable.CRecordProvider.CFieldDesc)
        Me.New(fieldDesc.Provider.Caption)
        Me.UserSortable = fieldDesc.UserSortable
        If TypeOf fieldDesc.Provider Is CFieldProvider Then
            Me.BorderLine = CType(fieldDesc.Provider, CFieldProvider).BorderLine
        End If
        If fieldDesc.HasSetting Then
            Me._Setting = fieldDesc.Setting.Clone
        End If
    End Sub

    Public Overrides Function CreateField() As UTable.CField
        Return New CCaptionField
    End Function

    Public Overrides Function Setting() As UTable.CSetting
        Return Me._Setting
    End Function

    Public Overrides Sub FieldInitialize(ByVal field As UTable.CField)
        Me.table = field.Table
        field.Value = Me.Caption
        AddHandler field.DoubleClick, AddressOf Me._DoubleClick
    End Sub

    Public Overrides Function CreateEditor() As IEditor
        Return Nothing
    End Function

    Protected Overrides Sub renderBackground(ByVal g As Graphics, ByVal field As UTable.CField, ByVal s As UTable.CDynamicSetting, ByVal rect As System.Drawing.Rectangle, ByVal alter As Boolean)
        Dim drag As Boolean = field.Record Is Me.draggingRecord
        RenderCaptionBackgroudRect(g, rect, CaptionBackColor(field, s, drag), s.CaptionStyle)
    End Sub

    Protected Overrides Sub renderForeground(ByVal g As Graphics, ByVal field As UTable.CField, ByVal s As UTable.CDynamicSetting, ByVal rect As System.Drawing.Rectangle, ByVal alter As Boolean)
        Dim drag As Boolean = field.Record Is Me.draggingRecord
        RenderCaptionValue(g, field, field.Table.SortState, rect, formatValue(field.Value), CaptionForeColor(field, s, drag), s.CaptionFont, s.GetStringFormat)
    End Sub

    Public Overrides Sub SetBorder(ByVal field As UTable.CField, ByVal border As UTable.CBorder, ByVal merged As Boolean)
        SetCaptionBorder(field, border, merged, Me.BorderLine)
    End Sub

    Private Sub _DoubleClick(ByVal field As UTable.CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
        If field.TopLevelContent Is field.Table.HeaderContent Then
            Dim _sortable As UTable.EAllow = field.Table.Setting.UserSortable
            With CType(field.Desc.Provider, CCaptionFieldProvider)
                If .UserSortable <> UTable.EAllow.DEFAULT Then
                    _sortable = .UserSortable
                End If
            End With
            If _sortable = UTable.EAllow.ALLOW Then
                Using field.Table.RenderBlock
                    Dim _order As UTable.CSortState.EOrder = UTable.CSortState.EOrder.ASCEND
                    If field.Table.SortState.Field Is field And field.Table.SortState.Order = UTable.CSortState.EOrder.ASCEND Then
                        _order = UTable.CSortState.EOrder.DESCEND
                    End If
                    Dim key As Object = field.Key
                    If TypeOf key Is UTable.CCaptionKey Then
                        key = CType(key, UTable.CCaptionKey).key
                    End If
                    field.Table.Content.Sort(key, _order)
                    With field.Table.SortState
                        .Field = field
                        .Order = _order
                    End With
                End Using
            End If
        End If
    End Sub

    Public Overrides Function Focusable() As Boolean
        Return False
    End Function

    Public Overrides Function GetAdjustSize(ByVal g As Graphics, ByVal field As UTable.CField) As Size
        With field.DynamicSetting
            Return g.MeasureString(Me.formatValue(field.Value), .CaptionFont, 100000, .GetStringFormat).ToSize
        End With
    End Function

    Private Sub table_FieldMouseDown(ByVal field As UTable.CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs) Handles table.FieldMouseDown
        If field.Desc.Provider Is Me Then
            If field.TopLevelContent Is field.Table.Content AndAlso _
               Me.Draggable AndAlso _
               e.Button = Windows.Forms.MouseButtons.Left Then
                Me.draggingRecord = field.Record
                field.Table.Render()
            End If
            Using field.Table.RenderBlock
                With field.Table
                    If field.TopLevelContent Is .Content Then
                        If field.Table.Setting.RecordSelectableByCaptionClick Then
                            Dim f As UTable.CField = field.Record.DefaultField
                            If f IsNot Nothing Then
                                table.FocusField = f
                                If field.Table.Setting.UserRangeSelectable Then
                                    .SelectRange = .CreateRange(field.Record)
                                End If
                            End If
                        End If
                    ElseIf field.TopLevelContent Is .HeaderContent Then
                        If field.Table.Setting.ColSelectableByCaptionClick AndAlso _
                           field.Table.Setting.UserRangeSelectable Then
                            Dim r As UTable.CRecord = field.Table.Content.LayoutCache.TopRecord
                            If r IsNot Nothing Then
                                Dim k As Object = field.Key
                                If TypeOf k Is UTable.CCaptionKey Then
                                    k = CType(k, UTable.CCaptionKey).key
                                End If
                                If r.Fields.ContainsKey(k) Then
                                    Dim f As UTable.CField = r.Fields(k)
                                    If f.Focusable Then
                                        table.FocusField = f
                                        If field.Table.Setting.UserRangeSelectable Then
                                            .SelectRange = .CreateRange(.Content, .LayoutCache.VisibleColsRev(field.LeftCol.Index))
                                        End If
                                    End If
                                End If
                            End If
                        End If
                    End If
                End With
            End Using
        End If
    End Sub

    Private Sub table_MouseMove(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles table.MouseMove
        If Me.draggingRecord IsNot Nothing Then
            Dim f As UTable.CRenderCache.CField = Me.table.RenderCache.FindField(e.Location)
            If f IsNot Nothing Then
                Me.recordMove(f.Field)
            End If
        End If
    End Sub

    Private Sub table_DraggingOverflow(ByVal table As UTable, ByVal dx As Integer, ByVal dy As Integer) Handles table.DraggingOverflow
        If Me.draggingRecord IsNot Nothing Then
            If dy <> 0 Then
                table.SetVScrollValue(table.VScrollBar.Value + (table.VScrollBar.SmallChange * dy))
            End If
        End If
    End Sub

    Private Sub recordMove(ByVal field As UTable.CField)
        If Me.draggingRecord.Content Is field.Content AndAlso Me.draggingRecord IsNot field.Record Then
            Using Me.table.RenderBlock
                With Me.draggingRecord.Content
                    Dim i1 As Integer = .Records.IndexOf(Me.draggingRecord)
                    Dim i2 As Integer = .Records.IndexOf(field.Record)
                    If i2 >= 0 AndAlso i1 <> i2 Then
                        .MoveRecord(Me.draggingRecord, i2)
                    End If
                End With
                Me.draggingRecord.TopLevelContent.LayoutCacheInvalid = True
            End Using
        End If
    End Sub

    Private Sub UTable_MouseUp(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles table.MouseUp
        If e.Button = Windows.Forms.MouseButtons.Left Then
            If Me.draggingRecord IsNot Nothing Then
                Me.draggingRecord = Nothing
                CType(sender, UTable).Render()
            End If
        End If
    End Sub

End Class