' table/Record.vb
'
' Copyright (c) 2008-2009, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Partial Class UTable

    Public Class CRecord

        Public Event Added(ByVal record As CRecord)
        Public Event Moved(ByVal record As CRecord)
        Public Event Removed(ByVal record As CRecord)
        Public Event Enter(ByVal record As CRecord)

        Public Class CLayoutCache
            Public Index As Integer
            Public Visible As Boolean
            Public Top As Integer
            Public RowsSize As Integer
            Public EntireRowsSize As Integer
            Public PrevRecord As CRecord
            Public NextRecord As CRecord
            Public VisibleRowsRev As List(Of Integer)
        End Class

        Public Rows As New CGrids
        Public Fields As New Dictionary(Of Object, CField)
        Public Content As CContent
        Public Child As CContent
        Public LayoutCache As New CLayoutCache

        Private _Setting As UTable.CSetting = Nothing
        Private _BorderSetting As UTable.CBorderSetting = Nothing
        Private _Visible As Boolean = True

        Friend Sub New(ByVal content As CContent, ByVal recordProvider As CRecordProvider)
            Using content.Table.RenderBlock
                Me.Content = content
                If recordProvider IsNot Nothing Then
                    With recordProvider
                        Me.Rows.AddRange(New CGrids(.Rows, Me))
                        For Each key As Object In .FieldDescs.Keys
                            Me._addField(key, .FieldDescs(key))
                        Next
                        For Each key As Object In .FieldDescs.Keys
                            Me.Fields(key).Desc.Provider.FieldInitialize(Me.Fields(key))
                        Next
                        If .ChildRecordProvider IsNot Nothing Then
                            Me.CreateChild(.ChildRecordProvider)
                        End If
                    End With
                End If
            End Using
        End Sub

        Public Function HasSetting() As Boolean
            Return Me._Setting IsNot Nothing
        End Function

        Public Sub ClearSetting()
            Me.Setting = Nothing
        End Sub

        Public Property Setting() As UTable.CSetting
            Get
                If Me._Setting Is Nothing Then
                    Me._Setting = New UTable.CSetting
                End If
                Return Me._Setting
            End Get
            Set(ByVal value As UTable.CSetting)
                Using Me.Table.RenderBlock
                    Me._Setting = value
                End Using
            End Set
        End Property

        Public Function HasBorderSetting() As Boolean
            Return Me._BorderSetting IsNot Nothing
        End Function

        Public Sub ClearBorderSetting()
            Me._BorderSetting = Nothing
        End Sub

        Public Property BorderSetting() As UTable.CBorderSetting
            Get
                If Me._BorderSetting Is Nothing Then
                    Me._BorderSetting = New UTable.CBorderSetting
                End If
                Return Me._BorderSetting
            End Get
            Set(ByVal value As UTable.CBorderSetting)
                Me._BorderSetting = value
            End Set
        End Property

        Private Function isRectAppeared(ByVal rect As Rectangle) As Boolean
            Return rect.Height > 0 AndAlso _
                   rect.Width > 0 AndAlso _
                   rect.Left < Me.Table.Width AndAlso _
                   rect.Top < Me.Table.Height AndAlso _
                   rect.Right >= 0 AndAlso _
                   rect.Bottom >= 0
        End Function

        Private Sub createRenderCache(ByVal field As CField, ByVal rect As Rectangle)            
            Dim fieldCache As New CRenderCache.CField
            fieldCache.Rect = rect
            fieldCache.Field = field
            Me.Table.RenderCache.Fields.Add(fieldCache)
            If field Is Me.Table.FocusField Then
                Me.Table.RenderCache.FocusField = fieldCache
            End If
        End Sub

        Friend Sub render(ByVal g As Graphics, _
                          ByVal top_row As Integer, _
                          ByVal top_col As Integer, _
                          ByVal alter As Boolean, _
                          ByVal fixed As Boolean, _
                          ByVal border As CBorder, _
                          ByVal verticalMerge As CVerticalMerge)
            For Each field As CField In Me.Fields.Values
                If field.Desc.Layout IsNot Nothing AndAlso _
                   ((fixed And field.Desc.Layout.Col < Me.Table.FixedCols) Or _
                    (Not fixed And field.Desc.Layout.Col + field.Desc.Layout.Cols > Me.Table.FixedCols)) Then
                    Dim rect As Rectangle = field.GetRectangle(top_row + Me.LayoutCache.Top, top_col)
                    With verticalMerge.Translate(field, rect, alter, top_row, top_col)
                        If Me.isRectAppeared(.Rect) Then
                            .Field.Desc.Provider.Render(g, .Field, .Rect, .Alter)
                        End If
                        If Me.isRectAppeared(rect) Then
                            field.Desc.Provider.SetBorder(field, border, .Merged)
                            Me.createRenderCache(field, rect)
                        End If
                    End With
                End If
            Next
        End Sub

        Public Function CreateChild() As CContent
            Return Me.CreateChild(Nothing)
        End Function

        Public Function CreateChild(ByVal recordProvider As CRecordProvider) As CContent
            Me.Child = New CContent
            Me.Child.ParentRecord = Me
            Me.Child.Table = Me.Child.ParentRecord.Content.Table
            If recordProvider IsNot Nothing Then
                Me.Child.SetRecordProvider(recordProvider)
            End If
            Return Me.Child
        End Function

        Public Sub RemoveChild()
            Using Me.Table.RenderBlock
                Me.Child = Nothing
                Me.TopLevelContent.LayoutCacheInvalid = True
            End Using
        End Sub

        Public Sub CreateRows(ByVal rows_count As Integer)
            Do While Me.Rows.Count < rows_count
                Using Me.Table.RenderBlock
                    Me.Rows.Add(New CGrid(Me))
                    Me.Content.TopLevelContent.LayoutCacheInvalid = True
                End Using
            Loop
        End Sub

        Public Function AddField(ByVal key As Object, _
                                 ByVal fieldProvider As IFieldProvider) As CField
            Return Me.AddField(key, fieldProvider, Nothing)
        End Function

        Public Function AddField(ByVal key As Object, _
                                 ByVal fieldProvider As IFieldProvider, _
                                 ByVal layout As CGrid.CRegion) As CField
            Return AddField(key, New CRecordProvider.CFieldDesc(fieldProvider, layout))
        End Function

        Public Function AddField(ByVal key As Object, ByVal fieldDesc As CRecordProvider.CFieldDesc) As CField
            Using Me.Table.RenderBlock
                If fieldDesc.Layout IsNot Nothing And fieldDesc.Provider.Focusable Then
                    Dim tabOrderMax As Integer = -1
                    For Each _f As CField In Me.Fields.Values
                        If tabOrderMax < _f.Desc.Provider.TabOrder Then
                            tabOrderMax = _f.Desc.Provider.TabOrder
                        End If
                    Next
                    fieldDesc.Provider.TabOrder = tabOrderMax + 1
                End If
                Dim f As CField = Me._addField(key, fieldDesc)
                If f IsNot Nothing Then
                    f.Desc.Provider.FieldInitialize(f)
                End If
                Return f
            End Using
        End Function

        Private Function _addField(ByVal key As Object, ByVal fieldDesc As CRecordProvider.CFieldDesc) As CField
            If fieldDesc.Layout IsNot Nothing Then
                Me.Table.CreateCols(fieldDesc.Layout.Col + fieldDesc.Layout.Cols)
                Me.CreateRows(fieldDesc.Layout.Row + fieldDesc.Layout.Rows)
            End If
            Dim field As CField = fieldDesc.Provider.CreateField()
            field.Init(key, Me, fieldDesc)
            If field IsNot Nothing Then
                Me.Fields.Add(key, field)
            End If
            Return field
        End Function

        Public Sub RemoveField(ByVal key As Object)
            Using Me.Table.RenderBlock
                Me.Fields.Remove(key)
            End Using
        End Sub

        Friend Sub updateCache(ByRef top As Integer, _
                               ByRef prevRecord As CRecord, _
                               ByVal visible As Boolean, _
                               ByVal index As Integer, _
                               ByRef height As Integer)
            Me.LayoutCache.Index = index
            Me.LayoutCache.Visible = visible
            Me.LayoutCache.Top = top
            Me.LayoutCache.RowsSize = 0
            Me.LayoutCache.EntireRowsSize = 0
            Me.LayoutCache.PrevRecord = Nothing
            Me.LayoutCache.NextRecord = Nothing
            Me.LayoutCache.VisibleRowsRev = New List(Of Integer)
            Dim v As Boolean = visible AndAlso Me.Visible
            If v Then
                If prevRecord IsNot Nothing Then
                    Me.LayoutCache.PrevRecord = prevRecord
                    prevRecord.LayoutCache.NextRecord = Me
                End If
                prevRecord = Me
                For Each r As CGrid In Me.Rows
                    With Me.TopLevelContent.LayoutCache
                        If r.Visible Then
                            Me.LayoutCache.RowsSize += r.Size
                            height += r.Size
                            .VisibleRows.Add(r)
                            .VisibleRowsPos.Add(height)
                        End If
                        Me.LayoutCache.VisibleRowsRev.Add(.VisibleRows.Count - 1)
                    End With
                Next
                Me.LayoutCache.EntireRowsSize = Me.LayoutCache.RowsSize
                top += Me.LayoutCache.RowsSize
                If Me.Content.LayoutCache.TopRecord Is Nothing Then
                    Me.Content.LayoutCache.TopRecord = Me
                End If
                Me.Content.LayoutCache.LastRecord = Me
            End If
            If Me.Child IsNot Nothing Then
                Me.Child.updateLayoutCache(top, prevRecord, v, height)
                Me.LayoutCache.EntireRowsSize += Me.Child.LayoutCache.RowsSize
            End If
        End Sub

        Public Function IsChild(ByVal field As CField) As Boolean
            If field.Record Is Me Then
                Return True
            Else
                Return Me.IsChild(field.Record)
            End If
        End Function

        Public Function IsChild(ByVal content As CContent) As Boolean
            If content.ParentRecord Is Me Then
                Return True
            Else
                Return Me.IsChild(content.ParentRecord)
            End If
        End Function

        Public Function IsChild(ByVal record As CRecord) As Boolean
            Dim parent As CRecord = record.Content.ParentRecord
            Do While parent IsNot Nothing
                If parent Is Me Then
                    Return True
                End If
                parent = parent.Content.ParentRecord
            Loop
            Return False
        End Function

        Public Function Row(ByVal key As Object) As CGrid
            Return Me.Rows(Me.Fields(key).Desc.Layout.BottomRow)
        End Function

        Public Function Col(ByVal key As Object) As CGrid
            Return Me.Table.Cols(Me.Fields(key).Desc.Layout.RightCol)
        End Function

        Public Function FindField(ByVal row As Integer, ByVal col As Integer) As CField
            Return Me.FindField(New CGrid.CPoint(row, col))
        End Function

        Public Function FindField(ByVal point As CGrid.CPoint) As CField
            For Each field As UTable.CField In Me.Fields.Values
                If field.Desc.Layout IsNot Nothing Then
                    If field.Desc.Layout.Contains(point) Then
                        Return field
                    End If
                End If
            Next
            Return Nothing
        End Function

        Public Function Table() As UTable
            Return Me.Content.Table
        End Function

        Public Function TopLevelContent() As CContent
            Return Me.Content.TopLevelContent
        End Function

        Public Function TopLevelRecord() As CRecord
            Return Me.Content.TopLevelRecord
        End Function

        Public Sub FlatBorder(ByVal key1 As Object, ByVal key2 As Object)
            Dim l As New Dictionary(Of Object, UTable.CRecordProvider.CFieldDesc)
            For Each k As Object In Me.Fields.Keys
                l.Add(k, Me.Fields(k).Desc)
            Next
            CFieldProvider.FlatBorder(l, key1, key2)
        End Sub

        Public Function GetRectangle() As Rectangle
            Return New Rectangle(0, Me.LayoutCache.Top, Me.Table.LayoutCache.ColsSize, Me.LayoutCache.RowsSize)
        End Function

        Public Property Visible() As Boolean
            Get
                Return Me._Visible
            End Get
            Set(ByVal value As Boolean)
                Using Me.Table.RenderBlock
                    If Not value Then
                        Me.focusEscape()
                    End If
                    Me._Visible = value
                    Me.TopLevelContent.LayoutCacheInvalid = True
                End Using
            End Set
        End Property

        Friend Function tabOrderdList() As List(Of CField)
            Dim ret As New List(Of CField)
            For Each f As CField In Me.Fields.Values
                If f.Desc.Provider.Focusable AndAlso f.DynamicSetting.TabStop = ETabStop.STOP Then
                    ret.Add(f)
                End If
            Next
            ret.Sort(New _CTabOrderComparer)
            Return ret
        End Function

        Private Class _CTabOrderComparer
            Implements IComparer(Of CField)
            Public Function Compare(ByVal x As CField, ByVal y As CField) As Integer Implements IComparer(Of CField).Compare
                If x.Desc.Provider.TabOrder <> y.Desc.Provider.TabOrder Then
                    Return x.Desc.Provider.TabOrder < y.Desc.Provider.TabOrder
                Else
                    Return x.Key.ToString < y.Key.ToString
                End If
            End Function
        End Class

        Public Function DefaultField() As CField
            For Each f As CField In Me.tabOrderdList
                If f.Focusable Then
                    Return f
                End If
            Next
            Return Nothing
        End Function

        Public Function LastField() As CField
            Dim l As List(Of CField) = Me.tabOrderdList
            For i As Integer = l.Count - 1 To 0 Step -1
                If l(i).Focusable Then
                    Return l(i)
                End If
            Next
            Return Nothing
        End Function

        Friend Sub focusEscape()
            If Me.Table.FocusField IsNot Nothing Then
                If Me.Table.FocusField.Record Is Me Then
                    Dim r As CRecord = Me.LayoutCache.PrevRecord
                    Do While r IsNot Nothing
                        Dim f As CField = r.DefaultField
                        If f IsNot Nothing Then
                            Me.Table.FocusField = f
                            Exit Sub
                        End If
                        r = r.LayoutCache.PrevRecord
                    Loop
                    r = Me.LayoutCache.NextRecord
                    Do While r IsNot Nothing
                        Dim f As CField = r.DefaultField
                        If f IsNot Nothing Then
                            Me.Table.FocusField = f
                            Exit Sub
                        End If
                        r = r.LayoutCache.NextRecord
                    Loop
                    Me.Table.FocusField = Nothing
                ElseIf Me.IsChild(Me.Table.FocusField) Then
                    If Me.Child IsNot Nothing Then
                        Me.Child.focusEscape()
                    Else
                        Me.Table.FocusField = Nothing
                    End If
                End If
            End If
        End Sub

        Public Function Index() As Integer
            Return Me.Content.Records.IndexOf(Me)
        End Function

        Public Sub Clear()
            Me.Clear(True)
        End Sub

        Public Sub Clear(ByVal recursive As Boolean)
            Using Me.Table.RenderBlock
                For Each f As CField In Me.Fields.Values
                    f.Clear()
                Next
                If recursive And Me.Child IsNot Nothing Then
                    Me.Child.Clear(recursive)
                End If
            End Using
        End Sub

        Public Function DynamicBorderSetting() As CDynamicBorderSetting
            Return New CDynamicBorderSetting(Me)
        End Function

        Friend Sub raiseAdded()
            RaiseEvent Added(Me)
            Me.Table.raiseRecordAdded(Me)
        End Sub

        Friend Sub raiseMoved()
            RaiseEvent Moved(Me)
            Me.Table.raiseRecordMoved(Me)
        End Sub

        Public Sub raiseRemoved()
            RaiseEvent Removed(Me)
            Me.Table.raiseRecordRemoved(Me)
        End Sub

        Public Sub raiseEnter()
            RaiseEvent Enter(Me)
            Me.Table.raiseRecordEnter(Me)
        End Sub

    End Class

End Class
