package net.osdn.util.ssdp.client;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class SearchResponse {
	private static final Charset UTF_8 = Charset.forName("UTF-8");
	
	private InetAddress addr;
	private int status = 0;
	private Map<String, String> headers = new HashMap<String, String>();
			
	public SearchResponse(DatagramPacket packet) throws IOException {
		this(packet.getData(), packet.getOffset(), packet.getLength());
		this.addr = packet.getAddress();
	}
	
	public SearchResponse(byte[] buf, int offset, int length) throws IOException {
		BufferedReader r = null;
		try {
			r = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(buf, offset, length), UTF_8));
			String header = r.readLine();
			int i = header.indexOf(' ') + 1;
			int j = i;
			while(j < header.length()) {
				char c = header.charAt(j);
				if('0' <= c && c <= '9') {
					j++;
				} else {
					break;
				}
			}
			if(j > i) {
				status = Integer.parseInt(header.substring(i, j));
				String line;
				while((line = r.readLine()) != null) {
					i = line.indexOf(':');
					if(i > 0) {
						String key = line.substring(0, i);
						String value = line.substring(i + 1).trim();
						headers.put(key.toUpperCase(), value);
					}
				}
			}
		} finally {
			if(r != null) {
				r.close();
			}
		}
	}
	
	public InetAddress getAddress() {
		return addr;
	}
	
	public int getStatus() {
		return status;
	}
	
	public String getHeader(String key) {
		if(key == null) {
			return null;
		}
		return headers.get(key.toUpperCase());
	}
}
