package net.osdn.util.ssdp;

import java.io.IOException;
import java.io.Reader;
import java.net.InetAddress;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class Device {
	
	private static XmlPullParserFactory factory;
	
	public static Device parse(Reader reader) throws XmlPullParserException, IOException {
		if(factory == null) {
			factory = XmlPullParserFactory.newInstance();
			factory.setNamespaceAware(true);
		}
		
		Device device = new Device();
		
		XmlPullParser parser = factory.newPullParser();
		parser.setInput(reader);
		int eventType = parser.getEventType();
		boolean isInDeviceTag = false;
		while(eventType != XmlPullParser.END_DOCUMENT) {
			String name = parser.getName();
			switch(eventType) {
			case XmlPullParser.START_TAG:
				if("device".equalsIgnoreCase(name)) {
					isInDeviceTag = true;
				} else if(isInDeviceTag) {
					if("UDN".equalsIgnoreCase(name)) {
						if(parser.next() == XmlPullParser.TEXT) {
							device.udn = parser.getText();
						}
						continue;
					} else if("friendlyName".equalsIgnoreCase(name)) {
						if(parser.next() == XmlPullParser.TEXT) {
							device.friendlyName = parser.getText();
						}
						continue;
					} else if("deviceType".equalsIgnoreCase(name)) {
						if(parser.next() == XmlPullParser.TEXT) {
							device.deviceType = parser.getText();
						};
						continue;
					} else if("manufacturer".equalsIgnoreCase(name)) {
						if(parser.next() == XmlPullParser.TEXT) {
							device.manufacturer = parser.getText();
						}
						continue;
					} else if("modelName".equalsIgnoreCase(name)) {
						if(parser.next() == XmlPullParser.TEXT) {
							device.modelName = parser.getText();
						}
						continue;
					} else if("modelNumber".equalsIgnoreCase(name)) {
						if(parser.next() == XmlPullParser.TEXT) {
							device.modelNumber = parser.getText();
						}
						continue;
					} else if("serialNumber".equalsIgnoreCase(name)) {
						if(parser.next() == XmlPullParser.TEXT) {
							device.serialNumber = parser.getText();
						}
						continue;
					}
				}
				break;
			case XmlPullParser.END_TAG:
				if("device".equalsIgnoreCase(name)) {
					isInDeviceTag = false;
				}
				break;
			}
			eventType = parser.next();
		}
		
		return device;
	}

	private String udn;
	private String friendlyName;
	private String deviceType;
	private String manufacturer;
	private String modelName;
	private String modelNumber;
	private String serialNumber;
	private InetAddress addr;
	private boolean isSelf;
	
	public void setUdn(String udn) {
		this.udn = udn;
	}
	
	public String getUdn() {
		if(this.udn == null) {
			return "";
		}
		return this.udn;
	}
	
	public void setFriendlyName(String friendlyName) {
		this.friendlyName = friendlyName;
	}
	
	public String getFriendlyName() {
		if(this.friendlyName == null) {
			return "";
		}
		return this.friendlyName;
	}
	
	public void setDeviceType(String deviceType) {
		this.deviceType = deviceType;
	}
	
	public String getDeviceType() {
		if(this.deviceType == null) {
			return "";
		}
		return this.deviceType;
	}
	
	public void setManufacturer(String manufacturer) {
		this.manufacturer = manufacturer;
	}
	
	public String getManufacturer() {
		if(this.manufacturer == null) {
			return "";
		}
		return this.manufacturer;
	}
	
	public void setModelName(String modelName) {
		this.modelName = modelName;
	}
	
	public String getModelName() {
		if(this.modelName == null) {
			return "";
		}
		return this.modelName;
	}
	
	public void setModelNumber(String modelNumber) {
		this.modelNumber = modelNumber;
	}
	
	public String getModelNumber() {
		if(this.modelNumber == null) {
			return "";
		}
		return this.modelNumber;
	}
	
	public void setSerialNumber(String serialNumber) {
		this.serialNumber = serialNumber;
	}
	
	public String getSerialNumber() {
		if(this.serialNumber == null) {
			return "";
		}
		return this.serialNumber;
	}
	
	public void setAddress(InetAddress addr) {
		this.addr = addr;
	}
	
	public InetAddress getAddress() {
		return this.addr;
	}
	
	public void setSelf(boolean isSelf) {
		this.isSelf = isSelf;
	}
	
	public boolean isSelf() {
		return this.isSelf;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((addr == null) ? 0 : addr.hashCode());
		result = prime * result + ((udn == null) ? 0 : udn.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Device other = (Device) obj;
		if (addr == null) {
			if (other.addr != null)
				return false;
		} else if (!addr.equals(other.addr))
			return false;
		if (udn == null) {
			if (other.udn != null)
				return false;
		} else if (!udn.equals(other.udn))
			return false;
		return true;
	}
}
