/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.ssdp.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.osdn.util.ssdp.Device;
import net.osdn.util.ssdp.client.DiscoveryCallback;
import net.osdn.util.ssdp.client.SearchResponse;

public class SsdpClient {
    public static boolean DEBUG = false;
    public static final int SSDP_PORT = 1900;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final int RECV_TIMEOUT_MIN = 5000;
    private static final int RECV_TIMEOUT = 15000;
    private static final int SEND_INTERVAL = 3000;
    private int timeout;
    private DiscoveryCallback callback;
    private MulticastSocket socket;
    private Thread sendThread;
    private Thread recvThread;
    private Set<Device> foundDevices = new HashSet<Device>();
    private List<Future<Device>> futures = new ArrayList<Future<Device>>();
    private boolean isSendRunning;
    private boolean isRecvRunning;
    private boolean isCancelRequested;
    private List<Device> list;

    public void cancel() {
        block14: {
            if (!this.isCancelRequested && (this.isSendRunning || this.isRecvRunning)) {
                block13: {
                    this.isCancelRequested = true;
                    if (this.socket != null) {
                        try {
                            this.socket.close();
                        }
                        catch (Exception e) {
                            if (DEBUG) {
                                e.printStackTrace();
                            }
                        }
                        finally {
                            this.socket = null;
                        }
                    }
                    try {
                        this.sendThread.interrupt();
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block13;
                        e.printStackTrace();
                    }
                }
                try {
                    this.recvThread.interrupt();
                }
                catch (Exception e) {
                    if (!DEBUG) break block14;
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Device> get() {
        if (this.list != null) {
            return this.list;
        }
        if (this.isSendRunning) {
            try {
                this.sendThread.join();
            }
            catch (InterruptedException e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
            }
            finally {
                this.sendThread = null;
            }
        }
        if (this.isRecvRunning) {
            try {
                this.recvThread.join();
            }
            catch (InterruptedException e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
            }
            finally {
                this.recvThread = null;
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
            }
            finally {
                this.socket = null;
            }
        }
        if (this.futures != null) {
            this.list = new ArrayList<Device>();
            for (Future<Device> future : this.futures) {
                Device device;
                block31: {
                    device = null;
                    try {
                        device = future.get();
                    }
                    catch (InterruptedException e) {
                        if (DEBUG) {
                            e.printStackTrace();
                        }
                    }
                    catch (ExecutionException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof ConnectException || !DEBUG) break block31;
                        e.printStackTrace();
                    }
                }
                if (device == null) continue;
                this.list.add(device);
            }
        }
        return this.list;
    }

    public void discover() throws IOException {
        this.discover(15000, null);
    }

    public void discover(int timeout) throws IOException {
        this.discover(timeout, null);
    }

    public void discover(DiscoveryCallback callback) throws IOException {
        this.discover(15000, callback);
    }

    public void discover(int timeout, DiscoveryCallback callback) throws IOException {
        if (this.isSendRunning || this.isRecvRunning) {
            return;
        }
        this.isCancelRequested = false;
        this.timeout = timeout > 5000 ? timeout : 5000;
        this.callback = callback;
        this.list = null;
        this.foundDevices.clear();
        this.socket = new MulticastSocket(0);
        this.sendThread = new Thread(){

            @Override
            public void run() {
                block2: {
                    try {
                        SsdpClient.this.send();
                    }
                    catch (Exception e) {
                        if (SsdpClient.this.isCancelRequested) break block2;
                        throw new RuntimeException(e);
                    }
                }
                SsdpClient.this.isSendRunning = false;
            }
        };
        this.sendThread.start();
        this.isSendRunning = true;
        this.recvThread = new Thread(){

            @Override
            public void run() {
                block6: {
                    block5: {
                        try {
                            SsdpClient.this.recv();
                        }
                        catch (Exception e) {
                            if (SsdpClient.this.isCancelRequested) break block5;
                            throw new RuntimeException(e);
                        }
                    }
                    SsdpClient.this.isRecvRunning = false;
                    if (SsdpClient.this.callback != null) {
                        try {
                            SsdpClient.this.callback.done();
                        }
                        catch (Exception e) {
                            if (!DEBUG) break block6;
                            e.printStackTrace();
                        }
                    }
                }
            }
        };
        this.recvThread.start();
        this.isRecvRunning = true;
    }

    protected void send() throws InterruptedException {
        DatagramPacket ipv6packet;
        InetAddress ipv6mcastaddr;
        DatagramPacket ipv4packet;
        InetAddress ipv4mcastaddr;
        int count;
        block19: {
            String query;
            String strIpv6mcastaddr;
            block18: {
                String strIpv4mcastaddr = "239.255.255.250";
                strIpv6mcastaddr = "FF02::C";
                query = "M-SEARCH * HTTP/1.1\r\nHost:${HOST}:${PORT}\r\nST:upnp:rootdevice\r\nMAN:\"ssdp:discover\"\r\nMX:1\r\n\r\n";
                count = (this.timeout - 4000) / 3000;
                if (count < 1) {
                    count = 1;
                }
                ipv4mcastaddr = null;
                ipv4packet = null;
                try {
                    byte[] buf = query.replace("${HOST}", strIpv4mcastaddr).replace("${PORT}", Integer.toString(1900)).getBytes();
                    ipv4mcastaddr = InetAddress.getByName(strIpv4mcastaddr);
                    ipv4packet = new DatagramPacket(buf, 0, buf.length, ipv4mcastaddr, 1900);
                }
                catch (Exception e) {
                    if (!DEBUG) break block18;
                    e.printStackTrace();
                }
            }
            ipv6mcastaddr = null;
            ipv6packet = null;
            try {
                byte[] buf = query.replace("${HOST}", "[" + strIpv6mcastaddr + "]").replace("${PORT}", Integer.toString(1900)).getBytes();
                ipv6mcastaddr = InetAddress.getByName(strIpv6mcastaddr);
                ipv6packet = new DatagramPacket(buf, 0, buf.length, ipv6mcastaddr, 1900);
            }
            catch (Exception e) {
                if (!DEBUG) break block19;
                e.printStackTrace();
            }
        }
        for (int i = 0; i < count; ++i) {
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface netIf = interfaces.nextElement();
                    if (netIf.isLoopback() || netIf.isVirtual() || !netIf.isUp() || !netIf.supportsMulticast()) continue;
                    for (InterfaceAddress ifAddr : netIf.getInterfaceAddresses()) {
                        InetAddress addr;
                        block20: {
                            InetAddress inetAddress = addr = ifAddr != null ? ifAddr.getAddress() : null;
                            if (this.isCancelRequested) {
                                return;
                            }
                            if (ipv4mcastaddr != null && addr instanceof Inet4Address) {
                                if (DEBUG) {
                                    System.out.println("# SSDP: send: IPv4: netIf=" + netIf + ", ifAddr=" + ifAddr + ", addr=" + addr + ", isLoopback=" + netIf.isLoopback() + ", isVirtual=" + netIf.isVirtual() + ", netIf.isUp=" + netIf.isUp() + ", supportMulticast=" + netIf.supportsMulticast());
                                }
                                try {
                                    this.socket.setInterface(addr);
                                    this.socket.send(ipv4packet);
                                }
                                catch (Exception e) {
                                    if (this.isCancelRequested) break block20;
                                    System.err.println("# SSDP: send: IPv4: ERROR, ifAddr=" + ifAddr);
                                    e.printStackTrace();
                                }
                            }
                        }
                        if (ipv6mcastaddr == null || !(addr instanceof Inet6Address)) continue;
                        if (DEBUG) {
                            System.out.println("# SSDP: send: IPv6: netIf=" + netIf + ", ifAddr=" + ifAddr + ", addr=" + addr + ", isLoopback=" + netIf.isLoopback() + ", isVirtual=" + netIf.isVirtual() + ", netIf.isUp=" + netIf.isUp() + ", supportMulticast=" + netIf.supportsMulticast());
                        }
                        try {
                            this.socket.setInterface(addr);
                            this.socket.send(ipv6packet);
                        }
                        catch (Exception e) {
                            if (this.isCancelRequested) continue;
                            System.err.println("# SSDP: send: IPv6: ERROR, ifAddr=" + ifAddr);
                            e.printStackTrace();
                        }
                    }
                }
                if (i + 1 >= count) continue;
                Thread.sleep(3000L);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recv() throws InterruptedException, IOException {
        ExecutorService executor = null;
        try {
            executor = Executors.newCachedThreadPool();
            this.futures.clear();
            List<InetAddress> localAddresses = null;
            try {
                localAddresses = SsdpClient.getLocalAddresses();
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            long startTime = System.currentTimeMillis();
            byte[] buf = new byte[1024];
            DatagramPacket packet = new DatagramPacket(buf, buf.length);
            while (true) {
                SearchResponse response;
                try {
                    int d = (int)(System.currentTimeMillis() - startTime);
                    if (this.timeout - d <= 0) {
                        break;
                    }
                    this.socket.setSoTimeout(this.timeout - d);
                    this.socket.receive(packet);
                }
                catch (SocketTimeoutException e) {
                    break;
                }
                if (packet.getLength() <= 0 || packet.getData()[0] != 72 || (response = new SearchResponse(packet)).getStatus() != 200) continue;
                final InetAddress deviceAddr = packet.getAddress();
                final String location = response.getHeader("Location");
                final DiscoveryCallback dc = this.callback;
                final boolean isSelf = localAddresses != null && localAddresses.contains(deviceAddr);
                Future<Device> future = executor.submit(new Callable<Device>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Device call() throws Exception {
                        Object object;
                        Device device;
                        BufferedReader r;
                        InputStream in;
                        block26: {
                            URL url = new URL(location);
                            URLConnection connection = null;
                            in = null;
                            r = null;
                            connection = url.openConnection();
                            in = connection.getInputStream();
                            r = new BufferedReader(new InputStreamReader(in, UTF_8));
                            device = Device.parse(r);
                            device.setAddress(deviceAddr);
                            device.setSelf(isSelf);
                            object = SsdpClient.this.foundDevices;
                            synchronized (object) {
                                block25: {
                                    if (!SsdpClient.this.foundDevices.contains(device)) break block25;
                                    Device device2 = null;
                                    return device2;
                                }
                                SsdpClient.this.foundDevices.add(device);
                            }
                            if (dc != null) {
                                try {
                                    dc.discovered(device);
                                }
                                catch (Exception e) {
                                    if (!DEBUG) break block26;
                                    e.printStackTrace();
                                }
                            }
                        }
                        object = device;
                        return object;
                        finally {
                            if (r != null) {
                                try {
                                    r.close();
                                }
                                catch (Exception exception) {}
                            }
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                });
                this.futures.add(future);
            }
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
    }

    protected void shutdown() {
    }

    private static List<InetAddress> getLocalAddresses() throws SocketException {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface network = interfaces.nextElement();
            for (InterfaceAddress ifAddr : network.getInterfaceAddresses()) {
                InetAddress addr = ifAddr.getAddress();
                if (addr == null) continue;
                addresses.add(addr);
            }
        }
        return addresses;
    }
}

