/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.ssdp;

import java.io.IOException;
import java.io.Reader;
import java.net.InetAddress;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class Device {
    private static XmlPullParserFactory factory;
    private String udn;
    private String friendlyName;
    private String deviceType;
    private String manufacturer;
    private String modelName;
    private String modelNumber;
    private String modelDescription;
    private String serialNumber;
    private InetAddress addr;
    private boolean isSelf;

    public static Device parse(Reader reader) throws XmlPullParserException, IOException {
        if (factory == null) {
            factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
        }
        Device device = new Device();
        XmlPullParser parser = factory.newPullParser();
        parser.setInput(reader);
        int eventType = parser.getEventType();
        boolean isInDeviceTag = false;
        block4: while (eventType != 1) {
            String name = parser.getName();
            switch (eventType) {
                case 2: {
                    if ("device".equalsIgnoreCase(name)) {
                        isInDeviceTag = true;
                        break;
                    }
                    if (!isInDeviceTag) break;
                    if ("UDN".equalsIgnoreCase(name)) {
                        if (parser.next() != 4) continue block4;
                        device.setUdn(parser.getText());
                        continue block4;
                    }
                    if ("friendlyName".equalsIgnoreCase(name)) {
                        if (parser.next() != 4) continue block4;
                        device.setFriendlyName(parser.getText());
                        continue block4;
                    }
                    if ("deviceType".equalsIgnoreCase(name)) {
                        if (parser.next() != 4) continue block4;
                        device.setDeviceType(parser.getText());
                        continue block4;
                    }
                    if ("manufacturer".equalsIgnoreCase(name)) {
                        if (parser.next() != 4) continue block4;
                        device.setManufacturer(parser.getText());
                        continue block4;
                    }
                    if ("modelName".equalsIgnoreCase(name)) {
                        if (parser.next() != 4) continue block4;
                        device.setModelName(parser.getText());
                        continue block4;
                    }
                    if ("modelNumber".equalsIgnoreCase(name)) {
                        if (parser.next() != 4) continue block4;
                        device.setModelNumber(parser.getText());
                        continue block4;
                    }
                    if ("modelDescription".equalsIgnoreCase(name)) {
                        if (parser.next() != 4) continue block4;
                        device.setModelDescription(parser.getText());
                        continue block4;
                    }
                    if (!"serialNumber".equalsIgnoreCase(name)) break;
                    if (parser.next() != 4) continue block4;
                    device.setSerialNumber(parser.getText());
                    continue block4;
                }
                case 3: {
                    if (!"device".equalsIgnoreCase(name)) break;
                    isInDeviceTag = false;
                }
            }
            eventType = parser.next();
        }
        return device;
    }

    private static String escape(String value) {
        if (value != null) {
            return ("!" + value.replace("\r\n", "\n").replace('\r', ' ').replace('\n', ' ')).trim().substring(1);
        }
        return null;
    }

    public void setUdn(String udn) {
        this.udn = udn;
    }

    public String getUdn() {
        if (this.udn == null) {
            return "";
        }
        return this.udn;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = Device.escape(friendlyName);
    }

    public String getFriendlyName() {
        if (this.friendlyName == null) {
            return "";
        }
        return this.friendlyName;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = Device.escape(deviceType);
    }

    public String getDeviceType() {
        if (this.deviceType == null) {
            return "";
        }
        return this.deviceType;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = Device.escape(manufacturer);
    }

    public String getManufacturer() {
        if (this.manufacturer == null) {
            return "";
        }
        return this.manufacturer;
    }

    public void setModelName(String modelName) {
        this.modelName = Device.escape(modelName);
    }

    public String getModelName() {
        if (this.modelName == null) {
            return "";
        }
        return this.modelName;
    }

    public void setModelNumber(String modelNumber) {
        this.modelNumber = Device.escape(modelNumber);
    }

    public String getModelNumber() {
        if (this.modelNumber == null) {
            return "";
        }
        return this.modelNumber;
    }

    public void setModelDescription(String modelDescription) {
        this.modelDescription = Device.escape(modelDescription);
    }

    public String getModelDescription() {
        if (this.modelDescription == null) {
            return "";
        }
        return this.modelDescription;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = Device.escape(serialNumber);
    }

    public String getSerialNumber() {
        if (this.serialNumber == null) {
            return "";
        }
        return this.serialNumber;
    }

    public void setAddress(InetAddress addr) {
        this.addr = addr;
    }

    public InetAddress getAddress() {
        return this.addr;
    }

    public void setSelf(boolean isSelf) {
        this.isSelf = isSelf;
    }

    public boolean isSelf() {
        return this.isSelf;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addr == null ? 0 : this.addr.hashCode());
        result = 31 * result + (this.udn == null ? 0 : this.udn.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Device other = (Device)obj;
        if (this.addr == null ? other.addr != null : !this.addr.equals(other.addr)) {
            return false;
        }
        return !(this.udn == null ? other.udn != null : !this.udn.equals(other.udn));
    }
}

