/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.jersey.log;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import net.osdn.util.jersey.log.FileManager;
import net.osdn.util.jersey.log.LoggingOutputStream;
import net.osdn.util.jersey.log.UniqueDatetime;

@Provider
@Priority(value=999)
public class ResponseLogger
implements ContainerResponseFilter {
    private static final Map<Integer, String> reasonPhrases = new HashMap<Integer, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        String base = UniqueDatetime.get() + String.format("-%08x-%03d", requestContext.hashCode(), responseContext.getStatus());
        File hdr0 = new File(FileManager.TMP_DIR, base + "-res.hdr.tmp");
        File hdr1 = new File(FileManager.TMP_DIR, base + "-res.hdr");
        final File bdy0 = new File(FileManager.TMP_DIR, base + "-res.bdy.tmp");
        final File bdy1 = new File(FileManager.TMP_DIR, base + "-res.bdy");
        try (BufferedWriter w = null;){
            w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(hdr0), StandardCharsets.UTF_8));
            w.write("HTTP/1.1");
            w.write(32);
            w.write(Integer.toString(responseContext.getStatus()));
            w.write(32);
            String reasonPhrase = reasonPhrases.get(responseContext.getStatus());
            if (reasonPhrase == null) {
                reasonPhrase = "Undefined";
            }
            w.write(reasonPhrase);
            w.write(13);
            w.write(10);
            for (String headerName : responseContext.getHeaders().keySet()) {
                String headerValue = responseContext.getHeaderString(headerName);
                w.write(headerName);
                w.write(58);
                w.write(32);
                w.write(headerValue);
                w.write(13);
                w.write(10);
            }
            w.write(13);
            w.write(10);
            w.close();
            w = null;
            hdr0.renameTo(hdr1);
            FileManager.append(hdr1);
        }
        if (responseContext.hasEntity()) {
            FileOutputStream log = new FileOutputStream(bdy0);
            LoggingOutputStream output = new LoggingOutputStream(responseContext.getEntityStream(), log, new Runnable(){

                @Override
                public void run() {
                    bdy0.renameTo(bdy1);
                }
            });
            responseContext.setEntityStream((OutputStream)output);
        }
    }

    static {
        reasonPhrases.put(100, "Continue");
        reasonPhrases.put(101, "Switching Protocols");
        reasonPhrases.put(200, "OK");
        reasonPhrases.put(201, "Created");
        reasonPhrases.put(202, "Accepted");
        reasonPhrases.put(203, "Non-Authoritative Information");
        reasonPhrases.put(204, "No Content");
        reasonPhrases.put(205, "Reset Content");
        reasonPhrases.put(206, "Partial Content");
        reasonPhrases.put(300, "Multiple Choices");
        reasonPhrases.put(301, "Moved Permanently");
        reasonPhrases.put(302, "Found");
        reasonPhrases.put(303, "See Other");
        reasonPhrases.put(304, "Not Modified");
        reasonPhrases.put(305, "Use Proxy");
        reasonPhrases.put(307, "Temporary Redirect");
        reasonPhrases.put(400, "Bad Request");
        reasonPhrases.put(401, "Unauthorized");
        reasonPhrases.put(402, "Payment Required");
        reasonPhrases.put(403, "Forbidden");
        reasonPhrases.put(404, "Not Found");
        reasonPhrases.put(405, "Method Not Allowed");
        reasonPhrases.put(406, "Not Acceptable");
        reasonPhrases.put(407, "Proxy Authentication Required");
        reasonPhrases.put(408, "Request Time-out");
        reasonPhrases.put(409, "Conflict");
        reasonPhrases.put(410, "Gone");
        reasonPhrases.put(411, "Length Required");
        reasonPhrases.put(412, "Precondition Failed");
        reasonPhrases.put(413, "Request Entity Too Large");
        reasonPhrases.put(414, "Request-URI Too Large");
        reasonPhrases.put(415, "Unsupported Media Type");
        reasonPhrases.put(416, "Requested range not satisfiable");
        reasonPhrases.put(417, "Expectation Failed");
        reasonPhrases.put(500, "Internal Server Error");
        reasonPhrases.put(501, "Not Implemented");
        reasonPhrases.put(502, "Bad Gateway");
        reasonPhrases.put(503, "Service Unavailable");
        reasonPhrases.put(504, "Gateway Time-out");
        reasonPhrases.put(505, "HTTP Version not supported");
    }
}

