/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.jersey.log;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import net.osdn.util.jersey.log.FileManager;
import net.osdn.util.jersey.log.ProcessIdentifier;
import net.osdn.util.jersey.log.UniqueDatetime;

@Provider
@Priority(value=4999)
public class ResourceLogger
implements ContainerRequestFilter {
    private static final Pattern SIMPLE_NAME = Pattern.compile("[^.<@]+\\.");
    @Context
    private ResourceInfo resourceInfo;
    @Context
    private HttpServletRequest httpServletRequest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext requestContext) throws IOException {
        String base = UniqueDatetime.get() + "-" + ProcessIdentifier.getId() + String.format("-%08x", requestContext.hashCode());
        File rsc0 = new File(FileManager.TMP_DIR, base + "-req.rsc.tmp");
        File rsc1 = new File(FileManager.TMP_DIR, base + "-req.rsc");
        Class cls = this.resourceInfo.getResourceClass();
        Method method = this.resourceInfo.getResourceMethod();
        try (BufferedWriter w = null;){
            int i;
            w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(rsc0), StandardCharsets.UTF_8));
            Annotation[] clsAnnotations = cls.getAnnotations();
            if (clsAnnotations != null) {
                w.write("Class-Annotations: ");
                for (int i2 = 0; i2 < clsAnnotations.length; ++i2) {
                    w.write(ResourceLogger.getSimpleName(clsAnnotations[i2]));
                    if (i2 + 1 >= clsAnnotations.length) continue;
                    w.write(44);
                    w.write(32);
                }
                w.write(13);
                w.write(10);
            }
            w.write("Class: ");
            w.write(cls.getName());
            w.write(13);
            w.write(10);
            Annotation[] methodAnnotations = method.getAnnotations();
            if (methodAnnotations != null) {
                w.write("Method-Annotations: ");
                for (i = 0; i < methodAnnotations.length; ++i) {
                    w.write(ResourceLogger.getSimpleName(methodAnnotations[i]));
                    if (i + 1 >= methodAnnotations.length) continue;
                    w.write(44);
                    w.write(32);
                }
                w.write(13);
                w.write(10);
            }
            w.write("Method: ");
            w.write(ResourceLogger.getSimpleName(method.getGenericReturnType()));
            w.write(32);
            w.write(method.getName());
            w.write(13);
            w.write(10);
            if (method.getParameterCount() > 0) {
                for (i = 0; i < method.getParameterCount(); ++i) {
                    w.write("Parameter: ");
                    Annotation[] annotations = method.getParameterAnnotations()[i];
                    for (int j = 0; j < annotations.length; ++j) {
                        w.write(ResourceLogger.getSimpleName(annotations[j]));
                        w.write(32);
                    }
                    w.write(ResourceLogger.getSimpleName(method.getGenericParameterTypes()[i]));
                    if (method.getParameters()[i].isNamePresent()) {
                        w.write(32);
                        w.write(method.getParameters()[i].getName());
                    }
                    w.write(13);
                    w.write(10);
                }
            }
            w.close();
            w = null;
            rsc0.renameTo(rsc1);
            FileManager.append(rsc1);
        }
    }

    private static String getSimpleName(Type genericType) {
        return ResourceLogger.getSimpleName(genericType.getTypeName());
    }

    private static String getSimpleName(Annotation annotation) {
        return ResourceLogger.getSimpleName(annotation.toString());
    }

    private static String getSimpleName(String genericTypeName) {
        StringBuffer sb = new StringBuffer();
        Matcher m = SIMPLE_NAME.matcher(genericTypeName);
        while (m.find()) {
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

