package net.osdn.util.jersey;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

public class InvocationHandler implements java.lang.reflect.InvocationHandler {

	private static final NullObject NULL = new NullObject();
	
	@Override
	public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
		Object result = method.invoke(obj, args);
		if(result == null) {
			try {
				if(isProduceMediaTypeJson(method)) {
					result = NULL;
				}
			} catch(Exception e) {
				// ignore
			}
		}
		return result;
	}
	
	private static boolean isProduceMediaTypeJson(Method method) {
		Annotation[] annotations = method.getAnnotations();
		if(annotations != null) {
			for(int i = 0; i < annotations.length; i++) {
				Annotation annotation = annotations[i];
				if(annotation instanceof Produces) {
					Produces produces = (Produces)annotation;
					for(String s : produces.value()) {
						if(MediaType.APPLICATION_JSON.equals(s)) {
							return true;
						}
					}
				}
			}
		}
		return false;
	}
	
	@JsonSerialize(using=NullObjectSerializer.class)
	public static class NullObject {
	}
	
	public static class NullObjectSerializer extends JsonSerializer<NullObject> {
		@Override
		public void serialize(NullObject value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
			gen.writeNull();
		}
	}
}
