package net.osdn.util.jersey;

import org.glassfish.jersey.server.ResourceConfig;

public class RestApplication extends ResourceConfig {
	
	public RestApplication() {
		packages("net.osdn.util.jersey");
		
		boolean isJerseyLoggerRegistered = false;
		
		//jersey-logger
		try {
			if(exists("net.osdn.util.jersey.log.RequestLogger")) {
				System.out.println("LOAD: net.osdn.util.jersey.log");
				packages("net.osdn.util.jersey.log");
				
				Class<?> invocationLoggerBinderClass = null;
				try {
					invocationLoggerBinderClass = Class.forName("net.osdn.util.jersey.log.InvocationLoggerBinder");
					register(invocationLoggerBinderClass.newInstance());
					isJerseyLoggerRegistered = true;
				} catch(Exception e) {
					e.printStackTrace();
				}
			}
		} catch(Exception e) {
			e.printStackTrace();
		}
		
		if(!isJerseyLoggerRegistered) {
			register(new InvocationHandlerBinder());
		}

		//jersey-freemarker
		try {
			if(exists("freemarker.template.Configuration")) {
				if(exists("net.osdn.util.jersey.ext.freemarker.FreeMarkerMessageBodyWriter")) {
					System.out.println("LOAD: net.osdn.util.jersey.ext.freemarker");
					packages("net.osdn.util.jersey.ext.freemarker");
				}
			}
		} catch(Exception e) {
			e.printStackTrace();
		}
		
		//jersey-cors-filter
		try {
			if(exists("net.osdn.util.jersey.ext.cors.CrossOriginResourceSharingFilter")) {
				System.out.println("LOAD: net.osdn.util.jersey.ext.cors");
				packages("net.osdn.util.jersey.ext.cors");
			}
		} catch(Exception e) {
			e.printStackTrace();
		}
		
		packages(getClass().getPackage().getName());
	}

	protected boolean exists(String className) {
		try {
			Class.forName(className);
			return true;
		} catch (ClassNotFoundException e) {
			return false;
		}
	}
}
