package net.osdn.util.sql;

import java.sql.Connection;

/** トランザクション分離レベルを表わす列挙型です。
 * 
 */
public enum IsolationLevel {
	
	/** トランザクションがサポートされていないことを示します。 */
	None(Connection.TRANSACTION_NONE),
	
	/** ダーティ読み込み、繰り返し不可の読み込み、およびファントム読み込みが起こることを示します。 */
	ReadUncommitted(Connection.TRANSACTION_READ_UNCOMMITTED),
	
	/** ダーティ読み込みは抑制され、繰り返し不可の読み込み、およびファントム読み込みが起こることを示します。 */
	ReadCommitted(Connection.TRANSACTION_READ_COMMITTED),
	
	/** ダーティ読み込みおよび繰り返し不可の読み込みは抑制され、ファントム読み込みが起こることを示します。 */
	RepeatableRead(Connection.TRANSACTION_REPEATABLE_READ),
	
	/** ダーティ読み込み、繰り返し不可の読み込み、およびファントム読み込みが抑制されることを示します。 */
	Serializable(Connection.TRANSACTION_SERIALIZABLE);
	
	private int value;
	
	IsolationLevel(int value) {
		this.value = value;
	}
	
	/** トランザクション分離レベルのJDBC定数を取得します。
	 * 返される値は以下のいずれかです。
	 * <ul>
	 *   <li>Connection.TRANSACTION_NONE</li>
	 *   <li>Connection.TRANSACTION_READ_UNCOMMITTED</li>
	 *   <li>Connection.TRANSACTION_READ_COMMITTED</li>
	 *   <li>Connection.TRANSACTION_REPEATABLE_READ</li>
	 *   <li>Connection.TRANSACTION_SERIALIZABLE</li>
	 * </ul>
	 * 
	 * @return トランザクション分離レベルのJDBC定数
	 */
	public int getValue() {
		return value;
	}
}
