package net.osdn.util.sql.mssql;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;

import net.osdn.util.sql.StatementBuilder;

/** Microsoft SQL Server用のSQL文構築ビルダーです。
 * 
 */
public class MssqlStatementBuilder extends StatementBuilder {

	/** 指定されたデータベース・メタデータが、この構文ビルダーに適合するかどうかをチェックします。
	 * 
	 * <p>DatabaseMetaData.getDatabaseProductName()メソッドが
	 * 返すデータベース製品名に"SQL Server"が含まれる場合、この構文ビルダーに適合すると見なして true を返します。</p>
	 * 
	 * @param md データベース・メタデータ
	 * @return データベース製品名に "SQL Server" が含まれている場合は true、そうでなければ false
	 */
	@Override
	public boolean isAcceptable(DatabaseMetaData md) throws SQLException {
		String productName = md.getDatabaseProductName();
		
		if(productName != null && productName.contains("SQL Server")) {
			return true;
		}
		
		return false;
	}
}
