package net.osdn.util.jersey;

import javax.sql.RowSet;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;

import net.osdn.util.json.jackson.JacksonDatetimeModule;

@Provider
public class JacksonConfig implements ContextResolver<ObjectMapper> {

	private ObjectMapper mapper = new ObjectMapper();

	public JacksonConfig() {
		SimpleModule module = new SimpleModule("JDBCModule", new Version(1,0,0,null,null,null));
		module.addSerializer(RowSet.class, new RowSetSerializer());
		mapper.registerModule(module);

		JacksonDatetimeModule datetimeModule = new JacksonDatetimeModule();
		mapper.registerModule(datetimeModule);
		
		mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
		mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
		mapper.enable(SerializationFeature.INDENT_OUTPUT);
	}
	
	@Override
	public ObjectMapper getContext(Class<?> type) {
		return mapper;
	}
}
