package net.osdn.util.jersey.fastpack;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class BytePacker {
	
	private static byte[] BYTES_STRING_EMPTY = new byte[] { (byte)0x00 };
	private static int MAX_STRING_LENGTH = 16383;
	private static byte[] BYTES_LONG_0 = new byte[] { (byte)0xC0 };
	private static byte[] BYTES_LONG_1 = new byte[] { (byte)0xC1 };
	private static byte[] BYTES_LONG_2 = new byte[] { (byte)0xC2 };
	private static byte[] BYTES_LONG_3 = new byte[] { (byte)0xC3 };
	private static byte[] BYTES_LONG_4 = new byte[] { (byte)0xC4 };
	private static byte[] BYTES_LONG_5 = new byte[] { (byte)0xC5 };
	private static byte[] BYTES_LONG_6 = new byte[] { (byte)0xC6 };
	private static byte[] BYTES_LONG_7 = new byte[] { (byte)0xC7 };
	private static byte[] BYTES_LONG_8 = new byte[] { (byte)0xC8 };
	private static byte[] BYTES_LONG_9 = new byte[] { (byte)0xC9 };
	private static byte[] BYTES_LONG_10 = new byte[] { (byte)0xCA };
	private static byte[] BYTES_LONG_11 = new byte[] { (byte)0xCB };
	private static byte[] BYTES_LONG_12 = new byte[] { (byte)0xCC };
	private static byte[] BYTES_LONG_13 = new byte[] { (byte)0xCD };
	private static byte[] BYTES_LONG_14 = new byte[] { (byte)0xCE };
	private static byte[] BYTES_LONG_15 = new byte[] { (byte)0xCF };
	private static byte[] BYTES_LONG_N1 = new byte[] { (byte)0xD0 };
	private static byte[] BYTES_LONG_NEXT1 = new byte[] { (byte)0xD1 };
	private static byte[] BYTES_LONG_NEXT2 = new byte[] { (byte)0xD2 };
	private static byte[] BYTES_LONG_NEXT3 = new byte[] { (byte)0xD3 };
	private static byte[] BYTES_LONG_NEXT4 = new byte[] { (byte)0xD4 };
	private static byte[] BYTES_LONG_NEXT5 = new byte[] { (byte)0xD5 };
	private static byte[] BYTES_LONG_NEXT6 = new byte[] { (byte)0xD6 };
	private static byte[] BYTES_LONG_NEXT7 = new byte[] { (byte)0xD7 };
	private static byte[] BYTES_LONG_NEXT8 = new byte[] { (byte)0xD8 };
	private static byte[] BYTES_LONG_NEXT1_N = new byte[] { (byte)0xD9 };
	private static byte[] BYTES_LONG_NEXT2_N = new byte[] { (byte)0xDA };
	private static byte[] BYTES_LONG_NEXT3_N = new byte[] { (byte)0xDB };
	private static byte[] BYTES_LONG_NEXT4_N = new byte[] { (byte)0xDC };
	private static byte[] BYTES_LONG_NEXT5_N = new byte[] { (byte)0xDD };
	private static byte[] BYTES_LONG_NEXT6_N = new byte[] { (byte)0xDE };
	private static byte[] BYTES_LONG_NEXT7_N = new byte[] { (byte)0xDF };
	private static long N7BYTES_MAX = -72057594037927935L;
	private static byte[] BYTES_DOUBLE_0 = new byte[] { (byte)0xE0 };
	private static byte[] BYTES_DOUBLE_1 = new byte[] { (byte)0xE1 };
	private static byte[] BYTES_DOUBLE_2 = new byte[] { (byte)0xE2 };
	private static byte[] BYTES_DOUBLE_3 = new byte[] { (byte)0xE3 };
	private static byte[] BYTES_DOUBLE_4 = new byte[] { (byte)0xE4 };
	private static byte[] BYTES_DOUBLE_5 = new byte[] { (byte)0xE5 };
	private static byte[] BYTES_DOUBLE_6 = new byte[] { (byte)0xE6 };
	private static byte[] BYTES_DOUBLE_7 = new byte[] { (byte)0xE7 };
	private static byte[] BYTES_DOUBLE_8 = new byte[] { (byte)0xE8 };
	private static byte[] BYTES_DOUBLE_9 = new byte[] { (byte)0xE9 };
	private static byte[] BYTES_DOUBLE_10 = new byte[] { (byte)0xEA };
	private static byte[] BYTES_DOUBLE_11 = new byte[] { (byte)0xEB };
	private static byte[] BYTES_DOUBLE_12 = new byte[] { (byte)0xEC };
	private static byte[] BYTES_DOUBLE_13 = new byte[] { (byte)0xED };
	private static byte[] BYTES_DOUBLE_14 = new byte[] { (byte)0xEE };
	private static byte[] BYTES_DOUBLE_15 = new byte[] { (byte)0xEF };
	private static byte[] BYTES_DOUBLE_N1 = new byte[] { (byte)0xF0 };
	private static byte[] BYTES_DOUBLE_NEXT8 = new byte[] { (byte)0xF8 };
	private static byte[] BYTES_NULL = new byte[] { (byte)0xFF };
	private static Charset UTF8 = Charset.forName("UTF-8");
	
	private OutputStream out;
	private byte[] buf = new byte[8];
	
	public BytePacker(OutputStream out) {
		this.out = out;
	}
	
	public BytePacker writeNull() throws IOException {
		out.write(BYTES_NULL, 0, 1);
		return this;
	}
	
	public BytePacker writeString(String value) throws IOException {
		if(value == null) {
			out.write(BYTES_NULL, 0, 1);
		} else {
			if(value.length() == 0) {
				out.write(BYTES_STRING_EMPTY, 0, 1);
			} else {
				byte[] data = value.getBytes(UTF8);
				if(data.length < 127) {
					out.write(data.length);
					out.write(data);
				} else if(data.length <= MAX_STRING_LENGTH) {
					buf[0] = (byte)(0x80 | (data.length >> 8));
					buf[1] = (byte)(data.length);
					out.write(buf, 0, 2);
					out.write(data);
				} else {
					throw new IOException("string too long.");
				}
			}
		}
		
		return this;
	}
	
	public BytePacker writeLong(Long value) throws IOException {
		if(value == null) {
			out.write(BYTES_NULL, 0, 1);
		} else {
			writeLong(value.longValue());
		}
		return this;
	}
	
	public BytePacker writeLong(long value) throws IOException {
		if(value == 0L) {
			out.write(BYTES_LONG_0, 0, 1);
		} else if(value == 1L) {
			out.write(BYTES_LONG_1, 0, 1);
		} else if(value == 2L) {
			out.write(BYTES_LONG_2, 0, 1);
		} else if(value == 3L) {
			out.write(BYTES_LONG_3, 0, 1);
		} else if(value == 4L) {
			out.write(BYTES_LONG_4, 0, 1);
		} else if(value == 5L) {
			out.write(BYTES_LONG_5, 0, 1);
		} else if(value == 6L) {
			out.write(BYTES_LONG_6, 0, 1);
		} else if(value == 7L) {
			out.write(BYTES_LONG_7, 0, 1);
		} else if(value == 8L) {
			out.write(BYTES_LONG_8, 0, 1);
		} else if(value == 9L) {
			out.write(BYTES_LONG_9, 0, 1);
		} else if(value == 10L) {
			out.write(BYTES_LONG_10, 0, 1);
		} else if(value == 11L) {
			out.write(BYTES_LONG_11, 0, 1);
		} else if(value == 12L) {
			out.write(BYTES_LONG_12, 0, 1);
		} else if(value == 13L) {
			out.write(BYTES_LONG_13, 0, 1);
		} else if(value == 14L) {
			out.write(BYTES_LONG_14, 0, 1);
		} else if(value == 15L) {
			out.write(BYTES_LONG_15, 0, 1);
		} else if(value == -1L) {
			out.write(BYTES_LONG_N1, 0, 1);
		} else if(value > 0L) {
			int off = 0;
			buf[0] = (byte)(value >> 56);
			buf[1] = (byte)(value >> 48);
			buf[2] = (byte)(value >> 40);
			buf[3] = (byte)(value >> 32);
			buf[4] = (byte)(value >> 24);
			buf[5] = (byte)(value >> 16);
			buf[6] = (byte)(value >>  8);
			buf[7] = (byte)(value >>  0);
			if(buf[0] == 0) {
				off++;
				if(buf[1] == 0) {
					off++;
					if(buf[2] == 0) {
						off++;
						if(buf[3] == 0) {
							off++;
							if(buf[4] == 0) {
								off++;
								if(buf[5] == 0) {
									off++;
									if(buf[6] == 0) {
										off++;
									}
								}
							}
						}
					}
				}
			}
			int len = 8 - off;
			switch(len) {
			case 1: out.write(BYTES_LONG_NEXT1, 0, 1); break;
			case 2: out.write(BYTES_LONG_NEXT2, 0, 1); break;
			case 3: out.write(BYTES_LONG_NEXT3, 0, 1); break;
			case 4: out.write(BYTES_LONG_NEXT4, 0, 1); break;
			case 5: out.write(BYTES_LONG_NEXT5, 0, 1); break;
			case 6: out.write(BYTES_LONG_NEXT6, 0, 1); break;
			case 7: out.write(BYTES_LONG_NEXT7, 0, 1); break;
			case 8: out.write(BYTES_LONG_NEXT8, 0, 1); break;
			}
			out.write(buf, off, len);
		} else if(value >= N7BYTES_MAX) {
			value *= -1;
			int off = 0;
			buf[0] = (byte)(value >> 56);
			buf[1] = (byte)(value >> 48);
			buf[2] = (byte)(value >> 40);
			buf[3] = (byte)(value >> 32);
			buf[4] = (byte)(value >> 24);
			buf[5] = (byte)(value >> 16);
			buf[6] = (byte)(value >>  8);
			buf[7] = (byte)(value >>  0);
			if(buf[0] == 0) {
				off++;
				if(buf[1] == 0) {
					off++;
					if(buf[2] == 0) {
						off++;
						if(buf[3] == 0) {
							off++;
							if(buf[4] == 0) {
								off++;
								if(buf[5] == 0) {
									off++;
									if(buf[6] == 0) {
										off++;
									}
								}
							}
						}
					}
				}
			}
			int len = 8 - off;
			switch(len) {
			case 1: out.write(BYTES_LONG_NEXT1_N, 0, 1); break;
			case 2: out.write(BYTES_LONG_NEXT2_N, 0, 1); break;
			case 3: out.write(BYTES_LONG_NEXT3_N, 0, 1); break;
			case 4: out.write(BYTES_LONG_NEXT4_N, 0, 1); break;
			case 5: out.write(BYTES_LONG_NEXT5_N, 0, 1); break;
			case 6: out.write(BYTES_LONG_NEXT6_N, 0, 1); break;
			case 7: out.write(BYTES_LONG_NEXT7_N, 0, 1); break;
			}
			out.write(buf, off, len);
		} else {
			buf[0] = (byte)(value >> 56);
			buf[1] = (byte)(value >> 48);
			buf[2] = (byte)(value >> 40);
			buf[3] = (byte)(value >> 32);
			buf[4] = (byte)(value >> 24);
			buf[5] = (byte)(value >> 16);
			buf[6] = (byte)(value >>  8);
			buf[7] = (byte)(value >>  0);
			out.write(BYTES_LONG_NEXT8, 0, 1);
			out.write(buf, 0, 8);
		}
		return this;
	}

	public BytePacker writeDouble(Double value) throws IOException {
		if(value == null) {
			out.write(BYTES_NULL, 0, 1);
		} else {
			writeDouble(value.doubleValue());
		}
		return this;
	}
	
	public BytePacker writeDouble(double value) throws IOException {
		if(value == 0.0D) {
			out.write(BYTES_DOUBLE_0, 0, 1);
		} else if(value == 1.0D) {
			out.write(BYTES_DOUBLE_1, 0, 1);
		} else if(value == 2.0D) {
			out.write(BYTES_DOUBLE_2, 0, 1);
		} else if(value == 3.0D) {
			out.write(BYTES_DOUBLE_3, 0, 1);
		} else if(value == 4.0D) {
			out.write(BYTES_DOUBLE_4, 0, 1);
		} else if(value == 5.0D) {
			out.write(BYTES_DOUBLE_5, 0, 1);
		} else if(value == 6.0D) {
			out.write(BYTES_DOUBLE_6, 0, 1);
		} else if(value == 7.0D) {
			out.write(BYTES_DOUBLE_7, 0, 1);
		} else if(value == 8.0D) {
			out.write(BYTES_DOUBLE_8, 0, 1);
		} else if(value == 9.0D) {
			out.write(BYTES_DOUBLE_9, 0, 1);
		} else if(value == 10.0D) {
			out.write(BYTES_DOUBLE_10, 0, 1);
		} else if(value == 11.0D) {
			out.write(BYTES_DOUBLE_11, 0, 1);
		} else if(value == 12.0D) {
			out.write(BYTES_DOUBLE_12, 0, 1);
		} else if(value == 13.0D) {
			out.write(BYTES_DOUBLE_13, 0, 1);
		} else if(value == 14.0D) {
			out.write(BYTES_DOUBLE_14, 0, 1);
		} else if(value == 15.0D) {
			out.write(BYTES_DOUBLE_15, 0, 1);
		} else if(value == -1.0D) {
			out.write(BYTES_DOUBLE_N1, 0, 1);
		} else {
			long v = Double.doubleToLongBits(value);
			buf[0] = (byte)(v >> 56);
			buf[1] = (byte)(v >> 48);
			buf[2] = (byte)(v >> 40);
			buf[3] = (byte)(v >> 32);
			buf[4] = (byte)(v >> 24);
			buf[5] = (byte)(v >> 16);
			buf[6] = (byte)(v >>  8);
			buf[7] = (byte)(v >>  0);
			out.write(BYTES_DOUBLE_NEXT8, 0, 1);
			out.write(buf, 0, 8);
		}
		return this;
	}
	
/*
0000 0000 String (length=0)

0000 0001 String (length=1)
    |
0111 1111 String (length=127)

10xx xxxx xxxx xxxx String(length=)

1100 0000 Long(0)
    |
1100 1111 Long(15)

1101 0000 Long(-1)

1101 0001 Long 次の1バイト
1101 0010 Long 次の2バイト
1101 0011 Long 次の3バイト
1101 0100 Long 次の4バイト
1101 0101 Long 次の5バイト
1101 0110 Long 次の6バイト
1101 0111 Long 次の7バイト
1101 1000 Long 次の8バイト

1101 1001 Long 次の1バイト(負数)
1101 1010 Long 次の2バイト(負数)
1101 1011 Long 次の3バイト(負数)
1101 1100 Long 次の4バイト(負数)
1101 1101 Long 次の5バイト(負数)
1101 1110 Long 次の6バイト(負数)
1101 1111 Long 次の7バイト(負数)

1110 0000 Double(0)
    |
1110 1111 Double(15)

1111 0000 Double(-1)
1111 0001 未定義(1)
       |
1111 0111 未定義(7)
1111 1000 Double 次の8バイト
1111 1001 未定義(9)
       |
1111 1110 未定義(15)

1111 1111 Null
*/

}
