/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.concurrent;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Monitor {
    private final Object notifySynchronizer = new Object();
    private final Object lockSynchronizer = new Object();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private volatile Object object;

    public MultipleObjects newMultipleObjects(Object ... objects) {
        return new MultipleObjects(0L, objects);
    }

    public MultipleObjects newMultipleObjects(Collection<?> objects) {
        return new MultipleObjects(0L, objects);
    }

    public MultipleObjects newMultipleObjects(long timeout, Object ... objects) {
        return new MultipleObjects(timeout, objects);
    }

    public MultipleObjects newMultipleObjects(long timeout, Collection<?> objects) {
        return new MultipleObjects(timeout, objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAll(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Object object2 = this.lockSynchronizer;
        synchronized (object2) {
            this.object = object;
            Object object3 = this.notifySynchronizer;
            synchronized (object3) {
                this.notifySynchronizer.notifyAll();
            }
            try {
                this.lock.writeLock().lock();
                this.object = null;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    public class MultipleObjects {
        private long startNanoTime = System.nanoTime();
        private long timeout;
        private Set<Object> objects;

        protected MultipleObjects(long timeout, Object ... objects) {
            if (timeout < 0L) {
                throw new IllegalArgumentException();
            }
            if (objects == null) {
                throw new IllegalArgumentException();
            }
            this.timeout = timeout;
            this.objects = new HashSet<Object>(Arrays.asList(objects));
        }

        protected MultipleObjects(long timeout, Collection<?> objects) {
            if (objects == null) {
                throw new IllegalArgumentException();
            }
            if (objects.size() == 0) {
                throw new IllegalArgumentException();
            }
            this.timeout = timeout;
            this.objects = new HashSet(objects);
        }

        public void setTimeout(long timeout) {
            if (timeout < 0L) {
                throw new IllegalArgumentException();
            }
            this.timeout = timeout;
            this.startNanoTime = System.nanoTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object waitForMultipleObjects() throws InterruptedException {
            long restMillis;
            if (this.timeout <= 0L) {
                while (true) {
                    Object object;
                    try {
                        Monitor.this.lock.readLock().lock();
                        object = Monitor.this.notifySynchronizer;
                        synchronized (object) {
                            Monitor.this.notifySynchronizer.wait();
                        }
                        if (Monitor.this.object != null && this.objects.contains(Monitor.this.object)) {
                            object = Monitor.this.object;
                            return object;
                        }
                    }
                    finally {
                        Monitor.this.lock.readLock().unlock();
                    }
                    object = Monitor.this.lockSynchronizer;
                    synchronized (object) {
                    }
                }
            }
            while ((restMillis = this.timeout - (System.nanoTime() - this.startNanoTime) / 1000000L) > 0L) {
                Object object;
                try {
                    Monitor.this.lock.readLock().lock();
                    object = Monitor.this.notifySynchronizer;
                    synchronized (object) {
                        Monitor.this.notifySynchronizer.wait(restMillis);
                    }
                    if (Monitor.this.object != null && this.objects.contains(Monitor.this.object)) {
                        object = Monitor.this.object;
                        return object;
                    }
                }
                finally {
                    Monitor.this.lock.readLock().unlock();
                }
                object = Monitor.this.lockSynchronizer;
                synchronized (object) {
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object waitForMultipleObjects(long timeout) throws InterruptedException {
            long restMillis;
            if (timeout < 0L) {
                throw new IllegalArgumentException();
            }
            if (timeout == 0L) {
                while (true) {
                    Object object;
                    try {
                        Monitor.this.lock.readLock().lock();
                        object = Monitor.this.notifySynchronizer;
                        synchronized (object) {
                            Monitor.this.notifySynchronizer.wait();
                        }
                        if (Monitor.this.object != null && this.objects.contains(Monitor.this.object)) {
                            object = Monitor.this.object;
                            return object;
                        }
                    }
                    finally {
                        Monitor.this.lock.readLock().unlock();
                    }
                    object = Monitor.this.lockSynchronizer;
                    synchronized (object) {
                    }
                }
            }
            long startNanoTime = System.nanoTime();
            while ((restMillis = timeout - (System.nanoTime() - startNanoTime) / 1000000L) > 0L) {
                Object object;
                try {
                    Monitor.this.lock.readLock().lock();
                    object = Monitor.this.notifySynchronizer;
                    synchronized (object) {
                        Monitor.this.notifySynchronizer.wait(restMillis);
                    }
                    if (Monitor.this.object != null && this.objects.contains(Monitor.this.object)) {
                        object = Monitor.this.object;
                        return object;
                    }
                }
                finally {
                    Monitor.this.lock.readLock().unlock();
                }
                object = Monitor.this.lockSynchronizer;
                synchronized (object) {
                }
            }
            return null;
        }
    }
}

