/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class NamedParameter {
    private Method method;
    private int index;
    private String name;
    private Object value;
    private long length;
    private Calendar calendar;
    private int type;
    private String typeName;

    public NamedParameter(Method method, int index, String name, Object value) {
        this.method = method;
        this.index = index;
        this.name = name;
        this.value = value;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setIndex(int index) {
        if (index <= 0) {
            throw new IllegalArgumentException();
        }
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public long getLength() {
        return this.length;
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void applyTo(PreparedStatement st) throws SQLException {
        switch (this.method) {
            case SET_ARRAY: {
                st.setArray(this.index, (Array)this.value);
                break;
            }
            case SET_ASCII_STREAM: {
                if (this.length > 0L) {
                    st.setAsciiStream(this.index, (InputStream)this.value, this.length);
                    break;
                }
                st.setAsciiStream(this.index, (InputStream)this.value);
                break;
            }
            case SET_BIG_DECIMAL: {
                st.setBigDecimal(this.index, (BigDecimal)this.value);
                break;
            }
            case SET_BINARY_STREAM: {
                if (this.length > 0L) {
                    st.setBinaryStream(this.index, (InputStream)this.value, this.length);
                    break;
                }
                st.setBinaryStream(this.index, (InputStream)this.value);
                break;
            }
            case SET_BLOB: {
                if (this.length > 0L) {
                    st.setBlob(this.index, (InputStream)this.value, this.length);
                    break;
                }
                if (this.value instanceof InputStream) {
                    st.setBlob(this.index, (InputStream)this.value);
                    break;
                }
                st.setBlob(this.index, (Blob)this.value);
                break;
            }
            case SET_BOOLEAN: {
                st.setBoolean(this.index, (Boolean)this.value);
                break;
            }
            case SET_BYTE: {
                st.setByte(this.index, (Byte)this.value);
                break;
            }
            case SET_BYTES: {
                st.setBytes(this.index, (byte[])this.value);
                break;
            }
            case SET_CHARACTER_STREAM: {
                if (this.length > 0L) {
                    st.setCharacterStream(this.index, (Reader)this.value, this.length);
                    break;
                }
                st.setCharacterStream(this.index, (Reader)this.value);
                break;
            }
            case SET_CLOB: {
                if (this.length > 0L) {
                    st.setClob(this.index, (Reader)this.value, this.length);
                    break;
                }
                if (this.value instanceof Reader) {
                    st.setClob(this.index, (Reader)this.value);
                    break;
                }
                st.setClob(this.index, (Clob)this.value);
                break;
            }
            case SET_DATE: {
                if (this.calendar != null) {
                    st.setDate(this.index, (Date)this.value, this.calendar);
                    break;
                }
                st.setDate(this.index, (Date)this.value);
                break;
            }
            case SET_DOUBLE: {
                st.setDouble(this.index, (Double)this.value);
                break;
            }
            case SET_FLOAT: {
                st.setFloat(this.index, ((Float)this.value).floatValue());
                break;
            }
            case SET_INT: {
                st.setInt(this.index, (Integer)this.value);
                break;
            }
            case SET_LONG: {
                st.setLong(this.index, (Long)this.value);
                break;
            }
            case SET_NCHARACTER_STREAM: {
                if (this.length > 0L) {
                    st.setNCharacterStream(this.index, (Reader)this.value, this.length);
                    break;
                }
                st.setNCharacterStream(this.index, (Reader)this.value);
                break;
            }
            case SET_NCLOB: {
                if (this.length > 0L) {
                    st.setNClob(this.index, (Reader)this.value, this.length);
                    break;
                }
                if (this.value instanceof Reader) {
                    st.setNClob(this.index, (Reader)this.value);
                    break;
                }
                st.setNClob(this.index, (NClob)this.value);
                break;
            }
            case SET_NSTRING: {
                st.setNString(this.index, (String)this.value);
                break;
            }
            case SET_NULL: {
                if (this.typeName != null) {
                    st.setNull(this.index, this.type, this.typeName);
                    break;
                }
                st.setNull(this.index, this.type);
                break;
            }
            case SET_OBJECT: {
                if (this.type != 0) {
                    if (this.length > 0L) {
                        st.setObject(this.index, this.value, this.type, (int)this.length);
                        break;
                    }
                    st.setObject(this.index, this.value, this.type);
                    break;
                }
                st.setObject(this.index, this.value);
                break;
            }
            case SET_REF: {
                st.setRef(this.index, (Ref)this.value);
                break;
            }
            case SET_ROWID: {
                st.setRowId(this.index, (RowId)this.value);
                break;
            }
            case SET_SHORT: {
                st.setShort(this.index, (Short)this.value);
                break;
            }
            case SET_SQLXML: {
                st.setSQLXML(this.index, (SQLXML)this.value);
                break;
            }
            case SET_STRING: {
                st.setString(this.index, (String)this.value);
                break;
            }
            case SET_TIME: {
                if (this.calendar != null) {
                    st.setTime(this.index, (Time)this.value, this.calendar);
                    break;
                }
                st.setTime(this.index, (Time)this.value);
                break;
            }
            case SET_TIMESTAMP: {
                if (this.calendar != null) {
                    st.setTimestamp(this.index, (Timestamp)this.value, this.calendar);
                    break;
                }
                st.setTimestamp(this.index, (Timestamp)this.value);
                break;
            }
            case SET_URL: {
                st.setURL(this.index, (URL)this.value);
                break;
            }
            default: {
                st.setObject(this.index, this.value);
            }
        }
    }

    public static enum Method {
        SET_ARRAY,
        SET_ASCII_STREAM,
        SET_BIG_DECIMAL,
        SET_BINARY_STREAM,
        SET_BLOB,
        SET_BOOLEAN,
        SET_BYTE,
        SET_BYTES,
        SET_CHARACTER_STREAM,
        SET_CLOB,
        SET_DATE,
        SET_DOUBLE,
        SET_FLOAT,
        SET_INT,
        SET_LONG,
        SET_NCHARACTER_STREAM,
        SET_NCLOB,
        SET_NSTRING,
        SET_NULL,
        SET_OBJECT,
        SET_REF,
        SET_ROWID,
        SET_SHORT,
        SET_SQLXML,
        SET_STRING,
        SET_TIME,
        SET_TIMESTAMP,
        SET_URL;

    }
}

