/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.sql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.rowset.CachedRowSet;
import net.osdn.util.sql.NamedParameter;
import net.osdn.util.sql.NamedParameterStatement;

public class Sql {
    private static final EmptyParameter EMPTY = new EmptyParameter();
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("'(?:''|[^'])*'|--.*?$|\\/\\*.*?\\*\\/|(\\?)", 40);
    private String original;
    private Object[] parameters;
    private String sql;
    private CachedRowSet result;
    private int affectedRows = -1;

    protected Sql(String sql) {
        this(sql, new Object[0]);
    }

    protected Sql(String sql, Object[] parameters) {
        this.original = sql;
        this.parameters = parameters;
        if (this.parameters == null) {
            this.parameters = new Object[0];
        }
        if (this.parameters.length == 0) {
            this.sql = sql;
        }
    }

    protected Sql(NamedParameterStatement statement) {
        this.original = statement.getSql();
        int maxIndex = 0;
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        for (NamedParameter np : statement.getParameters()) {
            if (np.getIndex() > maxIndex) {
                maxIndex = np.getIndex();
            }
            map.put(np.getIndex(), np.getValue());
        }
        this.parameters = new Object[maxIndex];
        for (int i = 1; i <= maxIndex; ++i) {
            this.parameters[i - 1] = map.containsKey(i) ? map.get(i) : EMPTY;
        }
    }

    protected void setResult(CachedRowSet rowSet) {
        this.result = rowSet;
    }

    public CachedRowSet getResult() {
        return this.result;
    }

    protected void setAffectedRows(int rows) {
        this.affectedRows = rows;
    }

    public int getAffectedRows() {
        return this.affectedRows;
    }

    public String getOriginalSql() {
        return this.original;
    }

    public String replaceParameterWithValue() {
        if (this.sql != null) {
            return this.sql;
        }
        try {
            int i = 0;
            StringBuffer sb = new StringBuffer();
            Matcher m = PARAMETER_PATTERN.matcher(this.original);
            while (m.find()) {
                if (m.group(1) == null) continue;
                String value = i < this.parameters.length ? Sql.convert(this.parameters[i++]) : "?";
                if (!"?".equals(value)) {
                    value = "(" + value + ")";
                }
                m.appendReplacement(sb, value);
            }
            m.appendTail(sb);
            this.sql = sb.toString();
        }
        catch (Throwable e) {
            this.sql = this.original;
        }
        return this.sql;
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        BufferedReader r = null;
        try {
            String line;
            String sql = this.replaceParameterWithValue();
            r = new BufferedReader(new StringReader(sql));
            while ((line = r.readLine()) != null) {
                sb.append(' ');
                sb.append(line.trim());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (sb.length() >= 1) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public String toString() {
        return this.dump();
    }

    protected static String convert(Object parameter) {
        if (parameter == null) {
            return "null";
        }
        if (parameter instanceof String) {
            String s = (String)parameter;
            return "'" + s.replaceAll("'", "''") + "'";
        }
        if (parameter instanceof Number) {
            return parameter.toString();
        }
        if (parameter instanceof Date) {
            String s = DateTimeFormatter.ISO_LOCAL_DATE.format(((Date)parameter).toLocalDate());
            return "'" + s + "'";
        }
        if (parameter instanceof Time) {
            String s = DateTimeFormatter.ISO_LOCAL_TIME.format(((Time)parameter).toLocalTime());
            return "'" + s + "'";
        }
        if (parameter instanceof Timestamp) {
            String s = DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(((Timestamp)parameter).toLocalDateTime());
            return "'" + s.replace('T', ' ') + "'";
        }
        if (parameter instanceof java.util.Date) {
            LocalDateTime ldt = LocalDateTime.ofInstant(((java.util.Date)parameter).toInstant(), ZoneId.systemDefault());
            String s = DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(ldt);
            return "'" + s.replace('T', ' ') + "'";
        }
        if (parameter instanceof LocalDate) {
            String s = DateTimeFormatter.ISO_LOCAL_DATE.format((LocalDate)parameter);
            return "'" + s + "'";
        }
        if (parameter instanceof LocalTime) {
            String s = DateTimeFormatter.ISO_LOCAL_TIME.format((LocalTime)parameter);
            return "'" + s + "'";
        }
        if (parameter instanceof LocalDateTime) {
            String s = DateTimeFormatter.ISO_LOCAL_DATE_TIME.format((LocalDateTime)parameter);
            return "'" + s.replace('T', ' ') + "'";
        }
        if (parameter instanceof OffsetTime) {
            String s = DateTimeFormatter.ISO_OFFSET_TIME.format((OffsetTime)parameter);
            return "'" + s + "'";
        }
        if (parameter instanceof OffsetDateTime) {
            String s = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format((OffsetDateTime)parameter);
            return "'" + s.replace('T', ' ') + "'";
        }
        if (parameter instanceof EmptyParameter) {
            return "?";
        }
        String s = parameter.toString();
        return "'" + s.replaceAll("'", "''") + "'";
    }

    private static class EmptyParameter {
        private EmptyParameter() {
        }
    }
}

