package jp.sourceforge.masasa.architecture.framework.validation.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import jp.sourceforge.masasa.architecture.framework.validation.enumeration.CheckRulesEnum;

/**
 * 各チェックルールを示すアノテーション. <br>
 * 各チェックルールでは必ず必要.
 * 
 * @author masasa.
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.ANNOTATION_TYPE)
public @interface ValidateResolver {
    /**
     * チェックルールを返却します.
     * 
     * @see CheckRulesEnum
     */
    CheckRulesEnum value();
}
