"""
System Name: Vasyworks
Project Name: vacancy_mgr
Encoding: UTF-8
Copyright (C) 2020 Yasuhiro Yamamoto
"""
import re
from django import forms
from django.utils.translation import gettext_lazy as _
from property.models import Room


class EditRoomForm(forms.ModelForm):
    """
    部屋フォーム
    """
    class Meta:
        model = Room
        fields = [
            'room_no',
            'room_floor',
            'rental_type',
            'room_auth_level',
            'is_sublease',
            'is_entrusted',
            'is_condo_management',
            'condo_owner',
            'condo_trader',
            'room_status',
            'vacancy_status',
            'vacancy_status_note',
            'live_start_year',
            'live_start_month',
            'live_start_day',
            'live_start_note',
            'cancel_scheduled_year',
            'cancel_scheduled_month',
            'cancel_scheduled_day',
            'cancel_scheduled_note',
            'is_publish_vacancy',
            'vacancy_start_date',
            'vacancy_end_date',
            'vacancy_catch_copy',
            'vacancy_appeal',
            'vacancy_note',
            'pending_trader_name',
            'pending_start_date',
            'pending_end_date',
            'pending_note',
            'is_publish_web',
            'web_catch_copy',
            'web_appeal',
            'web_note',
            'layout_type',
            'western_style_room1',
            'western_style_room2',
            'western_style_room3',
            'western_style_room4',
            'western_style_room5',
            'western_style_room6',
            'western_style_room7',
            'western_style_room8',
            'western_style_room9',
            'western_style_room10',
            'japanese_style_room1',
            'japanese_style_room2',
            'japanese_style_room3',
            'japanese_style_room4',
            'japanese_style_room5',
            'japanese_style_room6',
            'japanese_style_room7',
            'japanese_style_room8',
            'japanese_style_room9',
            'japanese_style_room10',
            'kitchen_type1',
            'kitchen1',
            'kitchen_type2',
            'kitchen2',
            'kitchen_type3',
            'kitchen3',
            'store_room1',
            'store_room2',
            'store_room3',
            'loft1',
            'loft2',
            'sun_room1',
            'sun_room2',
            'layout_note',
            'room_area',
            'direction',
            'balcony_type',
            'balcony_area',
            'rent',
            'rent_upper',
            'trader_rent',
            'rent_tax_type',
            'rent_hidden',
            'condo_fees_type',
            'condo_fees',
            'condo_fees_tax_type',
            'water_cost_type',
            'water_cost',
            'water_cost_tax_type',
            'water_check_type',
            'payment_type',
            'payment_fee_type',
            'payment_fee',
            'payment_fee_tax_type',
            'monthly_cost_name1',
            'monthly_cost1',
            'monthly_cost_tax_type1',
            'monthly_cost_name2',
            'monthly_cost2',
            'monthly_cost_tax_type2',
            'monthly_cost_name3',
            'monthly_cost3',
            'monthly_cost_tax_type3',
            'monthly_cost_name4',
            'monthly_cost4',
            'monthly_cost_tax_type4',
            'monthly_cost_name5',
            'monthly_cost5',
            'monthly_cost_tax_type5',
            'monthly_cost_name6',
            'monthly_cost6',
            'monthly_cost_tax_type6',
            'monthly_cost_name7',
            'monthly_cost7',
            'monthly_cost_tax_type7',
            'monthly_cost_name8',
            'monthly_cost8',
            'monthly_cost_tax_type8',
            'monthly_cost_name9',
            'monthly_cost9',
            'monthly_cost_tax_type9',
            'monthly_cost_name10',
            'monthly_cost10',
            'monthly_cost_tax_type10',
            'monthly_cost_note',
            'deposit_type1',
            'deposit_notation1',
            'deposit_value1',
            'deposit_tax_type1',
            'deposit_comment1',
            'deposit_type2',
            'deposit_notation2',
            'deposit_value2',
            'deposit_tax_type2',
            'deposit_comment2',
            'key_money_type1',
            'key_money_notation1',
            'key_money_value1',
            'key_money_tax_type1',
            'key_money_comment1',
            'key_money_type2',
            'key_money_notation2',
            'key_money_value2',
            'key_money_tax_type2',
            'key_money_comment2',
            'contract_years',
            'contract_months',
            'renewal_fee_notation',
            'renewal_fee_value',
            'renewal_fee_tax_type',
            'renewal_charge_existence',
            'renewal_charge',
            'renewal_charge_tax_type',
            'is_auto_renewal',
            'renewal_note',
            'recontract_fee_existence',
            'recontract_fee',
            'recontract_fee_tax_type',
            'recontract_note',
            'insurance_type',
            'insurance_company',
            'insurance_years',
            'insurance_fee',
            'insurance_fee_tax_type',
            'guarantee_type',
            'guarantee_company',
            'guarantee_fee',
            'document_cost_existence',
            'document_cost',
            'document_cost_tax_type',
            'document_cost_comment',
            'key_change_cost_existence',
            'key_change_cost',
            'key_change_cost_tax_type',
            'key_change_comment',
            'initial_cost_name1',
            'initial_cost1',
            'initial_cost_tax_type1',
            'initial_cost_name2',
            'initial_cost2',
            'initial_cost_tax_type2',
            'initial_cost_name3',
            'initial_cost3',
            'initial_cost_tax_type3',
            'initial_cost_name4',
            'initial_cost4',
            'initial_cost_tax_type4',
            'initial_cost_name5',
            'initial_cost5',
            'initial_cost_tax_type5',
            'initial_cost_name6',
            'initial_cost6',
            'initial_cost_tax_type6',
            'initial_cost_name7',
            'initial_cost7',
            'initial_cost_tax_type7',
            'initial_cost_name8',
            'initial_cost8',
            'initial_cost_tax_type8',
            'initial_cost_name9',
            'initial_cost9',
            'initial_cost_tax_type9',
            'initial_cost_name10',
            'initial_cost10',
            'initial_cost_tax_type10',
            'initial_cost_note',
            'free_rent_type',
            'free_rent_months',
            'free_rent_limit_year',
            'free_rent_limit_month',
            'cancel_notice_limit',
            'cancel_note',
            'short_cancel_note',
            'cleaning_type',
            'cleaning_cost',
            'cleaning_cost_tax_type',
            'cleaning_note',
            'special_agreement',
            'electric_type',
            'electric_comment',
            'gas_type',
            'gas_comment',
            'bath_type',
            'bath_comment',
            'toilet_type',
            'toilet_comment',
            'kitchen_range_type',
            'kitchen_range_comment',
            'internet_type',
            'internet_comment',
            'washer_type',
            'washer_comment',
            'pet_type',
            'pet_comment',
            'instrument_type',
            'live_together_type',
            'children_type',
            'share_type',
            'non_japanese_type',
            'only_woman_type',
            'only_man_type',
            'corp_contract_type',
            'student_type',
            'new_student_type',
            'welfare_type',
            'office_use_type',
            'constraint_note',
            'reform_comment',
            'reform_year',
            'reform_month',
            'reform_note',
            'trader_publish_type',
            'trader_publish_note',
            'trader_portal_type',
            'trader_portal_note',
            'ad_type',
            'ad_value',
            'ad_tax_type',
            'trader_ad_type',
            'trader_ad_value',
            'trader_ad_tax_type',
            'owner_fee_type',
            'key_no',
            'key_place_note',
            'private_note',
            'management_note',
        ]
        labels = {
            'room_no': _('部屋番号'),
            'room_floor': _('部屋階数'),
            'rental_type': _('賃貸種別'),
            'room_auth_level': _('閲覧レベル'),
            'is_sublease': _('部屋借上フラグ'),
            'is_entrusted': _('部屋専任フラグ'),
            'is_condo_management': _('分譲管理フラグ'),
            'condo_owner': _('分譲オーナー'),
            'condo_trader': _('分譲管理業者'),
            'room_status': _('部屋状況'),
            'vacancy_status': _('空室状況'),
            'vacancy_status_note': _('空室状況備考'),
            'live_start_year': _('入居可能年'),
            'live_start_month': _('入居可能年'),
            'live_start_day': _('入居可能日'),
            'live_start_note': _('入居可能日備考'),
            'cancel_scheduled_year': _('解約予定年'),
            'cancel_scheduled_month': _('解約予定月'),
            'cancel_scheduled_day': _('解約予定日'),
            'cancel_scheduled_note': _('解約予定備考'),
            'is_publish_vacancy': _('空室情報公開フラグ'),
            'vacancy_start_date': _('空室情報公開開始日'),
            'vacancy_end_date': _('空室情報公開終了日'),
            'vacancy_catch_copy': _('空室情報キャッチコピー'),
            'vacancy_appeal': _('空室情報アピール'),
            'vacancy_note': _('空室情報備考'),
            'pending_trader_name': _('保留業者'),
            'pending_start_date': _('保留開始日'),
            'pending_end_date': _('保留終了日'),
            'pending_note': _('保留備考'),
            'is_publish_web': _('WEB公開フラグ'),
            'web_catch_copy': _('WEBサイトキャッチコピー'),
            'web_appeal': _('WEBサイトアピール'),
            'web_note': _('WEBサイト公開備考'),
            'layout_type': _('間取種別'),
            'western_style_room1': _('洋室詳細1'),
            'western_style_room2': _('洋室詳細2'),
            'western_style_room3': _('洋室詳細3'),
            'western_style_room4': _('洋室詳細4'),
            'western_style_room5': _('洋室詳細5'),
            'western_style_room6': _('洋室詳細6'),
            'western_style_room7': _('洋室詳細7'),
            'western_style_room8': _('洋室詳細8'),
            'western_style_room9': _('洋室詳細9'),
            'western_style_room10': _('洋室詳細10'),
            'japanese_style_room1': _('和室詳細1'),
            'japanese_style_room2': _('和室詳細2'),
            'japanese_style_room3': _('和室詳細3'),
            'japanese_style_room4': _('和室詳細4'),
            'japanese_style_room5': _('和室詳細5'),
            'japanese_style_room6': _('和室詳細6'),
            'japanese_style_room7': _('和室詳細7'),
            'japanese_style_room8': _('和室詳細8'),
            'japanese_style_room9': _('和室詳細9'),
            'japanese_style_room10': _('和室詳細10'),
            'kitchen_type1': _('キッチン種別1'),
            'kitchen1': _('キッチン詳細1'),
            'kitchen_type2': _('キッチン種別2'),
            'kitchen2': _('キッチン詳細2'),
            'kitchen_type3': _('キッチン種別3'),
            'kitchen3': _('キッチン詳細3'),
            'store_room1': _('納戸詳細1'),
            'store_room2': _('納戸詳細2'),
            'store_room3': _('納戸詳細3'),
            'loft1': _('ロフト詳細1'),
            'loft2': _('ロフト詳細2'),
            'sun_room1': _('サンルーム1'),
            'sun_room2': _('サンルーム2'),
            'layout_note': _('間取備考'),
            'room_area': _('部屋面積'),
            'direction': _('部屋方向'),
            'balcony_type': _('バルコニ種別マスタ'),
            'balcony_area': _('バルコニ面積'),
            'rent': _('賃料'),
            'rent_upper': _('賃料上限'),
            'trader_rent': _('業者賃料'),
            'rent_tax_type': _('賃料税種別'),
            'rent_hidden': _('賃料非表示フラグ'),
            'condo_fees_type': _('共益費種別'),
            'condo_fees': _('共益費'),
            'condo_fees_tax_type': _('共益費税種別'),
            'water_cost_type': _('水道費種別ID'),
            'water_cost': _('水道費'),
            'water_cost_tax_type': _('水道費税種別'),
            'water_check_type': _('水道検針種別'),
            'payment_type': _('支払種別ID'),
            'payment_fee_type': _('支払手数料種別'),
            'payment_fee': _('支払手数料'),
            'payment_fee_tax_type': _('支払手数料税種別'),
            'monthly_cost_name1': _('月額費用名1'),
            'monthly_cost1': _('月額費用金額1'),
            'monthly_cost_tax_type1': _('月額費用税種別1'),
            'monthly_cost_name2': _('月額費用名2'),
            'monthly_cost2': _('月額費用金額2'),
            'monthly_cost_tax_type2': _('月額費用税種別2'),
            'monthly_cost_name3': _('月額費用名3'),
            'monthly_cost3': _('月額費用金額3'),
            'monthly_cost_tax_type3': _('月額費用税種別3'),
            'monthly_cost_name4': _('月額費用名4'),
            'monthly_cost4': _('月額費用金額4'),
            'monthly_cost_tax_type4': _('月額費用税種別4'),
            'monthly_cost_name5': _('月額費用名5'),
            'monthly_cost5': _('月額費用金額5'),
            'monthly_cost_tax_type5': _('月額費用税種別5'),
            'monthly_cost_name6': _('月額費用名6'),
            'monthly_cost6': _('月額費用金額6'),
            'monthly_cost_tax_type6': _('月額費用税種別6'),
            'monthly_cost_name7': _('月額費用名7'),
            'monthly_cost7': _('月額費用金額7'),
            'monthly_cost_tax_type7': _('月額費用税種別7'),
            'monthly_cost_name8': _('月額費用名8'),
            'monthly_cost8': _('月額費用金額8'),
            'monthly_cost_tax_type8': _('月額費用税種別8'),
            'monthly_cost_name9': _('月額費用名9'),
            'monthly_cost9': _('月額費用金額9'),
            'monthly_cost_tax_type9': _('月額費用税種別9'),
            'monthly_cost_name10': _('月額費用名10'),
            'monthly_cost10': _('月額費用金額10'),
            'monthly_cost_tax_type10': _('月額費用税種別10'),
            'monthly_cost_note': _('月額費用備考'),
            'deposit_type1': _('保証金種別1'),
            'deposit_notation1': _('保証金表記1'),
            'deposit_value1': _('保証金値1'),
            'deposit_tax_type1': _('保証金税種別1'),
            'deposit_comment1': _('保証金コメント1'),
            'deposit_type2': _('保証金種別2'),
            'deposit_notation2': _('保証金表記2'),
            'deposit_value2': _('保証金値2'),
            'deposit_tax_type2': _('保証金税種別2'),
            'deposit_comment2': _('保証金コメント2'),
            'key_money_type1': _('一時金種別1'),
            'key_money_notation1': _('一時金表記1'),
            'key_money_value1': _('一時金値1'),
            'key_money_tax_type1': _('一時金税種別1'),
            'key_money_comment1': _('一時金コメント1'),
            'key_money_type2': _('一時金種別2'),
            'key_money_notation2': _('一時金表記2'),
            'key_money_value2': _('一時金値2'),
            'key_money_tax_type2': _('一時金税種別2'),
            'key_money_comment2': _('一時金コメント2'),
            'contract_years': _('契約年数'),
            'contract_months': _('契約月数'),
            'renewal_fee_notation': _('更新料表記'),
            'renewal_fee_value': _('更新料値'),
            'renewal_fee_tax_type': _('更新料税種別'),
            'renewal_charge_existence': _('更新事務手数料有無'),
            'renewal_charge': _('更新事務手数料'),
            'renewal_charge_tax_type': _('更新事務手数料税種別'),
            'is_auto_renewal': _('自動更新フラグ'),
            'renewal_note': _('更新備考'),
            'recontract_fee_existence': _('再契約料有無'),
            'recontract_fee': _('再契約料'),
            'recontract_fee_tax_type': _('再契約料税区分'),
            'recontract_note': _('再契約備考'),
            'insurance_type': _('火災保険種別'),
            'insurance_company': _('火災保険会社名'),
            'insurance_years': _('火災保険年数'),
            'insurance_fee': _('火災保険料'),
            'insurance_fee_tax_type': _('火災保険料税種別'),
            'guarantee_type': _('保証会社種別'),
            'guarantee_company': _('保証会社名'),
            'guarantee_fee': _('保証料'),
            'document_cost_existence': _('書類代有無'),
            'document_cost': _('書類代'),
            'document_cost_tax_type': _('書類代税種別'),
            'document_cost_comment': _('書類代コメント'),
            'key_change_cost_existence': _('鍵交換代有無'),
            'key_change_cost': _('鍵交換代'),
            'key_change_cost_tax_type': _('鍵交換代税種別'),
            'key_change_comment': _('鍵交換コメント'),
            'initial_cost_name1': _('初期費用名1'),
            'initial_cost1': _('初期費用1'),
            'initial_cost_tax_type1': _('初期費用税種別1'),
            'initial_cost_name2': _('初期費用名2'),
            'initial_cost2': _('初期費用2'),
            'initial_cost_tax_type2': _('初期費用税種別2'),
            'initial_cost_name3': _('初期費用名3'),
            'initial_cost3': _('初期費用3'),
            'initial_cost_tax_type3': _('初期費用税種別3'),
            'initial_cost_name4': _('初期費用名4'),
            'initial_cost4': _('初期費用4'),
            'initial_cost_tax_type4': _('初期費用税種別4'),
            'initial_cost_name5': _('初期費用名5'),
            'initial_cost5': _('初期費用5'),
            'initial_cost_tax_type5': _('初期費用税種別5'),
            'initial_cost_name6': _('初期費用名6'),
            'initial_cost6': _('初期費用6'),
            'initial_cost_tax_type6': _('初期費用税種別6'),
            'initial_cost_name7': _('初期費用名7'),
            'initial_cost7': _('初期費用7'),
            'initial_cost_tax_type7': _('初期費用税種別7'),
            'initial_cost_name8': _('初期費用名8'),
            'initial_cost8': _('初期費用8'),
            'initial_cost_tax_type8': _('初期費用税種別8'),
            'initial_cost_name9': _('初期費用名9'),
            'initial_cost9': _('初期費用9'),
            'initial_cost_tax_type9': _('初期費用税種別9'),
            'initial_cost_name10': _('初期費用名10'),
            'initial_cost10': _('初期費用10'),
            'initial_cost_tax_type10': _('初期費用税種別10'),
            'initial_cost_note': _('初期費用備考'),
            'free_rent_type': _('フリーレント種別'),
            'free_rent_months': _('フリーレント月数'),
            'free_rent_limit_year': _('フリーレント期限年'),
            'free_rent_limit_month': _('フリーレント期限月'),
            'cancel_notice_limit': _('解約通知期限'),
            'cancel_note': _('解約備考'),
            'short_cancel_note': _('短期解約備考'),
            'cleaning_type': _('退去時清掃種別'),
            'cleaning_cost': _('退去時清掃代'),
            'cleaning_cost_tax_type': _('退去時清掃代税区分'),
            'cleaning_note': _('退去時清掃備考'),
            'special_agreement': _('特約事項'),
            'electric_type': _('電気種別'),
            'electric_comment': _('電気コメント'),
            'gas_type': _('ガス種別'),
            'gas_comment': _('ガスコメント'),
            'bath_type': _('バス種別'),
            'bath_comment': _('バスコメント'),
            'toilet_type': _('トイレ種別'),
            'toilet_comment': _('トイレコメント'),
            'kitchen_range_type': _('キッチンレンジ種別'),
            'kitchen_range_comment': _('キッチンレンジコメント'),
            'internet_type': _('インターネット種別'),
            'internet_comment': _('インターネットコメント'),
            'washer_type': _('洗濯機設置種別'),
            'washer_comment': _('洗濯機設置コメント'),
            'pet_type': _('ペット種別'),
            'pet_comment': _('ペットコメント'),
            'instrument_type': _('楽器許可'),
            'live_together_type': _('同居許可'),
            'children_type': _('子供許可'),
            'share_type': _('ルームシェア許可'),
            'non_japanese_type': _('外国人許可'),
            'only_woman_type': _('女性限定'),
            'only_man_type': _('男性限定'),
            'corp_contract_type': _('法人契約許可'),
            'student_type': _('学生許可'),
            'new_student_type': _('新入生予約許可'),
            'welfare_type': _('福祉許可'),
            'office_use_type': _('事務所利用許可'),
            'constraint_note': _('制約条件備考'),
            'reform_comment': _('リフォームコメント'),
            'reform_year': _('リフォーム実施年'),
            'reform_month': _('リフォーム実施月'),
            'reform_note': _('リフォーム備考'),
            'trader_publish_type': _('業者広告掲載許可'),
            'trader_publish_note': _('業者広告掲載備考'),
            'trader_portal_type': _('業者ポータル掲載許可'),
            'trader_portal_note': _('業者ポータル掲載備考'),
            'ad_type': _('広告料種別'),
            'ad_value': _('広告料値'),
            'ad_tax_type': _('広告料税種別'),
            'trader_ad_type': _('業者広告料種別'),
            'trader_ad_value': _('業者広告料値'),
            'trader_ad_tax_type': _('業者広告料税種別'),
            'owner_fee_type': _('貸主仲介手数料種別'),
            'key_no': _('鍵番号'),
            'key_place_note': _('鍵所在備考'),
            'private_note': _('非公開部屋備考'),
            'management_note': _('管理備考'),
            'is_deleted': _('削除フラグ'),
        }

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

        self.fields['vacancy_status_note'].widget = forms.Textarea()
        self.fields['live_start_note'].widget = forms.Textarea()
        self.fields['cancel_scheduled_note'].widget = forms.Textarea()
        self.fields['vacancy_start_date'].widget = forms.DateInput(attrs={"type": "date"}, format=['%Y-%m-%d'])
        self.fields['vacancy_end_date'].widget = forms.DateInput(attrs={"type": "date"}, format=['%Y-%m-%d'])
        self.fields['vacancy_note'].widget = forms.Textarea()
        self.fields['pending_start_date'].widget = forms.DateInput(attrs={"type": "date"}, format=['%Y-%m-%d'])
        self.fields['pending_end_date'].widget = forms.DateInput(attrs={"type": "date"}, format=['%Y-%m-%d'])
        self.fields['pending_note'].widget = forms.Textarea()
        self.fields['web_note'].widget = forms.Textarea()
        self.fields['layout_note'].widget = forms.Textarea()
        self.fields['monthly_cost_note'].widget = forms.Textarea()
        self.fields['renewal_note'].widget = forms.Textarea()
        self.fields['recontract_note'].widget = forms.Textarea()
        self.fields['initial_cost_note'].widget = forms.Textarea()
        self.fields['cancel_note'].widget = forms.Textarea()
        self.fields['short_cancel_note'].widget = forms.Textarea()
        self.fields['cleaning_note'].widget = forms.Textarea()
        self.fields['special_agreement'].widget = forms.Textarea()
        self.fields['constraint_note'].widget = forms.Textarea()
        self.fields['reform_note'].widget = forms.Textarea()
        self.fields['trader_publish_note'].widget = forms.Textarea()
        self.fields['trader_portal_note'].widget = forms.Textarea()
        self.fields['key_place_note'].widget = forms.Textarea()
        self.fields['private_note'].widget = forms.Textarea()
        self.fields['management_note'].widget = forms.Textarea()
        self.fields['condo_owner'].widget = forms.HiddenInput()
        self.fields['condo_owner'].widget.attrs['v-model'] = 'condoOwner'
        self.fields['condo_trader'].widget = forms.HiddenInput()
        self.fields['condo_trader'].widget.attrs['v-model'] = 'condoTrader'

        for key in self.fields.keys():
            field = self.fields[key]
            field.widget.attrs['ref'] = key
            if isinstance(field.widget, forms.CheckboxInput):
                field.widget.attrs['class'] = 'form-check-input'
            else:
                field.widget.attrs['class'] = 'form-control'

    def clean_pending_start_date(self):
        target_date = self.cleaned_data['pending_start_date']
        if target_date:
            if not re.match(r'^\d{4}-\d{2}-\d{2}$', target_date):
                raise forms.ValidationError('日付はyyyy-mm-ddの形式で入力してください。')
        return target_date

    def clean_pending_end_date(self):
        target_date = self.cleaned_data['pending_end_date']
        if target_date:
            if not re.match(r'^\d{4}-\d{2}-\d{2}$', target_date):
                raise forms.ValidationError('日付はyyyy-mm-ddの形式で入力してください。')
        return target_date

    def clean_vacancy_start_date(self):
        target_date = self.cleaned_data['vacancy_start_date']
        if target_date:
            if not re.match(r'^\d{4}-\d{2}-\d{2}$', target_date):
                raise forms.ValidationError('日付はyyyy-mm-ddの形式で入力してください。')
        return target_date

    def clean_vacancy_end_date(self):
        target_date = self.cleaned_data['vacancy_end_date']
        if target_date:
            if not re.match(r'^\d{4}-\d{2}-\d{2}$', target_date):
                raise forms.ValidationError('日付はyyyy-mm-ddの形式で入力してください。')
        return target_date
