import sys, configparser, time, os

from PyQt5.QtWidgets import (QVBoxLayout, QLineEdit,QGridLayout,
 QApplication, QLabel, QMenu, QWidget, QHBoxLayout,QDialog,
 QAction, QTextEdit,QPushButton, qApp, QMessageBox, QInputDialog,
 QMainWindow, QFrame, QFileDialog, QCheckBox, QProgressBar,
 QListWidget, QCompleter, QComboBox,QRadioButton,QButtonGroup)
from PyQt5.QtGui import (QIcon, QFont, QColor, QPixmap, QDrag, QPainter,
 QBrush, QPen,QStandardItem,QStandardItemModel, QMovie)
from PyQt5.QtCore import (QCoreApplication, Qt, QObject, pyqtSignal,
 QMimeData,pyqtSignal, QMutexLocker, QMutex, QThread)

from mysql_fasttext import Mysql_Fasttext
from vector_initialize import mysql_initialize

class Warning_Window(QWidget):
    def __init__(self, project, mincount, dim, epoch, lr, word_ngram, minn, maxn, method):
        super(Warning_Window, self).__init__()

        self.setWindowFlags(Qt.WindowStaysOnTopHint)

        self.project = project
        self.mincount = mincount
        self.dim = dim
        self.epoch = epoch
        self.lr = lr
        self.word_ngram = word_ngram
        self.minn = minn
        self.maxn = maxn
        self.method = method

        self.warning_window()

    def warning_window(self):
        self.a=QDialog()

        self.a.focusWidget()

        main_v_layout=QVBoxLayout()

        start_button=QPushButton("開始")

        start_button.clicked.connect(lambda: self.start_fasttext(self.project, self.mincount, self.dim, self.epoch,self.lr, self.word_ngram, self.minn, self.maxn, self.method))

        interrupt_button=QPushButton("キャンセル")
        interrupt_button.clicked.connect(self.a.close)



        self.gif_label=QLabel("この処理は時間がかかります。<br>開始してもよろしいですか？")


        main_v_layout.addWidget(start_button)
        main_v_layout.addWidget(interrupt_button)
        main_v_layout.addWidget(self.gif_label)

        self.a.setGeometry(300, 300, 200, 200)
        self.a.setWindowTitle("開始してもよろしいですか？")

        self.a.setLayout(main_v_layout)


    def start_fasttext(self, project, mincount, dim, epoch, lr, word_ngram, minn, maxn, method):
        mysql_initialize(project)
        Mysql_Fasttext(project, mincount, dim, epoch, lr, word_ngram, minn, maxn, method)

        QMessageBox.about(self, '終了しました',"処理が終了しました")
        self.a.close()

    def show(self):
        self.a.exec_()

if __name__=="__main__":
    app=QApplication(sys.argv)
    project="test"
    mincount="1"
    dim="100"
    Warning_Window(project, mincount, dim).show()
    sys.exit(app.exec_())
