############################################################
#
#分析→類似語検索
#
############################################################
import configparser, os, codecs
#from pyfasttext import FastText #windows時はコメントアウト
import numpy as np
#import gensim
from word_count_window import count
from operator import itemgetter

from PyQt5.QtWidgets import QMessageBox, QWidget

class Similar_word_Calcuration():
    def __init__(self, project, wordA, model):
        self.project=project
        self.wordA=wordA
        self.model = model

############################################################
#windows:gensim
#        path = os.getcwd() + "/fasttext/" + project + ".vec"
#        model = gensim.models.KeyedVectors.load_word2vec_format(path, binary=False)

#        self.result = model.most_similar([self.wordA])
############################################################
################windows用:my calcuration

        if os.name == "nt":
            path = os.getcwd() + "/fastText/" + self.project + ".vec"
            f = codecs.open(path, 'r', 'utf-8')
            reader=f.readlines()
            f.close()

            cfg=configparser.ConfigParser()
            file_path = self.selected_project + ".ini"
            cfg.read(file_path)
            dimensions=int(cfg['project']["dimensions"])

            content_check = 0
            min_word = 1
            all_words = count(self.project, content_check, min_word).word_list

            all_word=[]
            for n in all_words:
                all_word.append(n[0])


            if (wordA in all_word) == False:
                self.result = "nothing"

            else:
                all_word.remove(wordA)

                word_array = {}
                for i, n in enumerate(reader):
                    if i == 0:
                        pass
                    else:
                        n = n.split(" ")
                        vec=n[1:dimensions + 1]

                        vector=[]
                        label=n[0]
                        for j in vec:
                            j=float(j)
                            vector.append(j)

                        vector=tuple(vector)
                        vector=np.asarray(vector)
                        a={label:vector}
                        word_array.update(a)

                v1a=word_array[self.wordA]

                res=[]
                for n in all_word:
                    try:
                        v2a=word_array[n]
                        result=(np.dot(v1a,v2a) / (np.linalg.norm(v1a) * np.linalg.norm(v2a)))
                        a=(n, result)
                        res.append(a)
                    except:
                        pass


                res.sort(key=itemgetter(1), reverse=True)
                res=res[0:10]

                b=[]
                for n in res:
                    word = n[0]
                    num = str(n[1])
                    a=(word,num)
                    b.append(a)

                self.result=b

        else:
            #pass   #windows時に使用
############################################################
#pyfasttext用
#            path = os.getcwd() + "/fastText/" + project + ".bin"
#            model = FastText(path)
            model = self.model

            self.result = model.nearest_neighbors(self.wordA, k=10)
############################################################



if __name__=="__main__":
    project="catelabetest"
    wordA="子供連れ"
    wordB="パンダ"
    Similar_word_Calcuration(project, wordA)
