import time, sys, os, configparser
from pyfasttext import FastText

from PyQt5.QtWidgets import (QVBoxLayout, QLineEdit,QGridLayout,
 QApplication, QLabel, QMenu, QWidget, QHBoxLayout,QDialog,
 QAction, QTextEdit,QPushButton, qApp, QMessageBox, QInputDialog,
 QMainWindow, QFrame, QFileDialog, QCheckBox, QProgressBar,
 QListWidget, QCompleter, QComboBox, QTreeView,QAbstractItemView,
 QToolTip,QRadioButton,QButtonGroup, QStyledItemDelegate)
from PyQt5.QtGui import (QIcon, QFont, QColor, QPixmap, QDrag, QPainter,
 QBrush, QPen,QStandardItem,QStandardItemModel)
from PyQt5.QtCore import (QCoreApplication, Qt, QObject, pyqtSignal,
 QMimeData, QAbstractItemModel,QModelIndex)
from PyQt5 import QtCore

from word_data_correlation import Correlation_SubWindow
from word_count_window import Word_Count

class MyModel(QAbstractItemModel):

    #headers = "","",""#head_word
    #items = []

    def __init__(self):#, parent=None):
        super().__init__()


        a=["","データ"]
        self.headers= a
        self.items = []

    def index(self, row, column, parent=QModelIndex()):
        return self.createIndex(row, column, None)

    def parent(self, child):
        return QModelIndex()

    def rowCount(self, parent=QModelIndex()):
        return len(self.items)

    def columnCount(self, parent=QModelIndex()):
        return len(self.headers)

    def data(self, index, role=Qt.DisplayRole):
        if role == Qt.DisplayRole:
            try:
                return self.items[index.row()][index.column()]
            except:
                return
        return

    def headerData(self, section, orientation, role=Qt.DisplayRole):
        if role != Qt.DisplayRole:
            return
        if orientation == Qt.Horizontal:
            return self.headers[section]

    def addRow(self, n):
        #print(n)
        self.beginInsertRows(QModelIndex(), len(self.items), 1)
        #self.items.insert(0,n)
        self.items.append(n)
        self.endInsertRows()

    def remove_all(self):
        self.items.clear()





class Correlation_value_SubWindow(QWidget):
    def __init__(self, project, wordA, wordB, model):
        super().__init__()

        self.project = project
        self.model = model
        self.wordA = wordA
        self.wordB = wordB

        self.correlation_value()

    def correlation_value(self):
        self.w=QDialog()


        value_v_box, label_v_box = self.make_box()

        label_value = QHBoxLayout()
        label_value.addLayout(label_v_box)
        label_value.addLayout(value_v_box)

        process_button=QPushButton("実行")
        process_button.clicked.connect(self.process)

        cancelB=QPushButton("閉じる")
        cancelB.clicked.connect(self.close_window)

        button_h_box = QHBoxLayout()
        button_h_box.addStretch(1)
        button_h_box.addWidget(process_button)
        button_h_box.addWidget(cancelB)

        main_layout = QVBoxLayout()

        main_layout.addLayout(label_value)
        main_layout.addLayout(button_h_box)



        self.w.setGeometry(600, 200, 400, 450)
        self.w.setWindowTitle('外部データを用いた相関分析')

        self.w.setLayout(main_layout)

    def process(self):
        input_data = []
        for n in self.use_value_box:
            try:
                data = float(n.text())
                input_data.append(data)
            except:
                try:
                    data = int(n.text())
                    input_data.append(data)
                except:
                    pass

        if len(input_data) < len(self.use_value_box):
            message=QMessageBox.information(self, "お知らせ","全てのBOXに数字を入力してください", QMessageBox.Ok)
        else:
            subwindow = Correlation_SubWindow(self.project, self.model, self.wordA, self.wordB, input_data) #from word_data_correlation import Correlation_SubWindow
            subwindow.show()
            #print(input_data)



    def make_box(self):
        self.count_words = len(self.wordA)
        value_v_box = QVBoxLayout()
        label_v_box = QVBoxLayout()

        value_box = []
        self.word_01 = QLineEdit()
        self.word_02 = QLineEdit()
        self.word_03 = QLineEdit()
        self.word_04 = QLineEdit()
        self.word_05 = QLineEdit()
        self.word_06 = QLineEdit()
        self.word_07 = QLineEdit()
        self.word_08 = QLineEdit()
        self.word_09 = QLineEdit()
        self.word_10 = QLineEdit()
        self.word_11 = QLineEdit()
        self.word_12 = QLineEdit()
        self.word_13 = QLineEdit()
        self.word_14 = QLineEdit()
        self.word_15 = QLineEdit()
        self.word_16 = QLineEdit()
        self.word_17 = QLineEdit()
        self.word_18 = QLineEdit()
        self.word_19 = QLineEdit()
        self.word_20 = QLineEdit()

        value_box += [self.word_01, self.word_02, self.word_03, self.word_04, self.word_05,
        self.word_06, self.word_07, self.word_08, self.word_09, self.word_10,
        self.word_11, self.word_12, self.word_13, self.word_14, self.word_15,
        self.word_16, self.word_17, self.word_18, self.word_19, self.word_20]

        self.use_value_box = []

        for m, n in enumerate(value_box):
            if m < self.count_words:
                value_v_box.addWidget(n)
                self.use_value_box.append(n)
            else:
                break

        for m, n in enumerate(self.wordA):
            if m < self.count_words:
                label = QLabel(n)
                label_v_box.addWidget(label)
            else:
                break

        return value_v_box, label_v_box

    def show(self):
        self.w.exec_()

    def close_window(self):
        self.w.close()

if __name__=="__main__":
    app=QApplication(sys.argv)
    project="aqua"
    path="./fastText/" + project + ".bin"
    model = FastText(path)
    wordA = ["海遊館", "沖縄美ら海水族館", "鴨川シーワールド", "鳥羽水族館", "名古屋港水族館"]
    wordB = ["夕方", "ジュゴン"]
    Correlation_value_SubWindow(project, wordA, wordB, model).show()
    sys.exit(app.exec_())
