#######################################
#学習済みデータを新規プロジェクトに登録
#######################################

import sys, configparser, os

from PyQt5.QtWidgets import (QVBoxLayout, QLineEdit,QGridLayout,
 QApplication, QLabel, QMenu, QWidget, QHBoxLayout,QDialog,
 QAction, QTextEdit,QPushButton, qApp, QMessageBox, QInputDialog,
 QMainWindow, QFrame, QFileDialog, QCheckBox, QProgressBar,
 QListWidget, QCompleter, QComboBox)
from PyQt5.QtGui import (QIcon, QFont, QColor, QPixmap, QDrag, QPainter,
 QBrush, QPen,QStandardItem,QStandardItemModel)
from PyQt5.QtCore import (QCoreApplication, Qt, QObject, pyqtSignal,
 QMimeData, )

from write_project_ini import write_pro_ini
from mysql_create_database import main_create_database
from mysql_reserved_word import reserved_word_check

class new_project_pre_SubWindow(QWidget):

    ProjectName=""
    FileName=""

    def __init__(self, p):
        super(new_project_pre_SubWindow,self).__init__()

        self.filepath = ""
        self.p = p

        self.open_project()

    def open_project(self):
        self.w=QDialog()

        labelA=QLabel()
        labelA.setText("プロジェクト名を入力してください")

        project_name_label=QLabel()
        project_name_label.setText("プロジェクト名")
        self.project_named=QLineEdit()
        self.project_named.setEnabled(False)

        hbox2=QHBoxLayout()
        hbox2.addWidget(project_name_label)
        hbox2.addWidget(self.project_named)

        label=QLabel()
        label.setText('学習済みモデルの選択')

        select_bin_file=QPushButton("開く")
        select_bin_file.clicked.connect(self.open_file)

        self.file_name=QLineEdit()

        hbox=QHBoxLayout()
        hbox.addWidget(select_bin_file)
        hbox.addWidget(self.file_name)

##############################################################
        cancel=QPushButton("キャンセル")
        cancel.clicked.connect(self.w.close)

        regist=QPushButton("登録")
        regist.clicked.connect(self.regist)

        hbox3=QHBoxLayout()
        hbox3.addStretch(1)
        hbox3.addWidget(regist)
        hbox3.addWidget(cancel)
##############################################################

        layout = QVBoxLayout()
        #layout.addWidget(labelA)
        layout.addLayout(hbox2)
        layout.addStretch(1)
        layout.addWidget(label)
        layout.addLayout(hbox)
        layout.addLayout(hbox3)
        layout.addStretch(1)

        self.w.setLayout(layout)

        self.w.setGeometry(650, 300, 300, 200)
        self.w.setWindowTitle('学習済みモデルの登録')


##############################################################
    def regist(self):
        ch=0
        for n in self.p:
            if self.project_named.text() == n:
                ch += 1
            else:
                pass

        ch2 = reserved_word_check(self.project_named.text())

        if self.project_named.text()=="" or self.filepath=="":
            message=QMessageBox.information(self,"お知らせ",  "存在しません", QMessageBox.Ok)
            #print("ないよ")
        elif ch2 > 0:
            message=QMessageBox.information(self,"お知らせ",  "その単語は予約語のため使用できません", QMessageBox.Ok)
            #print("その単語は予約語のため使用できません")
        elif self.file_name.text() != self.filename_check:
            message=QMessageBox.information(self,"お知らせ",  "ファイル名が一致しません", QMessageBox.Ok)
            #print("ファイル名が一致しません")
        elif ch >0:
            message=QMessageBox.information(self,"お知らせ",  "同名のプロジェクトが存在します", QMessageBox.Ok)
            #print("同名のプロジェクトが存在します")
        else:
            g = open("select_project_temp.txt","w")
            aa=self.project_named.text()
            g.write(aa)
            g.close()

            ##############################################################
            #プロジェクトにiniファイルを登録
            ##############################################################

            write_pro_ini(self.project_named.text()).main(
            original_data_type="1",
            model_path=self.filepath,
            sample="0"
            )   #iniファイルにプロジェクトを登録


            ##############################################################
            #プロジェクトデータベースを作成
            ##############################################################

            main_create_database(self.project_named.text()) #


            self.w.close()
##############################################################


    def open_file(self):
        folder_path = os.getcwd()
        folder_path = folder_path + "/fastText"
        frame=QFileDialog.getOpenFileName(self, "ファイルの選択", folder_path,filter=("bin files(*.bin)"))

        filepath=frame[0]
        self.filepath=filepath
        filename=frame[0].split("/")
        filename=filename[-1]
        self.filename_check=filename
        fi_name = filename.split(".")
        fi_name = fi_name[0]
        self.project_named.setText(fi_name)

        self.file_name.setText(filename)


    def show(self):
        self.w.exec_()

if __name__=="__main__":
    app=QApplication(sys.argv)

    p="aiu"

    ex=new_project_pre_SubWindow(p)
    new_project_pre_SubWindow(p).show()
    sys.exit(app.exec_())
