import numpy as np
from sklearn.manifold import TSNE
from sklearn.decomposition import PCA
from pyfasttext import FastText
import os, platform, datetime
import matplotlib.pyplot as plt
from PIL import Image
from matplotlib.font_manager import FontProperties


def Tsne(project, words, learning_rate, perplexity, init, n_iter, method, pre_reduction, model):
    fp = font(project)

    X, Y = plot_words(model, words)

    if int(pre_reduction) > 0:
        X = PCA(n_components = pre_reduction).fit_transform(X)
    else:
        pass

    X_embedded = TSNE(n_components=2, verbose = 2, learning_rate = learning_rate, perplexity = perplexity, init = init, n_iter = n_iter, method = method).fit_transform(X)

    plot(X_embedded, Y, fp)

def Pca(project, words, model):
    fp = font(project)

    X, Y = plot_words(model, words)

    X_embedded = PCA(n_components=2).fit_transform(X)

    plot(X_embedded, Y, fp)


def plot(X_embedded, Y, fp):
    skip = 0
    limit = len(Y)

    plt.figure()    #matplotの初期化
    plt.scatter(X_embedded[skip:limit,0], X_embedded[skip:limit,1])
    count = 0

    for label , x, y in zip(Y, X_embedded[:,0], X_embedded[:,1]):
        count += 1
        if (count < skip): continue
        plt.annotate(label, xy = (x,y), xytext = (0,0), textcoords='offset points', fontproperties = fp)
        if (count == limit) : break

    today= datetime.datetime.now().strftime('%H%M')
    file_name = "D-reduction_" + today + ".png"

    plt.savefig(file_name)
    img = Image.open(file_name)
    img.show()



def plot_words(model, words):
    X = []
    Y = []

    for word in words:
        append_word_vector = model.get_numpy_vector(word)
        zero_vector_a = np.zeros(append_word_vector.shape[0])
        if np.allclose(append_word_vector, zero_vector_a) != True:
            X.append(append_word_vector)
            Y.append(word)
        else:
            pass

    return X, Y



def font(project):
    if os.name == "posix":
        system_os = platform.system()
        if system_os == "Darwin":
            fp = FontProperties(fname=r'/System/Library/Fonts/ヒラギノ明朝 ProN.ttc')
        else:
            fp = FontProperties(fname=r'/usr/share/fonts/truetype/takao-gothic/TakaoPGothic.ttf')
        return fp
    else:
        pass


if __name__=="__main__":

    #words = ["東京","日本","パリ","フランス","北京","中国","ソウル","韓国","アメリカ", "ワシントン","イギリス", "ロンドン"]
    words = ["距離","土曜日"]
    project="test"

    path = os.getcwd() + "/fastText/" + project + ".bin"
    model = FastText(path)

    #Pca(project, words, model)
    learning_rate = 10.0
    perplexity = 6
    n_iter = 2000
    init = "pca"
    method = "exact"
    pre_reduction = 0
    Tsne(project, words, learning_rate, perplexity, init, n_iter, method, pre_reduction, model)
