//	SRC_Filter - High Quality Audio Sample-Rate-Conversion 
//	Copyright (C) 2001 Andreas Dittrich
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <string.h>


#define N_FILTERORDER 32
#define N_FILTERORDER2 16
#define N_FILTERORDER4 8
#define N_FILTERORDER16 2
#define N_SUBFILTER 256

#define MUL_ACC_SHR 12
#define H_DIGITS 16
#define LINEAR_INTERPOLATION_DIGITS 7	//  MUL_ACC_SHR > LINEAR_INTERPOLATION_DIGITS !!!
#define ROUNDING_OFFSET ( (1<<(H_DIGITS-2-MUL_ACC_SHR+LINEAR_INTERPOLATION_DIGITS)) + \
						  (N_FILTERORDER2<<LINEAR_INTERPOLATION_DIGITS) )


int sample_rate_conversion_HQ_16bit_mono( short int *src, long N_src, short int *dst, long N_dst, 
				short int *h );

int sample_rate_conversion_HQ_16bit_stereo( long *src, long N_src, long *dst, long N_dst, 
				short int *h );

