//	VirtualDub - Video processing and capture application
//	Copyright (C) 1998-2001 Avery Lee
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include <stdio.h>
#include <windows.h>
#include <commdlg.h>
#include "../ClippingControl.h"
#include "../LevelControl.h"
#include "../PositionControl.h"

// functions
bool I18N_Init(void);

HACCEL I18N_LoadAccelerators(
  HINSTANCE hInstance,  // handle to application instance
  LPCTSTR lpTableName   // address of table-name string
);

HICON I18N_LoadIcon(
  HINSTANCE hInstance, // handle to application instance
  LPCTSTR lpIconName   // icon-name string or icon resource 
                       // identifier
);

HMENU I18N_LoadMenu(HINSTANCE hInstance,  LPCTSTR lpMenuName);
int I18N_DialogBox(
	HINSTANCE hInstance,  // handle to application instance
	LPCTSTR lpTemplateName,  // identifies dialog box template
	HWND hWndParent,      // handle to owner window
	DLGPROC lpDialogFunc // pointer to dialog box procedure
);

int I18N_LoadString(
  HINSTANCE hInstance,  // handle to module containing string resource
  UINT uID,             // resource identifier
  LPTSTR lpBuffer,      // pointer to buffer for resource
  int nBufferMax        // size of buffer
);

HWND I18N_CreateDialog(
  HINSTANCE hInstance,  // handle to application instance
  LPCTSTR lpTemplate,   // identifies dialog box template name
  HWND hWndParent,      // handle to owner window
  DLGPROC lpDialogFunc  // pointer to dialog box procedure
);

HWND I18N_CreateDialogParam(
  HINSTANCE hInstance,  // handle to application instance
  LPCTSTR lpTemplateName,  // identifies dialog box template
  HWND hWndParent,      // handle to owner window
  DLGPROC lpDialogFunc, // pointer to dialog box procedure
  LPARAM dwInitParam    // initialization value
);

int I18N_DialogBox(
	HINSTANCE hInstance,  // handle to application instance
	LPCTSTR lpTemplateName,  // identifies dialog box template
	HWND hWndParent,      // handle to owner window
	DLGPROC lpDialogFunc // pointer to dialog box procedure
);

int I18N_DialogBoxParam(
	HINSTANCE hInstance,  // handle to application instance
	LPCTSTR lpTemplateName,  // identifies dialog box template
	HWND hWndParent,      // handle to owner window
	DLGPROC lpDialogFunc, // pointer to dialog box procedure
	LPARAM dwInitParam    // initialization value
);

BOOL I18N_GetOpenFileName(
  LPOPENFILENAME lpofn   // address of structure with initialization 
                         // data
);

BOOL I18N_GetSaveFileName(
  LPOPENFILENAME lpofn   // address of structure with initialization                          
						 // data
);

HGLOBAL LoadStuff(
  HINSTANCE hInstance,  // handle to module containing stuff resource
  LPCTSTR uID             // resource identifier
);

// variables
static HMODULE s_hResDll;

/*
 * body
 */
bool I18N_Init(void)
{
	bool rc = true;
	int n = 0;
	char language_code[10];
	char dll_name[20];

	// get language code (ISO639x 3-letter code) from system default locale
	n = GetLocaleInfo(LOCALE_SYSTEM_DEFAULT, 
		LOCALE_SABBREVLANGNAME, (LPTSTR)language_code, 10);
	if (n == 0) {
		return false;
	}
	sprintf(dll_name, "Res%s.dll", language_code);

	// Load localized resource dll
	s_hResDll = LoadLibrary(dll_name);
	if (s_hResDll != NULL) {
		if (RegisterClippingControl(s_hResDll) == NULL) {
			rc = false;
		}
		if (RegisterPositionControl(s_hResDll) == NULL) {
			rc = false;
		}
		if (RegisterLevelControl(s_hResDll) == NULL) {
			rc = false;
		}
	}

	return rc;
}

HACCEL I18N_LoadAccelerators(
  HINSTANCE hInstance,  // handle to application instance
  LPCTSTR lpTableName   // address of table-name string
)
{
	HACCEL rc = NULL;

	if (s_hResDll == NULL) {
		rc = LoadAccelerators(hInstance, lpTableName);
	} else {
		rc = LoadAccelerators(s_hResDll, lpTableName);
		if (rc == NULL) {
			rc = LoadAccelerators(hInstance, lpTableName);
		}
	}

	return rc;
}

HICON I18N_LoadIcon(
  HINSTANCE hInstance, // handle to application instance
  LPCTSTR lpIconName   // icon-name string or icon resource 
                       // identifier
)
{
	HICON rc = NULL;

	if (s_hResDll == NULL) {
		rc = LoadIcon(hInstance, lpIconName);
	} else {
		rc = LoadIcon(s_hResDll, lpIconName);
		if (rc == NULL) {
			rc = LoadIcon(hInstance, lpIconName);
		}
	}

	return rc;
}

HMENU I18N_LoadMenu(HINSTANCE hInstance,  LPCTSTR lpMenuName)
{
	HMENU rc = NULL;

	if (s_hResDll == NULL) {
		rc = LoadMenu(hInstance, lpMenuName);
	} else {
		rc = LoadMenu(s_hResDll, lpMenuName);
		if (rc == NULL) {
			rc = LoadMenu(hInstance, lpMenuName);
		}
	}

	return rc;
}

int I18N_LoadString(
  HINSTANCE hInstance,  // handle to module containing string resource
  UINT uID,             // resource identifier
  LPTSTR lpBuffer,      // pointer to buffer for resource
  int nBufferMax        // size of buffer
)
{
	int rc = 0;

	if (s_hResDll == NULL) {
		rc = LoadString(hInstance, uID, lpBuffer, nBufferMax);
	} else {
		rc = LoadString(s_hResDll, uID, lpBuffer, nBufferMax);
		if (rc == 0) {
			rc = LoadString(hInstance, uID, lpBuffer, nBufferMax);
		}
	}

	return rc;
}

HWND I18N_CreateDialog(
  HINSTANCE hInstance,  // handle to application instance
  LPCTSTR lpTemplate,   // identifies dialog box template name
  HWND hWndParent,      // handle to owner window
  DLGPROC lpDialogFunc  // pointer to dialog box procedure
)
{
	HWND rc = NULL;

	if (s_hResDll == NULL) {
		rc = CreateDialog(hInstance, lpTemplate, hWndParent, lpDialogFunc);
	} else {
		rc = CreateDialog(s_hResDll, lpTemplate, hWndParent, lpDialogFunc);
		if (rc == NULL) {
			rc = CreateDialog(hInstance, lpTemplate, hWndParent, lpDialogFunc);
		}
	}

	return rc;
}

HWND I18N_CreateDialogParam(
  HINSTANCE hInstance,  // handle to application instance
  LPCTSTR lpTemplateName,  // identifies dialog box template
  HWND hWndParent,      // handle to owner window
  DLGPROC lpDialogFunc, // pointer to dialog box procedure
  LPARAM dwInitParam    // initialization value
)
{
	HWND rc = NULL;

	if (s_hResDll == NULL) {
		rc = CreateDialogParam(hInstance, lpTemplateName, hWndParent, lpDialogFunc, dwInitParam);
	} else {
		rc = CreateDialogParam(s_hResDll, lpTemplateName, hWndParent, lpDialogFunc, dwInitParam);
		if (rc == NULL) {
			rc = CreateDialogParam(hInstance, lpTemplateName, hWndParent, lpDialogFunc, dwInitParam);
		}
	}

	return rc;
}

int I18N_DialogBox(
	HINSTANCE hInstance,  // handle to application instance
	LPCTSTR lpTemplateName,  // identifies dialog box template
	HWND hWndParent,      // handle to owner window
	DLGPROC lpDialogFunc // pointer to dialog box procedure
)
{
	int rc = 0;

	if (s_hResDll == NULL) {
		rc = DialogBox(hInstance, lpTemplateName, hWndParent, lpDialogFunc);
	} else {
		HRSRC h = NULL;
		h = FindResource(s_hResDll, lpTemplateName, RT_DIALOG);
		if (h != NULL) {
			rc = DialogBox(s_hResDll, lpTemplateName, hWndParent, lpDialogFunc);
		} else {
			rc = DialogBox(hInstance, lpTemplateName, hWndParent, lpDialogFunc);
		}
	}

	return rc;
}

int I18N_DialogBoxParam(
	HINSTANCE hInstance,  // handle to application instance
	LPCTSTR lpTemplateName,  // identifies dialog box template
	HWND hWndParent,      // handle to owner window
	DLGPROC lpDialogFunc, // pointer to dialog box procedure
	LPARAM dwInitParam    // initialization value
)
{
	int rc = 0;

	if (s_hResDll == NULL) {
		rc = DialogBoxParam(hInstance, lpTemplateName, hWndParent, lpDialogFunc, dwInitParam);
	} else {
		HRSRC h = NULL;
		h = FindResource(s_hResDll, lpTemplateName, RT_DIALOG);
		if (h != NULL) {
			rc = DialogBoxParam(s_hResDll, lpTemplateName, hWndParent, lpDialogFunc, dwInitParam);
		} else {
			rc = DialogBoxParam(hInstance, lpTemplateName, hWndParent, lpDialogFunc, dwInitParam);
		}
	}

	return rc;
}

BOOL I18N_GetOpenFileName(
  LPOPENFILENAME lpofn   // address of structure with initialization 
                         // data
)
{
	BOOL rc = false;

	if (s_hResDll == NULL) {
		rc = GetOpenFileName(lpofn);
	} else {
		if (((lpofn->Flags | OFN_ENABLETEMPLATEHANDLE) != 0) || 
			((lpofn->Flags | OFN_ENABLETEMPLATE) != 0)) {
			HRSRC h = NULL;
			h = FindResource(s_hResDll, lpofn->lpTemplateName, RT_DIALOG);
			if (h != NULL) {
				lpofn->hInstance = s_hResDll;
			}
		}
		rc = GetOpenFileName(lpofn);
	}

	return rc;
}

BOOL I18N_GetSaveFileName(
  LPOPENFILENAME lpofn   // address of structure with initialization                          
						 // data
)
{
	BOOL rc = false;

	if (s_hResDll == NULL) {
		rc = GetSaveFileName(lpofn);
	} else {
		if (((lpofn->Flags | OFN_ENABLETEMPLATEHANDLE) != 0) || 
			((lpofn->Flags | OFN_ENABLETEMPLATE) != 0)) {
			HRSRC h = NULL;
			h = FindResource(s_hResDll, lpofn->lpTemplateName, RT_DIALOG);
			if (h != NULL) {
				lpofn->hInstance = s_hResDll;
			}
		}
		rc = GetSaveFileName(lpofn);
	}

	return rc;
}

HGLOBAL LoadStuff(
  HINSTANCE hInstance,  // handle to module containing stuff resource
  LPCTSTR uID             // resource identifier
)
{
	HGLOBAL rc = NULL;
	HRSRC hRsrc = NULL;

	if (s_hResDll == NULL) {
		hRsrc = FindResource(hInstance, uID, "STUFF");
		if (hRsrc != NULL) {
			rc = LoadResource(hInstance, hRsrc);
		}
	} else {
		hRsrc = FindResource(s_hResDll, uID, "STUFF");
		if (hRsrc != NULL) {
			rc = LoadResource(s_hResDll, hRsrc);
		} else {
			hRsrc = FindResource(hInstance, uID, "STUFF");
			if (hRsrc != NULL) {
				rc = LoadResource(hInstance, hRsrc);
			}
		}
	}

	return rc;
}

